/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.ArrayList;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestRandomQueries
extends AbstractJqlFuncTest {
    public void testJqlMultipleValuesWithEmpty() throws Exception {
        this.administration.restoreData("TestJqlMultipleValuesWithEmpty.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().createSearch("\"number\" = echo(9, none)");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-12", "MKY-11");
        this.navigation.issueNavigator().createSearch("duedate = echo(\"0009/9/9\", none)");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-11");
        this.navigation.issueNavigator().createSearch("\"number\" != echo(9, none)");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-10");
        this.navigation.issueNavigator().createSearch("duedate != echo(\"0009/9/9\", none)");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-12", "MKY-10");
        this.navigation.issueNavigator().createSearch("\"number\" = echo(9, 10) order by key desc");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("MKY-12", "MKY-10");
    }

    public void testJqlPrecendenceOfAndOrNot() throws Exception {
        this.administration.restoreData("TestRandomQueries.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        List<String> homosapienIssueKeys = CollectionBuilder.newBuilder("HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1").asList();
        List<String> monkeyIssueKeys = CollectionBuilder.newBuilder("MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1").asList();
        String MKY_1_HSP_1JQL = "affectedVersion IS EMPTY AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_2_HSP_2JQL = "affectedVersion IS NOT EMPTY AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_3_HSP_3JQL = "assignee IS NOT EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_4_HSP_4JQL = "component IS NOT EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_5_HSP_5JQL = "description IS NOT EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_6_HSP_6JQL = "environment IS NOT EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_7_HSP_7JQL = "fixVersion IS NOT EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_8_HSP_8JQL = "level IS NOT EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY";
        String MKY_9_HSP_9JQL = "originalEstimate IS NOT EMPTY AND reporter IS EMPTY";
        String MKY_10_HSP_10JQL = "reporter IS NOT EMPTY";
        ArrayList<String> resultIssueKeys = new ArrayList<String>();
        resultIssueKeys.addAll(monkeyIssueKeys);
        resultIssueKeys.addAll(homosapienIssueKeys);
        this.assertSearchWithResults(MKY_1_HSP_1JQL + " OR " + MKY_2_HSP_2JQL + " OR " + MKY_3_HSP_3JQL + " OR " + MKY_4_HSP_4JQL + " OR " + MKY_5_HSP_5JQL + " OR " + MKY_6_HSP_6JQL + " OR " + MKY_7_HSP_7JQL + " OR " + MKY_8_HSP_8JQL + " OR " + MKY_9_HSP_9JQL + " OR " + MKY_10_HSP_10JQL, resultIssueKeys.toArray(new String[0]));
        this.assertSearchWithResults(MKY_1_HSP_1JQL + " OR " + MKY_9_HSP_9JQL + " OR " + MKY_10_HSP_10JQL, "MKY-10", "MKY-9", "MKY-1", "HSP-10", "HSP-9", "HSP-1");
        this.assertSearchWithResults("affectedVersion IS EMPTY OR affectedVersion = \"New Version 1\" AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY ", "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults("affectedVersion = \"New Version 1\" AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY ", "MKY-2", "HSP-2");
        this.assertSearchWithResults("(" + MKY_1_HSP_1JQL + " ) OR (  (" + MKY_2_HSP_2JQL + ") OR ( " + MKY_3_HSP_3JQL + " )  )", "MKY-3", "MKY-2", "MKY-1", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("( (" + MKY_1_HSP_1JQL + " ) OR   (" + MKY_2_HSP_2JQL + ") ) OR ( " + MKY_3_HSP_3JQL + " )  ", "MKY-3", "MKY-2", "MKY-1", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("(reporter IS NOT EMPTY AND level IS NOT EMPTY) AND originalEstimate IS NOT EMPTY", "MKY-10", "HSP-10");
        this.assertSearchWithResults("reporter IS NOT EMPTY AND (level IS NOT EMPTY AND originalEstimate IS NOT EMPTY)", "MKY-10", "HSP-10");
        this.assertSearchWithResults(MKY_9_HSP_9JQL + " OR " + MKY_10_HSP_10JQL, "MKY-10", "MKY-9", "HSP-10", "HSP-9");
        this.assertSearchWithResults(MKY_10_HSP_10JQL + " OR " + MKY_9_HSP_9JQL, "MKY-10", "MKY-9", "HSP-10", "HSP-9");
        this.assertSearchWithResults(MKY_7_HSP_7JQL + " OR ( " + MKY_7_HSP_7JQL + " AND " + MKY_9_HSP_9JQL + " )", "MKY-7", "HSP-7");
        this.assertSearchWithResults(MKY_7_HSP_7JQL + " AND ( " + MKY_7_HSP_7JQL + " OR " + MKY_9_HSP_9JQL + " )", "MKY-7", "HSP-7");
        this.assertSearchWithResults(MKY_1_HSP_1JQL + " OR ( " + MKY_2_HSP_2JQL + " AND " + MKY_10_HSP_10JQL + " )", "MKY-1", "HSP-1");
        this.assertSearchWithResults("( " + MKY_1_HSP_1JQL + " OR " + MKY_2_HSP_2JQL + ") AND (" + MKY_1_HSP_1JQL + " OR " + MKY_10_HSP_10JQL + " )", "MKY-1", "HSP-1");
        this.assertSearchWithResults(MKY_10_HSP_10JQL + " OR reporter IS EMPTY", resultIssueKeys.toArray(new String[resultIssueKeys.size()]));
        this.assertSearchWithResults(MKY_10_HSP_10JQL + " AND reporter IS EMPTY", new String[0]);
        this.assertSearchWithResults(MKY_8_HSP_8JQL + " OR " + MKY_8_HSP_8JQL, "MKY-8", "HSP-8");
        this.assertSearchWithResults(MKY_8_HSP_8JQL + " AND " + MKY_8_HSP_8JQL, "MKY-8", "HSP-8");
        String JQL_P = "(not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\"))";
        String JQL_Q = "resolution in (\"Fixed\", \"Won't Fix\", \"Duplicate\", \"Incomplete\")";
        this.assertSearchWithResults("(not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\")) OR resolution in (\"Fixed\", \"Won't Fix\", \"Duplicate\", \"Incomplete\")", "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("NOT ( (not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\")) OR resolution in (\"Fixed\", \"Won't Fix\", \"Duplicate\", \"Incomplete\") )", "HSP-5");
        this.assertSearchWithResults("( NOT ( (not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\")) ) ) AND ( NOT (resolution in (\"Fixed\", \"Won't Fix\", \"Duplicate\", \"Incomplete\")) )", "HSP-5");
        String negatedQuery = "not ( ((not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\"))) AND (resolution in (\"Fixed\", \"Won't Fix\",\"Duplicate\", \"Incomplete\")))";
        String nonnegatedQuery = "((assignee is not empty AND affectedversion != \"New Version 1\") OR Description !~ \"Blub\" OR (status != \"Open\" AND originalEstimate is empty AND resolution != \"Duplicate\" AND issuekey != \"MKY-5\")) or (resolution not in (\"Fixed\", \"Won't Fix\", \"Duplicate\",\"Incomplete\")   )";
        this.assertSearchWithResults(negatedQuery, "MKY-5", "MKY-4", "MKY-2", "MKY-1", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.assertSearchWithResults(nonnegatedQuery, "MKY-5", "MKY-4", "MKY-2", "MKY-1", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.assertSearchWithResults("NOT ( ((not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\"))) AND (resolution in (\"Fixed\", \"Won't Fix\", \"Duplicate\", \"Incomplete\")) )", "MKY-5", "MKY-4", "MKY-2", "MKY-1", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.assertSearchWithResults("( NOT ( (not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\")) ) ) OR ( NOT (resolution in (\"Fixed\", \"Won't Fix\", \"Duplicate\", \"Incomplete\")) )", "MKY-5", "MKY-4", "MKY-2", "MKY-1", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        String JQL = "description is not empty AND assignee = \"admin\"";
        this.assertSearchWithResults("not ( " + JQL + " )", "MKY-4", "MKY-3", "MKY-2", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults(JQL, "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5");
        this.assertSearchWithResults("reporter IS NOT EMPTY OR originalEstimate IS NOT EMPTY", "MKY-10", "MKY-9", "HSP-10", "HSP-9");
        this.assertSearchWithResults("NOT (reporter IS EMPTY AND originalEstimate IS EMPTY)", "MKY-10", "MKY-9", "HSP-10", "HSP-9");
        this.assertSearchWithResults("(not (not assignee is empty) or affectedversion = \"New Version 1\") and Description ~ \"Blub\" and (status = \"Open\" or ((originalEstimate is not empty or resolution = \"Duplicate\") or issuekey = \"MKY-5\"))", "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6");
    }
}

