/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestJqlAttachmentsField
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestJqlAttachments.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testAllIssuesWithAttachments() {
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY");
        this.assertIssues("NUMBER-2", "MKY-3", "HSP-3");
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY AND project = MKY");
        this.assertIssues("MKY-3");
    }

    public void testIssuesWithoutAttachments() {
        this.navigation.issueNavigator().createSearch("attachments is EMPTY");
        this.assertIssues("NUMBER-1", "MKY-2", "MKY-1", "MK-2", "MK-1", "HSP-4", "HSP-1");
    }

    public void testDisableAttachments() {
        this.backdoor.attachments().disable();
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY");
        this.assertIssues("NUMBER-2", "MKY-3", "HSP-3");
        this.navigation.issueNavigator().createSearch("attachments is EMPTY");
        this.assertIssues("NUMBER-1", "MKY-2", "MKY-1", "MK-2", "MK-1", "HSP-4", "HSP-1");
        this.backdoor.attachments().enable();
    }

    public void testRemovingAttachments() {
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY");
        this.assertIssues("NUMBER-2", "MKY-3", "HSP-3", "HSP-2");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLink("manage-attachment-link");
        this.tester.clickLink("del_10002");
        this.tester.submit("Delete");
        this.navigation.issueNavigator().createSearch("attachments is EMPTY AND issuekey = HSP-2");
        this.assertIssues("HSP-2");
    }

    public void testInvalidJqlQuery() {
        this.assertTooComplex("attachments is \"file.png\"");
        this.assertTooComplex("attachments is not empt");
        this.assertTooComplex("attachments is empt");
        this.assertTooComplex("attachments = empt");
        this.assertTooComplex("attachments != empt");
    }
}

