/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.SystemTenantOnly;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@SystemTenantOnly
@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestCustomFieldsDisabled
extends FuncTestCase {
    @Override
    protected void tearDownTest() {
        this.administration.plugins().enablePlugin("com.atlassian.jira.plugin.system.customfieldtypes");
        super.tearDownTest();
    }

    public void testDisable() throws Exception {
        String[] customFields;
        this.administration.restoreData("TestCustomFieldOperators.xml");
        for (String cf : customFields = new String[]{"CSF", "DP", "DT", "FTF", "GP", "II", "MC", "MGP", "MS", "MUP", "NF", "PP", "RB", "ROTF", "SL", "SVP", "TF", "UP", "URL", "VP"}) {
            this.navigation.issueNavigator().createSearch(String.format("%s is not empty", cf));
            this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        }
        this.navigation.gotoAdmin();
        this.administration.plugins().disablePlugin("com.atlassian.jira.plugin.system.customfieldtypes");
        for (String cf : customFields) {
            this.issueTableAssertions.assertSearchWithError(String.format("%s is not empty", cf), String.format("Field '%s' does not exist or you do not have permission to view it.", cf));
        }
    }
}

