/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@Splitable
@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestCustomFieldOperatorUsage
extends FuncTestCase {
    private static final ThreadLocal<AtomicBoolean> dataSetUp = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };

    @Override
    protected void setUpTest() {
        super.setUpTest();
        if (!dataSetUp.get().getAndSet(true)) {
            this.administration.restoreData("TestCustomFieldOperators.xml");
            this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        }
    }

    public void testCascadingSelect() throws Exception {
        String fieldName = "CSF";
        String projKey = "ONE";
        String singleLit = "'child'";
        String listLit = "('child', 'child2')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'child'", new String[]{"ONE-3"}));
        matrix.put("!=", new Result("'child'", new String[]{"ONE-4", "ONE-2"}));
        matrix.put("in", new Result("('child', 'child2')", new String[]{"ONE-4", "ONE-3"}));
        matrix.put("not in", new Result("('child', 'child2')", new String[]{"ONE-2"}));
        matrix.put("is", new Result("EMPTY", new String[]{"ONE-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"ONE-4", "ONE-3", "ONE-2"}));
        matrix.put("~", Result.error("'child'"));
        matrix.put("!~", Result.error("'child'"));
        matrix.put("<", Result.error("'child'"));
        matrix.put("<=", Result.error("'child'"));
        matrix.put(">", Result.error("'child'"));
        matrix.put(">=", Result.error("'child'"));
        this._testOperatorMatrix("CSF", "ONE", matrix);
    }

    public void testDatePicker() throws Exception {
        String fieldName = "DP";
        String projKey = "TWO";
        String singleLit = "'2009-05-13'";
        String listLit = "('2009-05-11', '2009-05-13')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-13'", new String[]{"TWO-3"}));
        matrix.put("!=", new Result("'2009-05-13'", new String[]{"TWO-4", "TWO-2"}));
        matrix.put("in", new Result("('2009-05-11', '2009-05-13')", new String[]{"TWO-3", "TWO-2"}));
        matrix.put("not in", new Result("('2009-05-11', '2009-05-13')", new String[]{"TWO-4"}));
        matrix.put("is", new Result("EMPTY", new String[]{"TWO-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"TWO-4", "TWO-3", "TWO-2"}));
        matrix.put("~", Result.error("'2009-05-13'"));
        matrix.put("!~", Result.error("'2009-05-13'"));
        matrix.put("<", new Result("'2009-05-13'", new String[]{"TWO-2"}));
        matrix.put("<=", new Result("'2009-05-13'", new String[]{"TWO-3", "TWO-2"}));
        matrix.put(">", new Result("'2009-05-13'", new String[]{"TWO-4"}));
        matrix.put(">=", new Result("'2009-05-13'", new String[]{"TWO-4", "TWO-3"}));
        this._testOperatorMatrix("DP", "TWO", matrix);
    }

    public void testDateTime() throws Exception {
        String fieldName = "DT";
        String projKey = "THREE";
        String singleLit = "'2009-05-11 12:00'";
        String listLit = "('2009-05-11 09:00', '2009-05-11 12:00')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-11 12:00'", new String[]{"THREE-3"}));
        matrix.put("!=", new Result("'2009-05-11 12:00'", new String[]{"THREE-4", "THREE-2"}));
        matrix.put("in", new Result("('2009-05-11 09:00', '2009-05-11 12:00')", new String[]{"THREE-3", "THREE-2"}));
        matrix.put("not in", new Result("('2009-05-11 09:00', '2009-05-11 12:00')", new String[]{"THREE-4"}));
        matrix.put("is", new Result("EMPTY", new String[]{"THREE-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"THREE-4", "THREE-3", "THREE-2"}));
        matrix.put("~", Result.error("'2009-05-11 12:00'"));
        matrix.put("!~", Result.error("'2009-05-11 12:00'"));
        matrix.put("<", new Result("'2009-05-11 12:00'", new String[]{"THREE-2"}));
        matrix.put("<=", new Result("'2009-05-11 12:00'", new String[]{"THREE-3", "THREE-2"}));
        matrix.put(">", new Result("'2009-05-11 12:00'", new String[]{"THREE-4"}));
        matrix.put(">=", new Result("'2009-05-11 12:00'", new String[]{"THREE-4", "THREE-3"}));
        this._testOperatorMatrix("DT", "THREE", matrix);
    }

    public void testFreeTextField() throws Exception {
        String fieldName = "FTF";
        String projKey = "FOUR";
        String singleLit = "fun";
        String listLit = "(fun)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("fun"));
        matrix.put("!=", Result.error("fun"));
        matrix.put("in", Result.error("(fun)"));
        matrix.put("not in", Result.error("(fun)"));
        matrix.put("is", new Result("EMPTY", new String[]{"FOUR-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"FOUR-3", "FOUR-2"}));
        matrix.put("~", new Result("fun", new String[]{"FOUR-2"}));
        matrix.put("!~", new Result("fun", new String[]{"FOUR-3"}));
        matrix.put("<", Result.error("fun"));
        matrix.put("<=", Result.error("fun"));
        matrix.put(">", Result.error("fun"));
        matrix.put(">=", Result.error("fun"));
        this._testOperatorMatrix("FTF", "FOUR", matrix);
    }

    public void testGroupPicker() throws Exception {
        String fieldName = "GP";
        String projKey = "FIVE";
        String singleLit = "'jira-users'";
        String listLit = "('jira-users', 'jira-administrators')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'jira-users'", new String[]{"FIVE-2"}));
        matrix.put("!=", new Result("'jira-users'", new String[]{"FIVE-3"}));
        matrix.put("in", new Result("('jira-users', 'jira-administrators')", new String[]{"FIVE-3", "FIVE-2"}));
        matrix.put("not in", new Result("('jira-users', 'jira-administrators')", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"FIVE-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"FIVE-3", "FIVE-2"}));
        matrix.put("~", Result.error("'jira-users'"));
        matrix.put("!~", Result.error("'jira-users'"));
        matrix.put("<", Result.error("'jira-users'"));
        matrix.put("<=", Result.error("'jira-users'"));
        matrix.put(">", Result.error("'jira-users'"));
        matrix.put(">=", Result.error("'jira-users'"));
        this._testOperatorMatrix("GP", "FIVE", matrix);
    }

    public void testImportId() throws Exception {
        String fieldName = "II";
        String projKey = "SIX";
        String singleLit = "4";
        String listLit = "(2, 4)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("4", new String[]{"SIX-3"}));
        matrix.put("!=", new Result("4", new String[]{"SIX-4", "SIX-2"}));
        matrix.put("in", new Result("(2, 4)", new String[]{"SIX-3", "SIX-2"}));
        matrix.put("not in", new Result("(2, 4)", new String[]{"SIX-4"}));
        matrix.put("is", new Result("EMPTY", new String[]{"SIX-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"SIX-4", "SIX-3", "SIX-2"}));
        matrix.put("~", Result.error("4"));
        matrix.put("!~", Result.error("4"));
        matrix.put("<", new Result("4", new String[]{"SIX-2"}));
        matrix.put("<=", new Result("4", new String[]{"SIX-3", "SIX-2"}));
        matrix.put(">", new Result("4", new String[]{"SIX-4"}));
        matrix.put(">=", new Result("4", new String[]{"SIX-4", "SIX-3"}));
        this._testOperatorMatrix("II", "SIX", matrix);
    }

    public void testMultiCheckboxes() throws Exception {
        String fieldName = "MC";
        String projKey = "SEVEN";
        String singleLit = "opt1";
        String listLit = "(opt1, opt2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("opt1", new String[]{"SEVEN-4", "SEVEN-2"}));
        matrix.put("!=", new Result("opt1", new String[]{"SEVEN-3"}));
        matrix.put("in", new Result("(opt1, opt2)", new String[]{"SEVEN-4", "SEVEN-3", "SEVEN-2"}));
        matrix.put("not in", new Result("(opt1, opt2)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"SEVEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"SEVEN-4", "SEVEN-3", "SEVEN-2"}));
        matrix.put("~", Result.error("opt1"));
        matrix.put("!~", Result.error("opt1"));
        matrix.put("<", Result.error("opt1"));
        matrix.put("<=", Result.error("opt1"));
        matrix.put(">", Result.error("opt1"));
        matrix.put(">=", Result.error("opt1"));
        this._testOperatorMatrix("MC", "SEVEN", matrix);
    }

    public void testMultiGroupPicker() throws Exception {
        String fieldName = "MGP";
        String projKey = "EIGHT";
        String singleLit = "'jira-users'";
        String listLit = "('jira-users', 'jira-administrators')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'jira-users'", new String[]{"EIGHT-4", "EIGHT-2"}));
        matrix.put("!=", new Result("'jira-users'", new String[]{"EIGHT-3"}));
        matrix.put("in", new Result("('jira-users', 'jira-administrators')", new String[]{"EIGHT-4", "EIGHT-3", "EIGHT-2"}));
        matrix.put("not in", new Result("('jira-users', 'jira-administrators')", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"EIGHT-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"EIGHT-4", "EIGHT-3", "EIGHT-2"}));
        matrix.put("~", Result.error("'jira-users'"));
        matrix.put("!~", Result.error("'jira-users'"));
        matrix.put("<", Result.error("'jira-users'"));
        matrix.put("<=", Result.error("'jira-users'"));
        matrix.put(">", Result.error("'jira-users'"));
        matrix.put(">=", Result.error("'jira-users'"));
        this._testOperatorMatrix("MGP", "EIGHT", matrix);
    }

    public void testMultiSelect() throws Exception {
        String fieldName = "MS";
        String projKey = "NINE";
        String singleLit = "select1";
        String listLit = "(select1, select2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("select1", new String[]{"NINE-4", "NINE-2"}));
        matrix.put("!=", new Result("select1", new String[]{"NINE-3"}));
        matrix.put("in", new Result("(select1, select2)", new String[]{"NINE-4", "NINE-3", "NINE-2"}));
        matrix.put("not in", new Result("(select1, select2)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"NINE-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"NINE-4", "NINE-3", "NINE-2"}));
        matrix.put("~", Result.error("select1"));
        matrix.put("!~", Result.error("select1"));
        matrix.put("<", Result.error("select1"));
        matrix.put("<=", Result.error("select1"));
        matrix.put(">", Result.error("select1"));
        matrix.put(">=", Result.error("select1"));
        this._testOperatorMatrix("MS", "NINE", matrix);
    }

    public void testMultiUserPicker() throws Exception {
        String fieldName = "MUP";
        String projKey = "TEN";
        String singleLit = "fred";
        String listLit = "(fred, admin)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("fred", new String[]{"TEN-4", "TEN-2"}));
        matrix.put("!=", new Result("fred", new String[]{"TEN-3"}));
        matrix.put("in", new Result("(fred, admin)", new String[]{"TEN-4", "TEN-3", "TEN-2"}));
        matrix.put("not in", new Result("(fred, admin)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"TEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"TEN-4", "TEN-3", "TEN-2"}));
        matrix.put("~", Result.error("fred"));
        matrix.put("!~", Result.error("fred"));
        matrix.put("<", Result.error("fred"));
        matrix.put("<=", Result.error("fred"));
        matrix.put(">", Result.error("fred"));
        matrix.put(">=", Result.error("fred"));
        this._testOperatorMatrix("MUP", "TEN", matrix);
    }

    public void testNumberField() throws Exception {
        String fieldName = "NF";
        String projKey = "ELEVEN";
        String singleLit = "20";
        String listLit = "(10, 20)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("20", new String[]{"ELEVEN-3"}));
        matrix.put("!=", new Result("20", new String[]{"ELEVEN-4", "ELEVEN-2"}));
        matrix.put("in", new Result("(10, 20)", new String[]{"ELEVEN-3", "ELEVEN-2"}));
        matrix.put("not in", new Result("(10, 20)", new String[]{"ELEVEN-4"}));
        matrix.put("is", new Result("EMPTY", new String[]{"ELEVEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"ELEVEN-4", "ELEVEN-3", "ELEVEN-2"}));
        matrix.put("~", Result.error("20"));
        matrix.put("!~", Result.error("20"));
        matrix.put("<", new Result("20", new String[]{"ELEVEN-2"}));
        matrix.put("<=", new Result("20", new String[]{"ELEVEN-3", "ELEVEN-2"}));
        matrix.put(">", new Result("20", new String[]{"ELEVEN-4"}));
        matrix.put(">=", new Result("20", new String[]{"ELEVEN-4", "ELEVEN-3"}));
        this._testOperatorMatrix("NF", "ELEVEN", matrix);
    }

    public void testProjectPicker() throws Exception {
        String fieldName = "PP";
        String projKey = "TWELVE";
        String singleLit = "three";
        String listLit = "(three, four)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("three", new String[]{"TWELVE-2"}));
        matrix.put("!=", new Result("three", new String[]{"TWELVE-3"}));
        matrix.put("in", new Result("(three, four)", new String[]{"TWELVE-3", "TWELVE-2"}));
        matrix.put("not in", new Result("(three, four)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"TWELVE-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"TWELVE-3", "TWELVE-2"}));
        matrix.put("~", Result.error("three"));
        matrix.put("!~", Result.error("three"));
        matrix.put("<", Result.error("three"));
        matrix.put("<=", Result.error("three"));
        matrix.put(">", Result.error("three"));
        matrix.put(">=", Result.error("three"));
        this._testOperatorMatrix("PP", "TWELVE", matrix);
    }

    public void testRadioButton() throws Exception {
        String fieldName = "RB";
        String projKey = "THIRTEEN";
        String singleLit = "rad1";
        String listLit = "(rad1, rad2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("rad1", new String[]{"THIRTEEN-2"}));
        matrix.put("!=", new Result("rad1", new String[]{"THIRTEEN-3"}));
        matrix.put("in", new Result("(rad1, rad2)", new String[]{"THIRTEEN-3", "THIRTEEN-2"}));
        matrix.put("not in", new Result("(rad1, rad2)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"THIRTEEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"THIRTEEN-3", "THIRTEEN-2"}));
        matrix.put("~", Result.error("rad1"));
        matrix.put("!~", Result.error("rad1"));
        matrix.put("<", Result.error("rad1"));
        matrix.put("<=", Result.error("rad1"));
        matrix.put(">", Result.error("rad1"));
        matrix.put(">=", Result.error("rad1"));
        this._testOperatorMatrix("RB", "THIRTEEN", matrix);
    }

    public void testReadOnlyTextField() throws Exception {
        String fieldName = "ROTF";
        String projKey = "FOURTEEN";
        String singleLit = "fun";
        String listLit = "(fun)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("fun"));
        matrix.put("!=", Result.error("fun"));
        matrix.put("in", Result.error("(fun)"));
        matrix.put("not in", Result.error("(fun)"));
        matrix.put("is", new Result("EMPTY", new String[]{"FOURTEEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"FOURTEEN-3", "FOURTEEN-2"}));
        matrix.put("~", new Result("fun", new String[]{"FOURTEEN-2"}));
        matrix.put("!~", new Result("fun", new String[]{"FOURTEEN-3"}));
        matrix.put("<", Result.error("fun"));
        matrix.put("<=", Result.error("fun"));
        matrix.put(">", Result.error("fun"));
        matrix.put(">=", Result.error("fun"));
        this._testOperatorMatrix("ROTF", "FOURTEEN", matrix);
    }

    public void testSelectList() throws Exception {
        String fieldName = "SL";
        String projKey = "FIFTEEN";
        String singleLit = "select1";
        String listLit = "(select1, select2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("select1", new String[]{"FIFTEEN-2"}));
        matrix.put("!=", new Result("select1", new String[]{"FIFTEEN-3"}));
        matrix.put("in", new Result("(select1, select2)", new String[]{"FIFTEEN-3", "FIFTEEN-2"}));
        matrix.put("not in", new Result("(select1, select2)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"FIFTEEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"FIFTEEN-3", "FIFTEEN-2"}));
        matrix.put("~", Result.error("select1"));
        matrix.put("!~", Result.error("select1"));
        matrix.put("<", Result.error("select1"));
        matrix.put("<=", Result.error("select1"));
        matrix.put(">", Result.error("select1"));
        matrix.put(">=", Result.error("select1"));
        this._testOperatorMatrix("SL", "FIFTEEN", matrix);
    }

    public void testSingleVersionPicker() throws Exception {
        String fieldName = "SVP";
        String projKey = "SIXTEEN";
        String singleLit = "v2";
        String listLit = "(v1, v2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("v2", new String[]{"SIXTEEN-3"}));
        matrix.put("!=", new Result("v2", new String[]{"SIXTEEN-4", "SIXTEEN-2"}));
        matrix.put("in", new Result("(v1, v2)", new String[]{"SIXTEEN-3", "SIXTEEN-2"}));
        matrix.put("not in", new Result("(v1, v2)", new String[]{"SIXTEEN-4"}));
        matrix.put("is", new Result("EMPTY", new String[]{"SIXTEEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"SIXTEEN-4", "SIXTEEN-3", "SIXTEEN-2"}));
        matrix.put("~", Result.error("v2"));
        matrix.put("!~", Result.error("v2"));
        matrix.put("<", new Result("v2", new String[]{"SIXTEEN-2"}));
        matrix.put("<=", new Result("v2", new String[]{"SIXTEEN-3", "SIXTEEN-2"}));
        matrix.put(">", new Result("v2", new String[]{"SIXTEEN-4"}));
        matrix.put(">=", new Result("v2", new String[]{"SIXTEEN-4", "SIXTEEN-3"}));
        this._testOperatorMatrix("SVP", "SIXTEEN", matrix);
    }

    public void testTextField() throws Exception {
        String fieldName = "TF";
        String projKey = "SEVENTEEN";
        String singleLit = "fun";
        String listLit = "(fun)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("fun"));
        matrix.put("!=", Result.error("fun"));
        matrix.put("in", Result.error("(fun)"));
        matrix.put("not in", Result.error("(fun)"));
        matrix.put("is", new Result("EMPTY", new String[]{"SEVENTEEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"SEVENTEEN-3", "SEVENTEEN-2"}));
        matrix.put("~", new Result("fun", new String[]{"SEVENTEEN-2"}));
        matrix.put("!~", new Result("fun", new String[]{"SEVENTEEN-3"}));
        matrix.put("<", Result.error("fun"));
        matrix.put("<=", Result.error("fun"));
        matrix.put(">", Result.error("fun"));
        matrix.put(">=", Result.error("fun"));
        this._testOperatorMatrix("TF", "SEVENTEEN", matrix);
    }

    public void testUrlField() throws Exception {
        String fieldName = "URL";
        String projKey = "EIGHTEEN";
        String singleLit = "'" + URLEncoder.encode("http://www.atlassian.com", "UTF-8") + "'";
        String listLit = "('" + URLEncoder.encode("http://www.atlassian.com", "UTF-8") + "')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result(singleLit, new String[]{"EIGHTEEN-2"}));
        matrix.put("!=", new Result(singleLit, new String[]{"EIGHTEEN-3"}));
        matrix.put("in", new Result(listLit, new String[]{"EIGHTEEN-2"}));
        matrix.put("not in", new Result(listLit, new String[]{"EIGHTEEN-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"EIGHTEEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"EIGHTEEN-3", "EIGHTEEN-2"}));
        matrix.put("~", Result.error(singleLit));
        matrix.put("!~", Result.error(singleLit));
        matrix.put("<", Result.error(singleLit));
        matrix.put("<=", Result.error(singleLit));
        matrix.put(">", Result.error(singleLit));
        matrix.put(">=", Result.error(singleLit));
        this._testOperatorMatrix("URL", "EIGHTEEN", matrix);
    }

    public void testUserPicker() throws Exception {
        String fieldName = "UP";
        String projKey = "NINETEEN";
        String singleLit = "fred";
        String listLit = "(fred, admin)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("fred", new String[]{"NINETEEN-2"}));
        matrix.put("!=", new Result("fred", new String[]{"NINETEEN-3"}));
        matrix.put("in", new Result("(fred, admin)", new String[]{"NINETEEN-3", "NINETEEN-2"}));
        matrix.put("not in", new Result("(fred, admin)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"NINETEEN-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"NINETEEN-3", "NINETEEN-2"}));
        matrix.put("~", Result.error("fred"));
        matrix.put("!~", Result.error("fred"));
        matrix.put("<", Result.error("fred"));
        matrix.put("<=", Result.error("fred"));
        matrix.put(">", Result.error("fred"));
        matrix.put(">=", Result.error("fred"));
        this._testOperatorMatrix("UP", "NINETEEN", matrix);
    }

    public void testVersionPicker() throws Exception {
        String fieldName = "VP";
        String projKey = "TWENTY";
        String singleLit = "v2";
        String listLit = "(v1, v2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("v2", new String[]{"TWENTY-5", "TWENTY-3"}));
        matrix.put("!=", new Result("v2", new String[]{"TWENTY-4", "TWENTY-2"}));
        matrix.put("in", new Result("(v1, v2)", new String[]{"TWENTY-5", "TWENTY-3", "TWENTY-2"}));
        matrix.put("not in", new Result("(v1, v2)", new String[]{"TWENTY-4"}));
        matrix.put("is", new Result("EMPTY", new String[]{"TWENTY-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"TWENTY-5", "TWENTY-4", "TWENTY-3", "TWENTY-2"}));
        matrix.put("~", Result.error("v2"));
        matrix.put("!~", Result.error("v2"));
        matrix.put("<", new Result("v2", new String[]{"TWENTY-5", "TWENTY-2"}));
        matrix.put("<=", new Result("v2", new String[]{"TWENTY-5", "TWENTY-3", "TWENTY-2"}));
        matrix.put(">", new Result("v2", new String[]{"TWENTY-5", "TWENTY-4"}));
        matrix.put(">=", new Result("v2", new String[]{"TWENTY-5", "TWENTY-4", "TWENTY-3"}));
        this._testOperatorMatrix("VP", "TWENTY", matrix);
    }

    private void _testOperatorMatrix(String fieldName, String projKey, Map<String, Result> matrix) {
        for (Map.Entry<String, Result> testEntry : matrix.entrySet()) {
            String operator = testEntry.getKey();
            Result result = testEntry.getValue();
            String operand = result.operand;
            String jqlQuery = String.format("project = %s AND %s %s %s", projKey, fieldName, operator, operand);
            String[] keys = result.issueKeys;
            ErrorType errorType = result.errorType;
            if (keys == null && errorType != null) {
                String errorMsg = errorType.formatError(fieldName, operator);
                this.issueTableAssertions.assertSearchWithError(jqlQuery, errorMsg);
                continue;
            }
            this.assertSearchResults(jqlQuery, keys);
        }
    }

    private void assertSearchResults(String jqlQuery, String ... issueKeys) {
        ArrayList<SearchResultsCondition> conditions = new ArrayList<SearchResultsCondition>();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), issueKeys));
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), issueKeys.length));
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
    }

    private static enum ErrorType {
        EMPTY_NOT_SUPPORTED{

            @Override
            String formatError(String fieldName, String operator) {
                return String.format("The field '%s' does not support searching for EMPTY values.", fieldName);
            }
        }
        ,
        OPERATOR_NOT_SUPPORTED{

            @Override
            String formatError(String fieldName, String operator) {
                return String.format("The operator '%s' is not supported by the '%s' field.", operator, fieldName);
            }
        };


        abstract String formatError(String var1, String var2);
    }

    private static class Result {
        private String operand;
        private String[] issueKeys;
        private ErrorType errorType;

        private static Result error(String operand) {
            return new Result(operand, null, ErrorType.OPERATOR_NOT_SUPPORTED);
        }

        private Result(String operand, String ... issueKeys) {
            this.operand = operand;
            this.issueKeys = issueKeys;
            this.errorType = null;
        }

        private Result(String operand, String[] issueKeys, ErrorType errorType) {
            this.operand = operand;
            this.issueKeys = issueKeys;
            this.errorType = errorType;
        }
    }
}

