/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestCustomFieldAliases
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestCustomFieldAliases.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testCustumFielAliasesAndSpaces() throws Exception {
        this.assertSearchWithResults("\"With Spaces\" is not empty", "HSP-3", "HSP-2");
        this.assertSearchWithResults("cf[10001] is not empty", "HSP-3", "HSP-2");
        this.assertSearchWithResults("\"With Spaces\" ~ \"Blah\" OR cf[10001] ~ \"Hello there\"", "HSP-3", "HSP-2");
        this.assertSearchWithResults("\"NoSpaces\" is not empty", "HSP-1");
        this.assertSearchWithResults("cf[10000] is not empty", "HSP-1");
        this.assertSearchWithResults("\"With Spaces\" is not empty OR \"NoSpaces\" is not empty", "HSP-3", "HSP-2", "HSP-1");
    }

    public void testCustomFieldDoesItFitWithAliasesAndFullNames() throws Exception {
        this.assertFitsFilterForm("\"With Spaces\" ~ \"Blah\"", TestCustomFieldAliases.createFilterFormParam("customfield_10001", "Blah"));
        this.assertFitsFilterForm("\"cf[10001]\" ~ \"Blah\"", TestCustomFieldAliases.createFilterFormParam("customfield_10001", "Blah"));
        this.assertFitsFilterForm("\"NoSpaces\" ~ \"HelloThere\"", TestCustomFieldAliases.createFilterFormParam("customfield_10000", "HelloThere"));
        this.assertFitsFilterForm("\"cf[10000]\" ~ \"HelloThere\"", TestCustomFieldAliases.createFilterFormParam("customfield_10000", "HelloThere"));
    }

    public void testSameNameSameTypeSameContext() throws Exception {
        this.assertFitsFilterForm("cf[10010] ~ \"Blah\"", TestCustomFieldAliases.createFilterFormParam("customfield_10010", "Blah"));
        this.assertFitsFilterForm("cf[10010] ~ \"Blah\" AND cf[10011] ~ \"Blah\"", TestCustomFieldAliases.createFilterFormParam("customfield_10010", "Blah"), TestCustomFieldAliases.createFilterFormParam("customfield_10011", "Blah"));
        this.assertTooComplex("SameSameSame ~ \"Blah\"");
        this.assertSearchWithResults("SameSameSame ~ \"value1\"", "HSP-5", "HSP-4");
        this.assertSearchWithResults("SameSameSame ~ \"value2\"", "HSP-5", "HSP-4");
        this.assertSearchWithResults("cf[10010] ~ \"value1\"", "HSP-4");
        this.assertSearchWithResults("cf[10011] ~ \"value1\"", "HSP-5");
    }

    public void testSameNameDiffTypeSameContext() throws Exception {
        this.assertSearchWithError("SameDiffSame ~ 1", "The operator '~' is not supported by the 'SameDiffSame' field.");
        this.assertSearchWithError("SameDiffSame = 1", "The operator '=' is not supported by the 'SameDiffSame' field.");
        this.assertSearchWithError("SameDiffSame = 2", "The operator '=' is not supported by the 'SameDiffSame' field.");
        this.assertSearchWithError("SameDiffSame ~ Value1", "The operator '~' is not supported by the 'SameDiffSame' field.");
        this.assertSearchWithResults("cf[10020] ~ Value1", "HSP-6");
        this.assertFitsFilterForm("cf[10020] ~ Value1", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertSearchWithResults("cf[10020]  ~ 2", "HSP-7");
        this.assertFitsFilterForm("cf[10020]  ~ 2", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertSearchWithResults("cf[10021] = 1", "HSP-7");
        this.assertFitsFilterForm("cf[10021] = 1", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertSearchWithResults("cf[10021] = 2", "HSP-6");
        this.assertFitsFilterForm("cf[10021] = 2", new IssueNavigatorAssertions.FilterFormParam[0]);
    }

    public void testSameNameSameTypeSameContextDifferentValues() throws Exception {
        this.assertSearchWithResults("SelectHidden = \"SameValue\"", new String[0]);
        this.assertTooComplex("SelectHidden = \"SameValue\"");
        this.assertSearchWithResults("SelectHidden = \"DiffValue1\"", "HSP-8");
        this.assertTooComplex("SelectHidden = \"DiffValue1\"");
        this.assertSearchWithError("SelectHidden = \"DiffValue2\"", "The option 'DiffValue2' for field 'SelectHidden' does not exist.");
        this.assertSearchWithResults("\"Select\" = \"SameValue\"", "HSP-10", "HSP-9");
        this.assertTooComplex("\"Select\" = \"SameValue\"");
        this.assertTooComplex("\"Select\" = \"SameValue\" and project = \"homosapien\"");
        this.assertTooComplex("\"Select\" = \"SameValue\" and project = \"monkey\"");
        this.assertFitsFilterForm("cf[10030] = \"SameValue\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("cf[10031] = \"SameValue\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("cf[10030] = \"DiffValue1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("cf[10031] = \"DiffValue2\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertSearchWithError("\"Select\" = \"DiffValue1\"", "The option 'DiffValue1' for field 'Select' does not exist.");
        this.assertSearchWithError("\"Select\" = \"DiffValue2\"", "The option 'DiffValue2' for field 'Select' does not exist.");
    }

    public void testSameNameSameTypeDiffContext() throws Exception {
        this.assertSearchWithResults("SelectContext = 'Option1'", "MKY-1", "HSP-11");
        this.assertTooComplex("SelectContext = 'Option1'");
        this.assertSearchWithResults("SelectContext = 'Option1' and project = homosapien", "HSP-11");
        this.assertTooComplex("SelectContext = 'Option1' and project = homosapien");
        this.assertSearchWithResults("SelectContext = 'Option1' and project = monkey", "MKY-1");
        this.assertTooComplex("SelectContext = 'Option1' and project = monkey");
        this.assertSearchWithError("SelectContext= 'OptionMonkey'", "The option 'OptionMonkey' for field 'SelectContext' does not exist.");
    }

    public void testSameNameDiffTypeSameOperator() throws Exception {
        this.assertSearchWithResults("Picker in (\"TestValue\")", "HSP-17", "HSP-16", "HSP-15", "HSP-14", "HSP-13");
        this.assertSearchWithResults("cf[10050] in (\"TestValue\")", "HSP-17", "HSP-16", "HSP-15", "HSP-13");
        this.assertSearchWithResults("cf[10051] in (\"TestValue\")", "HSP-17", "HSP-14", "HSP-13");
        this.assertSearchWithResults("Picker not in (\"TestValue\")", "HSP-18");
        this.assertSearchWithResults("cf[10050] not in (\"TestValue\")", "HSP-18");
        this.assertSearchWithResults("cf[10051] not in (\"TestValue\")", "HSP-18");
        this.assertSearchWithResults("Picker = \"TestValue\"", "HSP-17", "HSP-16", "HSP-15", "HSP-14", "HSP-13");
        this.assertSearchWithResults("cf[10050] = \"TestValue\"", "HSP-17", "HSP-16", "HSP-15", "HSP-13");
        this.assertSearchWithResults("cf[10051] = \"TestValue\"", "HSP-17", "HSP-14", "HSP-13");
        this.assertSearchWithResults("Picker != \"TestValue\"", "HSP-18");
        this.assertSearchWithResults("cf[10050] != \"TestValue\"", "HSP-18");
        this.assertSearchWithResults("cf[10051] != \"TestValue\"", "HSP-18");
        this.assertSearchWithResults("Picker is empty", "MKY-2", "MKY-1", "HSP-16", "HSP-15", "HSP-14", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("cf[10050] is empty", "MKY-2", "MKY-1", "HSP-14", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("cf[10051] is empty", "MKY-2", "MKY-1", "HSP-16", "HSP-15", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("Picker is not empty", "HSP-18", "HSP-17", "HSP-16", "HSP-15", "HSP-14", "HSP-13");
        this.assertSearchWithResults("cf[10050] is not empty", "HSP-18", "HSP-17", "HSP-16", "HSP-15", "HSP-13");
        this.assertSearchWithResults("cf[10051] is not empty", "HSP-18", "HSP-17", "HSP-14", "HSP-13");
        this.assertSearchWithError("Picker in (\"New Version 1\")", "The value 'New Version 1' does not exist for the field 'Picker'.");
        this.assertSearchWithError("cf[10051] in (\"New Version 1\")", "The value 'New Version 1' does not exist for the field 'cf[10051]'.");
        this.assertSearchWithResults("cf[10050] in (\"New Version 1\")", "HSP-18", "HSP-17");
        this.assertFitsFilterForm("cf[10050] = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        IssueNavigatorAssertions.FilterFormParam param1 = TestCustomFieldAliases.createFilterFormParam("pid", "10000");
        IssueNavigatorAssertions.FilterFormParam param2 = TestCustomFieldAliases.createFilterFormParam("customfield_10050", "10000");
        this.assertFitsFilterForm("cf[10050] in (\"New Version 1\") AND project = \"Homosapien\"", param1, param2);
        this.assertTooComplex("cf[10051] in (\"TestValue\")");
        this.assertFitsFilterForm("cf[10051] = \"TestValue\"", new IssueNavigatorAssertions.FilterFormParam[0]);
    }

    public void testBadCustomFieldName() throws Exception {
        this.assertSearchWithResults("summary ~ match", new String[0]);
        this.assertSearchWithResults("cf[10070] ~ match", "HSP-8");
        this.assertSearchWithResults("cf[10071] ~ match", "HSP-14");
    }
}

