/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.navigator.ColumnsCondition;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

@Splitable
@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.SLOW_IMPORT})
public class TestContextColumns
extends FuncTestCase {
    private static boolean needsrestore = true;

    @Override
    protected void setUpTest() {
        if (needsrestore) {
            this.administration.restoreDataSlowOldWay("TestJqlContextFields.xml");
            needsrestore = false;
        }
        this.navigation.login("admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "fred");
    }

    public void testProjectField() throws Exception {
        this.assertJqlColumns("project = one", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE));
        this.assertJqlColumns("project = two", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("project = three", this.columnsForAdminUser(), this.getIssuesForProjects(Project.THREE));
        this.assertJqlColumns("project != two", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.TWO));
        this.assertJqlColumns("project != four", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.FOUR));
        this.assertJqlColumns("project != one", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.ONE));
        this.assertJqlColumns("project in (one, three)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("project = one or project = three", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("project not in (one, two)", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.ONE, Project.TWO));
        this.assertJqlColumns("project != one and project != two", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.ONE, Project.TWO));
        this.assertJqlColumns("project not in (one, two, three)", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.ONE, Project.THREE, Project.TWO));
        this.assertJqlColumns("project != one and project != two and project != three", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.ONE, Project.THREE, Project.TWO));
        this.assertJqlColumns("project in (empty, two)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("project = empty or project = two", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("project is not empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("project != empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("project != null", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("project not in (empty)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("project not in (empty, three)", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.THREE));
        this.assertJqlColumns("project != empty and project != three", this.columnsForAdminUser(), this.getIssuesAndRemoveProject(Project.THREE));
        this.assertJqlColumns("(project != one or project != two)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("project != one or project = one", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("project in (one, two) and project = one", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE));
        this.assertJqlColumns("project in (one, two) and project not in (three, one)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO));
        this.navigation.login("fred");
        this.navigation.gotoDashboard();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.assertJqlColumns("project != two", this.columnsForFredUser(), Issue.ONE1, Issue.FOUR3);
    }

    public void testIssueType() throws Exception {
        this.assertJqlColumns("type = bug", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type = task", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("type = new\\ feature", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("type != bug", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE2, Issue.ONE1, Issue.FOUR3));
        this.assertJqlColumns("type != task", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("type != new\\ feature", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("type in (bug, task)", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type = bug or type = task", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type in ('new feature', task)", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("type = 'new feature' or type = task", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("type not in (bug, task)", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("not (type = bug or type = task)", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type not in ('new feature', task)", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type != 'new feature' and not type = task", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type in (empty, bug)", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type = empty or type = bug", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type is not empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("type != empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("type not in (empty)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("type not in (empty, bug)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE2, Issue.ONE1, Issue.FOUR3));
        this.assertJqlColumns("type is not empty and type != bug", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE2, Issue.ONE1, Issue.FOUR3));
        this.assertJqlColumns("type in (bug, task) and type = task", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("type in (bug, task) and type not in (task, 'new feature')", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
    }

    public void testFieldsWithNoContext() throws Exception {
        List<Issue> issues = this.getIssuesAndRemoveIssues(Issue.ONE1);
        this.assertJqlColumns("assignee = admin", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("assignee != fred", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("assignee is not empty", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("assignee is empty", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("assignee in (admin, empty)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("assignee not in (fred, empty)", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("comment ~ donkey", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("comment !~ JIRA order by key asc", this.columnsForAdminUser(), Issue.FOUR2, Issue.THREE1);
        this.assertJqlColumns("created < 7d", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created <= 7d", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created > 1000", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created >= 1000", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created != now()", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created is not empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created != null", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created not in (1881, 34883)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("created not in (empty, 47458)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        issues = Arrays.asList(Issue.TWO1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("duedate = empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(issues));
        this.assertJqlColumns("duedate is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(issues));
        this.assertJqlColumns("duedate in (empty)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(issues));
        this.assertJqlColumns("duedate < 7d", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate <= 7d", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate > 1000", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate >= 1000", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate != now()", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate is not empty", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate != null", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate not in (1881, 34883)", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("duedate not in (empty, 47458)", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("description ~ suns", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("description !~ suns", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("description is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1, Issue.ONE1));
        this.assertJqlColumns("description is not empty", this.columnsForAdminUser(), Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("environment ~ jira", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("environment !~ jira", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("environment is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.ONE1));
        this.assertJqlColumns("environment is not empty", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("originalEstimate = 5m", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("originalEstimate != 5m", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("originalEstimate in (5m, '5h 3m')", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("originalEstimate not in (5m, '5h 3m')", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("originalEstimate is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("originalEstimate = empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("originalEstimate in (empty, 5m)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("originalEstimate is not empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("originalEstimate != empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("originalEstimate not in (empty, 5m)", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("originalEstimate < 1d", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("originalEstimate <= 1d", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("originalEstimate > 5d", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("originalEstimate >= 5d", this.columnsForAdminUser(), Issue.THREE1);
        issues = Arrays.asList(Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2);
        this.assertJqlColumns("priority = major", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("priority != major", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(issues));
        issues = Arrays.asList(Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2);
        this.assertJqlColumns("priority in (major, critical)", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("priority not in (major, critical)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(issues));
        issues = Arrays.asList(Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2);
        this.assertJqlColumns("priority in (major, empty)", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("priority is not empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("priority != empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("priority not in (empty, trivial)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("priority >= major", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.FOUR1));
        this.assertJqlColumns("priority > major", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("priority < major", this.columnsForAdminUser(), Issue.TWO1, Issue.FOUR1);
        this.assertJqlColumns("priority <= major", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("remainingEstimate = 4m", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("remainingEstimate != 4m", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("remainingEstimate in (4m, '5h 3m')", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("remainingEstimate not in (4m, '5h 3m')", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("remainingEstimate is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("remainingEstimate = empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("remainingEstimate in (empty, 4m)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("remainingEstimate is not empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate != empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate not in (empty, 4m)", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("remainingEstimate < 1d", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("remainingEstimate <= 1d", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("remainingEstimate > 5d", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("remainingEstimate >= 5d", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("reporter = admin", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("reporter != admin", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("reporter in (admin, fred)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("reporter not in (fred, dylan)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("reporter is empty", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("reporter = empty", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("reporter in (empty, fred)", this.columnsForAdminUser(), Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("reporter is not empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("reporter != empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("reporter not in (empty, fred)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("resolution = \"Won't Fix\"", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("resolution != \"Won't Fix\"", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("resolution in (\"Won't Fix\", fixed)", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("resolution not in (duplicate, fixed)", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("resolution is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolution = empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolution in (empty, duplicate)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("resolution is NOT empty", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolution != empty", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolution not in (empty, duplicate)", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("resolutionDate < '2009/08/02'", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("resolutionDate <= '2009/08/02'", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("resolutionDate > '2009/08/02'", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("resolutionDate >= '2009/08/02'", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("resolutionDate != now()", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate not in (now(), '2009/02/20')", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolutionDate = empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolutionDate in (empty, now())", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolutionDate is not empty", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate != null", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate not in (null, now())", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("summary ~ suns", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("summary !~ suns order by key desc", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("summary is not empty order by key desc", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("timeSpent = 1m", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("timeSpent != 1m", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("timeSpent in (1m, '5h 3m')", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("timeSpent not in (1m, '5h 3m')", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("timeSpent is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("timeSpent = empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("timeSpent in (empty, 1m)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("timeSpent is not empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("timeSpent != empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("timeSpent not in (empty, 1m)", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("timeSpent < 1d", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("timeSpent <= 1d", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("timeSpent > 5d", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("timeSpent >= 5d", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("updated < 7d", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated <= 7d", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated > 1000", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated >= 1000", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated != 2004-08-10", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated is not empty", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated != null", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated not in (1881, 34883)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("updated not in (empty, 47458)", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("votes = 0", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("votes != 0", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("votes in (0, 2, 4)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("votes not in (0, 2, 4)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("votes < 1", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("votes <= 1", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("votes > 0", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("votes >= 0", this.columnsForAdminUser(), Issue.ALL_ISSUES);
        this.assertJqlColumns("workRatio = 20", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("workRatio != 20", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("workRatio in (20, 21)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("workRatio not in (20, 39393)", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("workRatio is empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("workRatio = empty", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("workRatio in (empty, 20)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("workRatio is not empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("workRatio != empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("workRatio not in (empty, 20)", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("workRatio < 10", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("workRatio <= 10", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("workRatio > 10", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("workRatio >= 10", this.columnsForAdminUser(), Issue.TWO1);
    }

    public void testCategoryContext() throws Exception {
        this.assertJqlColumns("category = catone", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("category = cattwo", this.columnsForAdminUser(), this.getIssuesForProjects(Project.FOUR));
        this.assertJqlColumns("category != catone", this.columnsForAdminUser(), this.getIssuesForProjects(Project.FOUR));
        this.assertJqlColumns("category != catthree", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category in (catone, cattwo)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category = catone or category = cattwo", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (cattwo, catthree)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("not category = cattwo and category != catthree", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("category is empty", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("category = empty", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("category in (empty)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("category in (empty, catone)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO, Project.ONE, Project.THREE));
        this.assertJqlColumns("category = empty or category = catone", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO, Project.ONE, Project.THREE));
        this.assertJqlColumns("category in (empty, catone, catthree)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.TWO, Project.ONE, Project.THREE));
        this.assertJqlColumns("category is not empty", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category != empty", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (empty)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (empty, catthree)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category != empty and category != catthree", this.columnsForAdminUser(), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (empty, catone)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.FOUR));
        this.assertJqlColumns("not (category is empty or category = catone)", this.columnsForAdminUser(), this.getIssuesForProjects(Project.FOUR));
        this.navigation.login("fred");
        this.assertJqlColumns("category = catone", this.columnsForFredUser(), this.getIssuesForProjects(Project.ONE));
        this.assertJqlColumns("category != catthree", this.columnsForFredUser(), Issue.ONE1, Issue.FOUR3);
    }

    public void testAffectedVersion() throws Exception {
        this.assertSearchingBySystemVersionField("affectedVersion", this.columnsForAdminUser());
    }

    public void testFixVersion() {
        this.assertSearchingBySystemVersionField("fixVersion", this.columnsForAdminUser());
    }

    public void testComponent() throws Exception {
        this.assertJqlColumns("component = one", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("component = two", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("component = three", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component = twoonly", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component != one", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component != two", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component != three", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component != twoonly", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component in (one, two)", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("component = one or component = two", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("component in (one, three)", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component = one or component = three", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component in (twoonly)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component = twoonly", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component not in (one, two)", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("not (component = one or component = two)", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component not in (twoonly, two)", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component != twoonly and component != two", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component not in (one, two, three)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component != one and not (component = two or component = three)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component is empty", this.columnsForAdminUser(), Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component = empty", this.columnsForAdminUser(), Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component in (empty, twoonly)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component is empty or component = twoonly", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component in (empty, two)", this.columnsForAdminUser(), Issue.TWO2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("not (component is not empty and component != two)", this.columnsForAdminUser(), Issue.TWO2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component is not empty", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component != null", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component not in (empty, three)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("not (component = empty or component = three)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component not in (empty, two, three, one)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("component is not empty and component != two and component != three and component != one", this.columnsForAdminUser(), Issue.TWO1);
    }

    public void testIssueContext() throws Exception {
        this.assertJqlColumns("issuekey = 'one-1'", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("issuekey = 'two-1'", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("issuekey = 'three-1'", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("issuekey = 'three-2'", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("issuekey = 'four-1'", this.columnsForAdminUser(), Issue.FOUR1);
        this.assertJqlColumns("issuekey != 'one-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("issuekey != 'two-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("issuekey != 'three-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("issuekey != 'three-2'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE2));
        this.assertJqlColumns("issuekey != 'four-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.FOUR1));
        this.assertJqlColumns("issuekey in ('one-1', 'two-1')", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("issuekey = 'one-1' or key = 'two-1'", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("issuekey in ('three-2', 'three-1')", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("issuekey = 'three-2' or key = 'three-1'", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("issuekey not in ('one-1', 'two-1')", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("issuekey not in ('four-1', 'three-1')", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.FOUR1, Issue.THREE1));
        this.assertJqlColumns("key > 'three-1'", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("key < 'three-2'", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("key >= 'three-1'", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("key >= 'one-1'", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("key <= 'three-1'", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("key <= 'two-1'", this.columnsForAdminUser(), Issue.TWO1);
    }

    public void testLevelContext() throws Exception {
        this.assertJqlColumns("level = oneadmin", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("level = threeonly", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("level = fouronly", this.columnsForAdminUser(), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != oneadmin", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != threeonly", this.columnsForAdminUser(), Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != fouronly", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("level in (oneadmin, threeonly)", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("level = oneadmin or level = threeonly", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("level in (fouronly)", this.columnsForAdminUser(), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level = fouronly", this.columnsForAdminUser(), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (oneadmin, threeonly)", this.columnsForAdminUser(), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != oneadmin and level != threeonly", this.columnsForAdminUser(), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (oneadmin, fouronly)", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("level != oneadmin and level != fouronly", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("level is empty", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level = empty", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level in (empty)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level in (empty, threeonly)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level is empty or level = threeonly", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level is not empty", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != empty", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (empty)", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (empty, empty)", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (empty, threeonly)", this.columnsForAdminUser(), Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != empty and level != threeonly", this.columnsForAdminUser(), Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("level = oneadmin", this.columnsForFredUser(), Issue.ONE1);
    }

    public void testParentContext() throws Exception {
        this.assertJqlColumns("parent = 'two-1'", this.columnsForAdminUser(), Issue.TWO2);
        this.assertJqlColumns("parent = 'four-1'", this.columnsForAdminUser(), Issue.FOUR2);
        this.assertJqlColumns("parent != 'four-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.FOUR2));
        this.assertJqlColumns("parent != 'three-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(new Issue[0]));
        this.assertJqlColumns("parent != 'two-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO2));
        this.assertJqlColumns("parent in ('two-1', 'three-1')", this.columnsForAdminUser(), Issue.TWO2);
        this.assertJqlColumns("parent in ('two-1', 'four-1')", this.columnsForAdminUser(), Issue.TWO2, Issue.FOUR2);
        this.assertJqlColumns("parent = 'two-1' or parent = 'three-1'", this.columnsForAdminUser(), Issue.TWO2);
        this.assertJqlColumns("parent = 'two-1' or parent = 'four-1'", this.columnsForAdminUser(), Issue.TWO2, Issue.FOUR2);
        this.assertJqlColumns("parent not in ('two-1', 'three-1')", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO2));
        this.assertJqlColumns("parent != 'two-1' and  parent != 'three-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO2));
        this.assertJqlColumns("parent not in ('two-1', 'four-1')", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.FOUR2, Issue.TWO2));
        this.assertJqlColumns("parent != 'two-1' and  parent != 'four-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.FOUR2, Issue.TWO2));
        this.assertJqlColumns("parent not in ('one-1', 'three-1')", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(new Issue[0]));
        this.assertJqlColumns("not parent = 'one-1' and parent != 'three-1'", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(new Issue[0]));
    }

    public void testSavedFilter() throws Exception {
        this.assertJqlColumns("savedFilter = taskfilter", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("savedFilter = onefilter", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("savedFilter = threefilter", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("savedFilter != taskfilter", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("savedFilter != onefilter", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.TWO2, Issue.TWO1, Issue.ONE1));
        this.assertJqlColumns("savedFilter != threefilter", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("savedFilter in (taskfilter, threefilter)", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("savedFilter = taskfilter or filter = threefilter", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("savedFilter in (onefilter, threefilter)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("savedFilter = onefilter or filter = threefilter", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("savedFilter not in (taskfilter, threefilter)", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1, Issue.TWO1));
        this.assertJqlColumns("savedFilter != taskfilter and savedFilter != threefilter", this.columnsForAdminUser(), this.getIssuesAndRemoveIssues(Issue.THREE1, Issue.TWO1));
        this.assertJqlColumns("savedFilter not   in (onefilter, threefilter)", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("savedFilter != onefilter and filter != threefilter", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("savedFilter not   in (onefilter, taskfilter)", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("savedFilter != onefilter and savedFilter != taskfilter", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("savedFilter = onefilter", this.columnsForFredUser(), Issue.TWO2, Issue.TWO1);
    }

    public void testStatusContext() throws Exception {
        this.assertJqlColumns("status = open", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("status = two", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("status = three", this.columnsForAdminUser(), Issue.THREE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status != open", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status != two", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("status != three", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("status in (open, two)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("status = open or status = two", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("status in (two, three)", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status = two or status = three", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status not in (open, two)", this.columnsForAdminUser(), Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status != open and status != two", this.columnsForAdminUser(), Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status not in (three, two)", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("status != three and status != two", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("status not in (three, two, open)", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("not (status = three or status = two or status = open)", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("status in (empty, two)", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("status = empty or status = two", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("status is not empty", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("status not in (empty)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("status not in (empty, three, two)", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("not (status = empty or status = three or status = two)", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.navigation.login("fred");
        this.assertJqlColumns("status = three", this.columnsForFredUser(), Issue.FOUR3);
    }

    public void testDatePicker() throws Exception {
        this.assertDateCustomField("datepickerglobal", "2009-08-15", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1, Issue.FOUR1);
        this.assertDateCustomField("DatePickerComplex", "2009-08-15", this.columnsForAdminUser(), Issue.ONE1);
        this.assertDateCustomField("DatePickerBoth", "2009-08-15", this.columnsForAdminUser(), Issue.ONE1);
        this.assertDateCustomField("DatePickerProject", "2009-08-15", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertDateCustomField("DatePickerType", "2009-08-15", this.columnsForAdminUser(), Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("DatePickerProject = 2009-08-15", this.columnsForFredUser(), Issue.TWO1);
    }

    public void testDatePickerSearchingForEmptyValues() throws Exception {
        this.assertDateCustomFieldIsEmpty("datepickerglobal", "2009-08-15", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2);
        this.assertDateCustomFieldIsEmpty("DatePickerComplex", "2009-08-15", Collections.emptyList(), new Issue[0]);
        this.assertDateCustomFieldIsEmpty("DatePickerBoth", "2009-08-15", Collections.emptyList(), new Issue[0]);
        this.assertDateCustomFieldIsEmpty("DatePickerProject", "2009-08-15", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2);
        this.assertDateCustomFieldIsEmpty("DatePickerType", "2009-08-15", Collections.emptyList(), new Issue[0]);
    }

    public void testDateTimePicker() throws Exception {
        this.assertDateCustomField("DateTimeGlobal", "2009-08-07", this.columnsForAdminUser(), Issue.ONE1, Issue.FOUR3);
        this.assertDateCustomField("DateTimeComplex", "2009-08-07", this.columnsForAdminUser(), Issue.TWO1);
        this.assertDateCustomField("DateTimeBoth", "2009-08-07", this.columnsForAdminUser(), Issue.FOUR3);
        this.assertDateCustomField("DateTimeProject", "2009-08-07", this.columnsForAdminUser(), Issue.ONE1);
        this.assertDateCustomField("DateTimeType", "2009-08-07", this.columnsForAdminUser(), Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns("DateTimeComplex = 2009-08-07", this.columnsForFredUser(), Issue.TWO1);
    }

    public void testDateTimePickerSearchingForEmptyValues() throws Exception {
        this.assertDateCustomFieldIsEmpty("DateTimeGlobal", "2009-08-07", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertDateCustomFieldIsEmpty("DateTimeComplex", "2009-08-07", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.FOUR1);
        this.assertDateCustomFieldIsEmpty("DateTimeBoth", "2009-08-07", Collections.emptyList(), new Issue[0]);
        this.assertDateCustomFieldIsEmpty("DateTimeProject", "2009-08-07", Collections.emptyList(), new Issue[0]);
        this.assertDateCustomFieldIsEmpty("DateTimeType", "2009-08-07", Collections.emptyList(), new Issue[0]);
    }

    public void testFreeTextField() throws Exception {
        this.assertTextField("freetextglobal", this.columnsForAdminUser(), Issue.THREE1);
        this.assertTextField("FreeTextBoth", this.columnsForAdminUser(), Issue.TWO1);
        this.assertTextField("FreeTextProject", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR3, Issue.FOUR1);
        this.assertTextField("FreeTextType", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1);
        this.assertTextField("FreeTextComplex", this.columnsForAdminUser(), Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("freetextproject ~ match order by key desc", this.columnsForFredUser(), Issue.FOUR3);
    }

    public void testFreeTextFieldSearchingForEmptyValues() throws Exception {
        this.assertTextFieldIsEmpty("freetextglobal", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertTextFieldIsEmpty("FreeTextBoth", Collections.emptyList(), new Issue[0]);
        this.assertTextFieldIsEmpty("FreeTextProject", this.columnsForAdminUser(), Issue.THREE1, Issue.FOUR2);
        this.assertTextFieldIsEmpty("FreeTextType", this.columnsForAdminUser(), Issue.FOUR3);
        this.assertTextFieldIsEmpty("FreeTextComplex", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR3, Issue.FOUR2);
    }

    public void testTextField() throws Exception {
        this.assertTextField("textglobal", this.columnsForAdminUser(), Issue.TWO2, Issue.ONE1);
        this.assertTextField("TextBoth", this.columnsForAdminUser(), Issue.TWO2);
        this.assertTextField("TextProject", this.columnsForAdminUser(), Issue.ONE1);
        this.assertTextField("TextType", this.columnsForAdminUser(), Issue.FOUR1);
        this.assertTextField("TextComplex", this.columnsForAdminUser(), Issue.TWO1);
        this.navigation.login("fred");
        this.assertJqlColumns("TextComplex ~ match order by key desc", this.columnsForFredUser(), Issue.TWO1);
    }

    public void testTextFieldSearchingForEmptyValues() {
        this.assertTextFieldIsEmpty("textglobal", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertTextFieldIsEmpty("TextBoth", Collections.emptyList(), new Issue[0]);
        this.assertTextFieldIsEmpty("TextProject", Collections.emptyList(), new Issue[0]);
        this.assertTextFieldIsEmpty("TextType", Collections.emptyList(), new Issue[0]);
        this.assertTextFieldIsEmpty("TextComplex", this.columnsForAdminUser(), Issue.THREE1);
    }

    public void testUrlField() throws Exception {
        this.assertUrlField("urlglobal", this.columnsForAdminUser(), Issue.FOUR2);
        this.assertUrlField("urlBoth", this.columnsForAdminUser(), Issue.FOUR2);
        this.assertUrlField("urlProject", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertUrlField("urlType", this.columnsForAdminUser(), Issue.ONE1);
        this.assertUrlField("urlComplex", this.columnsForAdminUser(), Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns("urlProject = '" + URLEncoder.encode("http://match.com", "UTF-8") + "'", this.columnsForFredUser(), Issue.TWO1);
    }

    public void testUrlFieldSearchingForEmptyValues() throws Exception {
        this.assertStringFieldIsEmpty("urlglobal", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertStringFieldIsEmpty("urlBoth", Collections.emptyList(), new Issue[0]);
        this.assertStringFieldIsEmpty("urlProject", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2);
        this.assertStringFieldIsEmpty("urlType", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR3);
        this.assertStringFieldIsEmpty("urlComplex", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR1);
    }

    public void testReadOnlyField() throws Exception {
        this.assertTextField("readtextglobal", this.columnsForAdminUser(), Issue.FOUR1);
        this.assertTextField("readtextBoth", this.columnsForAdminUser(), Issue.THREE2);
        this.assertTextField("readtextProject", this.columnsForAdminUser(), Issue.FOUR1);
        this.assertTextField("readtextType", this.columnsForAdminUser(), Issue.TWO1);
        this.assertTextField("readtextComplex", this.columnsForAdminUser(), Issue.TWO2);
        this.navigation.login("fred");
        this.assertJqlColumns("ReadTextComplex ~ 'match'", this.columnsForFredUser(), Issue.TWO2);
    }

    public void testUserPickerField() throws Exception {
        this.assertUserField("UserGlobal", this.columnsForAdminUser(), Issue.ONE1);
        this.assertUserField("userBoth", this.columnsForAdminUser(), Issue.TWO2);
        this.assertUserField("userProject", this.columnsForAdminUser(), Issue.ONE1);
        this.assertUserField("userType", this.columnsForAdminUser(), Issue.THREE1);
        this.assertUserField("userComplex", this.columnsForAdminUser(), Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("userProject = 'admin'", this.columnsForFredUser(), Issue.ONE1);
    }

    public void testUserPickerFieldSearchingForEmptyValues() throws Exception {
        this.assertUserFieldIsEmpty("UserGlobal", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertUserFieldIsEmpty("userBoth", Collections.emptyList(), new Issue[0]);
        this.assertUserFieldIsEmpty("userProject", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertUserFieldIsEmpty("userType", Collections.emptyList(), new Issue[0]);
        this.assertUserFieldIsEmpty("userComplex", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.FOUR3);
    }

    public void testMultiUserPickerField() throws Exception {
        this.assertUserField("MultiUserGlobal", this.columnsForAdminUser(), Issue.TWO1, Issue.FOUR3);
        this.assertUserField("multiuserBoth", this.columnsForAdminUser(), Issue.FOUR3);
        this.assertUserField("multiuserProject", this.columnsForAdminUser(), Issue.TWO1);
        this.assertUserField("multiuserType", this.columnsForAdminUser(), Issue.TWO1);
        this.assertUserField("multiuserComplex", this.columnsForAdminUser(), Issue.THREE2);
        this.navigation.login("fred");
        this.assertJqlColumns("multiuserProject = 'admin'", this.columnsForFredUser(), Issue.TWO1);
    }

    public void testMultiUserPickerFieldSearchingForEmptyValues() throws Exception {
        this.assertUserFieldIsEmpty("MultiUserGlobal", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertUserFieldIsEmpty("multiuserBoth", Collections.emptyList(), new Issue[0]);
        this.assertUserFieldIsEmpty("multiuserProject", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.THREE1);
        this.assertUserFieldIsEmpty("multiuserType", Collections.emptyList(), new Issue[0]);
        this.assertUserFieldIsEmpty("multiuserComplex", this.columnsForAdminUser(), Issue.THREE1, Issue.ONE1);
    }

    public void testGroupPickerField() throws Exception {
        this.assertGroupField("GroupGlobal", this.columnsForAdminUser(), Issue.TWO2);
        this.assertGroupField("GroupBoth", this.columnsForAdminUser(), Issue.THREE2);
        this.assertGroupField("GroupProject", this.columnsForAdminUser(), Issue.FOUR1);
        this.assertGroupField("GroupType", this.columnsForAdminUser(), Issue.THREE1);
        this.assertGroupField("GroupComplex", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("GroupComplex = 'jira-developers'", this.columnsForFredUser(), Issue.ONE1);
    }

    public void testGroupPikerFieldSearchingForEmptyValues() throws Exception {
        this.assertGroupFieldIsEmpty("GroupGlobal", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertGroupFieldIsEmpty("GroupBoth", Collections.emptyList(), new Issue[0]);
        this.assertGroupFieldIsEmpty("GroupProject", this.columnsForAdminUser(), Issue.FOUR3, Issue.FOUR2);
        this.assertGroupFieldIsEmpty("GroupType", Collections.emptyList(), new Issue[0]);
        this.assertGroupFieldIsEmpty("GroupComplex", this.columnsForAdminUser(), Issue.THREE1);
    }

    public void testMultiGroupPickerField() throws Exception {
        this.assertGroupField("MultiGroupGlobal", this.columnsForAdminUser(), Issue.TWO1);
        this.assertGroupField("MultiGroupBoth", this.columnsForAdminUser(), Issue.THREE2);
        this.assertGroupField("MultiGroupProject", this.columnsForAdminUser(), Issue.FOUR3);
        this.assertGroupField("MultiGroupType", this.columnsForAdminUser(), Issue.THREE1);
        this.assertGroupField("MultiGroupComplex", this.columnsForAdminUser(), Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("GroupComplex = 'jira-developers'", this.columnsForFredUser(), Issue.ONE1);
    }

    public void testMultiGroupPickerFieldSearchingForEmptyValues() throws Exception {
        this.assertGroupFieldIsEmpty("MultiGroupGlobal", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertGroupFieldIsEmpty("MultiGroupBoth", Collections.emptyList(), new Issue[0]);
        this.assertGroupFieldIsEmpty("MultiGroupProject", this.columnsForAdminUser(), Issue.FOUR2, Issue.FOUR1);
        this.assertGroupFieldIsEmpty("MultiGroupType", Collections.emptyList(), new Issue[0]);
        this.assertGroupFieldIsEmpty("MultiGroupComplex", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
    }

    public void testNumberField() throws Exception {
        this.assertNumberField("NumberGlobal", 67, this.columnsForAdminUser(), Issue.THREE1);
        this.assertNumberField("NumberBoth", 67, this.columnsForAdminUser(), Issue.FOUR2);
        this.assertNumberField("NumberProject", 67, this.columnsForAdminUser(), Issue.THREE1);
        this.assertNumberField("NumberType", 67, this.columnsForAdminUser(), Issue.THREE1);
        this.assertNumberField("NumberComplex", 67, this.columnsForAdminUser(), Issue.THREE1, Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("NumberComplex = 67", this.columnsForFredUser(), Issue.ONE1);
    }

    public void testImportIdField() {
        this.assertNumberField("ImportGlobal", 48, this.columnsForAdminUser(), Issue.TWO1);
        this.assertNumberField("ImportBoth", 48, this.columnsForAdminUser(), Issue.TWO1);
        this.assertNumberField("ImportProject", 48, this.columnsForAdminUser(), Issue.ONE1);
        this.assertNumberField("ImportType", 48, this.columnsForAdminUser(), Issue.ONE1);
        this.assertNumberField("ImportComplex", 48, this.columnsForAdminUser(), Issue.FOUR3);
        this.navigation.login("fred");
        this.assertJqlColumns("ImportComplex = 48", this.columnsForFredUser(), Issue.FOUR3);
    }

    public void testProjectPicker() throws Exception {
        this.assertProjectPicker("projectglobal", this.columnsForAdminUser(), Issue.THREE1);
        this.assertProjectPicker("projectBoth", this.columnsForAdminUser(), Issue.THREE1);
        this.assertProjectPicker("ProjectProject", this.columnsForAdminUser(), Issue.THREE1, Issue.ONE1);
        this.assertProjectPicker("PROJECTType", this.columnsForAdminUser(), Issue.TWO2);
        this.assertProjectPicker("PROJectComplex", this.columnsForAdminUser(), Issue.TWO2);
        this.navigation.login("fred");
        this.assertJqlColumns("ProjectProject = one", this.columnsForFredUser(), Issue.ONE1);
    }

    public void testCascadingSelect() throws Exception {
        this.assertJqlColumns("CascasingSelectComplex = one", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex = onetwo", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("CascasingSelectComplex = two", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("CascasingSelectComplex != one", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("CascasingSelectComplex != onetwo", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex != oneone", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex != two", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex in (one, two)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex = one or  CascasingSelectComplex = two", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex not in (two, oneone)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex != two and not CascasingSelectComplex = oneone", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex is empty", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex = empty", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex in (empty)", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex in (empty, oneone)", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex is empty or CascasingSelectCOMPlex = oneone", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex in (empty, onetwo)", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex = empty or CascasingSelectCOMPlex = onetwo", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex is not empty", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex != empty", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex not in (empty)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex not in (empty, one)", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("CascasingSelectCOMPlex != empty and CascasingSelectCOMPlex != one", this.columnsForAdminUser(), Issue.THREE2);
        this.assertJqlColumns("CascadingSelectProject != one", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject != two", this.columnsForAdminUser(), Issue.THREE2, Issue.ONE1, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject != three", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject != four", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject in (one, three)", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject = one or CascadingSelectProject = three", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject in (cascadeoption(one), three)", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject in cascadeoption(one) or CascadingSelectProject = three", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("cascadingselectproject not in (one, two)", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR1);
        this.assertJqlColumns("not cascadingselectproject = one and cascadingselectproject != two", this.columnsForAdminUser(), Issue.THREE2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject is empty", this.columnsForAdminUser(), Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject = empty", this.columnsForAdminUser(), Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject in (empty)", this.columnsForAdminUser(), Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject in (empty, cascadeoption(one))", this.columnsForAdminUser(), Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject is empty or cascadingselectproject in       cascadeoption(one)", this.columnsForAdminUser(), Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject is not empty", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject != empty", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject not in (empty)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject not in (empty, one)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(four, none)", this.columnsForAdminUser(), Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(two, none)", this.columnsForAdminUser(), Issue.TWO2);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(four, two)", this.columnsForAdminUser(), Issue.FOUR2);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(two)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(four, none)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(one, none)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(four, two)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(two, two)", this.columnsForAdminUser(), Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(two)", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("CascadingSelectProject != one", this.columnsForFredUser(), Issue.TWO2, Issue.TWO1);
    }

    public void testLogicalOperatorsAndContext() throws Exception {
        this.assertJqlColumns("summary ~ suns and comment ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("project = three and summary ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("type = 'new feature' and summary ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("key = 'three-1' and summary ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("summary ~ suns and project = three order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("type = 'task' and project = two", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("key = one-1 and project = one", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("summary ~ suns and type = 'new feature' order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("project = two and type = 'task'", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("key = one-1 and type = 'bug'", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("summary ~ suns and key = three-1 order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("project = two and key = two-1", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("type = task and key = two-1", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("key = two-1 and key = two-1", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("summary ~ suns or comment ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("project = three or summary ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("type = 'new feature' or summary ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("key = 'three-1' or summary ~ suns order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("summary ~ suns or project = three order by key desc", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("project = four or category = cattwo", this.columnsForAdminUser(), Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type = 'task' or project = two", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("key = one-1 or project = one", this.columnsForAdminUser(), Issue.ONE1);
        this.assertJqlColumns("summary ~ suns or type = 'new feature' order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("project = two or type = 'task'", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("type = task or type = 'bug'", this.columnsForAdminUser(), Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("key = one-1 or type = 'task'", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("summary ~ suns or key = three-1 order by key desc", this.columnsForAdminUser(), Issue.THREE1);
        this.assertJqlColumns("project = two or key = two-1", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("type = task or key = two-1", this.columnsForAdminUser(), Issue.TWO1);
        this.assertJqlColumns("key = two-1 or key = one-1", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        List<Issue> issues = Arrays.asList(Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("project = one and type = bug or type = task and project = two", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("(project = one and type = bug) or (type = task and project = two)", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("type = bug and project = one or type = task and project = two", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("(project = two and type = task  ) or (project = one and type = bug)", this.columnsForAdminUser(), issues);
        issues = Arrays.asList(Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("type = bug and (project = one or key >= three-1)", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("type = bug and project = one or type = bug and issue >= three-1", this.columnsForAdminUser(), issues);
        this.assertJqlColumns("project = one and type = bug or type = task", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("project = one and type = bug or type = task and project = two", this.columnsForAdminUser(), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("project in (one, three) and type = bug or type = \"New Feature\"", this.columnsForAdminUser(), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        Set<IssueType> types = this.getIssueTypesAndRemove(IssueType.BUG);
        this.assertJqlColumns("project in (one, three) and type != 'bug'", this.columnsForAdminUser(), Issue.THREE1);
        types = EnumSet.of(IssueType.FEATURE, IssueType.IMPROVEMENT, IssueType.TASK);
        this.assertJqlColumns("project in (one, three) and type in ('new feature', Improvement, task)", this.columnsForAdminUser(), Issue.THREE1);
        types = this.getIssueTypesAndRemove(IssueType.BUG);
        this.assertJqlColumns("project in (one, two) and type not in (bug)", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("project != one and type != bug", this.columnsForAdminUser(), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("project != one and type != bug", this.columnsForFredUser(), Issue.TWO2, Issue.TWO1);
    }

    private void assertTextField(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertJqlColumns(String.format("%s ~ 'match' order by key desc", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s !~ empty order by key desc", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s is not empty order by key desc", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s is not null order by key desc", fieldName), expectedColumns, issues);
    }

    private void assertTextFieldIsEmpty(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertJqlColumns(String.format("%s ~ empty order by key desc", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s is empty order by key desc", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s ~ null order by key desc", fieldName), expectedColumns, issues);
    }

    private void assertProjectPicker(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertStringEqualsField(fieldName, "one", "two", expectedColumns, issues);
    }

    private void assertUserField(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertStringEqualsField(fieldName, "admin", "fred", expectedColumns, issues);
    }

    private void assertUserFieldIsEmpty(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertStringFieldIsEmpty(fieldName, expectedColumns, issues);
    }

    private void assertGroupField(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertStringEqualsField(fieldName, "jira-developers", "jira-administrators", expectedColumns, issues);
    }

    private void assertGroupFieldIsEmpty(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertStringFieldIsEmpty(fieldName, expectedColumns, issues);
    }

    private void assertUrlField(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        try {
            this.assertStringEqualsField(fieldName, URLEncoder.encode("http://match.com", "UTF-8"), "other", expectedColumns, issues);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertStringEqualsField(String fieldName, String match, String notMatch, List<Field> expectedColumns, Issue ... issues) {
        this.assertJqlColumns(String.format("%s = '%s'", fieldName, match), expectedColumns, issues);
        this.assertJqlColumns(String.format("%1$s in ('%2$s', '%3$s')", fieldName, match, notMatch), expectedColumns, issues);
        this.assertJqlColumns(String.format("%1$s = '%2$s' or %1$s = '%3$s'", fieldName, match, notMatch), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s != '%s'", fieldName, notMatch), expectedColumns, issues);
        this.assertJqlColumns(String.format("%1$s not in ('%2$s')", fieldName, notMatch), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s != empty", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s is not empty", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s is not null", fieldName), expectedColumns, issues);
    }

    private void assertStringFieldIsEmpty(String fieldName, List<Field> expectedColumns, Issue ... issues) {
        this.assertJqlColumns(String.format("%s is empty", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s = empty", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s = null", fieldName), expectedColumns, issues);
    }

    private void assertSearchingBySystemVersionField(String fieldName, List<Field> expectedColumns) {
        this.assertMultiVersionField(fieldName, expectedColumns);
    }

    private void assertMultiVersionField(String fieldName, List<Field> expectedColumns) {
        this.assertJqlColumns(String.format("%s = twoonly", fieldName), expectedColumns, Issue.TWO1);
        this.assertJqlColumns(String.format("%s = two", fieldName), expectedColumns, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s != two", fieldName), expectedColumns, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%s != fouronly", fieldName), expectedColumns, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s in (fouronly, three)", fieldName), expectedColumns, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns(String.format("%1$s = fouronly or %1$s = three", fieldName), expectedColumns, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns(String.format("%s in (fouronly, threeonly)", fieldName), expectedColumns, Issue.THREE1);
        this.assertJqlColumns(String.format("(%1$s  = fouronly or %1$s = threeonly)", fieldName), expectedColumns, Issue.THREE1);
        this.assertJqlColumns(String.format("%s not in (fouronly, threeonly)", fieldName), expectedColumns, Issue.TWO1, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns(String.format("not(%1$s = fouronly or %1$s = threeonly)", fieldName), expectedColumns, Issue.TWO1, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns(String.format("%s not in (one, two, twoonly)", fieldName), expectedColumns, Issue.THREE1);
        this.assertJqlColumns(String.format("not %1$s = one and %1$s != two and %1$s != twoonly", fieldName), expectedColumns, Issue.THREE1);
        this.assertJqlColumns(String.format("%s is empty", fieldName), expectedColumns, Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns(String.format("%s = empty", fieldName), expectedColumns, Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns(String.format("%s in (empty, two)", fieldName), expectedColumns, Issue.TWO2, Issue.TWO1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns(String.format("%1$s = empty or %1$s = two", fieldName), expectedColumns, Issue.TWO2, Issue.TWO1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns(String.format("%s is not empty", fieldName), expectedColumns, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s != null", fieldName), expectedColumns, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s not in (null, one, two, three)", fieldName), expectedColumns, Issue.THREE1);
        this.assertJqlColumns(String.format("%1$s not in (null, one) and %1$s != two and not %1$s = three", fieldName), expectedColumns, Issue.THREE1);
        this.assertJqlColumns(String.format("%s > one", fieldName), expectedColumns, Issue.ONE1);
        this.assertJqlColumns(String.format("%s > two", fieldName), expectedColumns, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s > three", fieldName), expectedColumns, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%s > threeonly", fieldName), expectedColumns, Issue.THREE2);
        this.assertJqlColumns(String.format("%s < one", fieldName), expectedColumns, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%s < two", fieldName), expectedColumns, Issue.ONE1);
        this.assertJqlColumns(String.format("%s < three", fieldName), expectedColumns, Issue.ONE1);
        this.assertJqlColumns(String.format("%s < twoonly", fieldName), expectedColumns, Issue.TWO1);
        this.assertJqlColumns(String.format("%s < threeonly", fieldName), expectedColumns, Issue.THREE2);
        this.assertJqlColumns(String.format("%s >= one", fieldName), expectedColumns, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns(String.format("%s >= two", fieldName), expectedColumns, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s >= three", fieldName), expectedColumns, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s >= twoonly", fieldName), expectedColumns, Issue.TWO1);
        this.assertJqlColumns(String.format("%s >= threeonly", fieldName), expectedColumns, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%s <= one", fieldName), expectedColumns, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s <= two", fieldName), expectedColumns, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns(String.format("%s <= three", fieldName), expectedColumns, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns(String.format("%s <= twoonly", fieldName), expectedColumns, Issue.TWO1);
        this.assertJqlColumns(String.format("%s <= threeonly", fieldName), expectedColumns, Issue.THREE2, Issue.THREE1);
    }

    private void assertDateCustomField(String fieldName, String date, List<Field> expectedColumns, Issue ... includeIssues) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parsedDate = dateFormat.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(parsedDate);
        cal.add(2, -1);
        String previousDate = dateFormat.format(cal.getTime());
        cal.setTime(parsedDate);
        cal.add(2, 1);
        String nextDate = dateFormat.format(cal.getTime());
        this.assertRangeField(fieldName, previousDate, date, nextDate, expectedColumns, includeIssues);
    }

    private void assertDateCustomFieldIsEmpty(String fieldName, String date, List<Field> expectedColumns, Issue ... expectedIssues) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parsedDate = dateFormat.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(parsedDate);
        cal.add(2, -1);
        String previousDate = dateFormat.format(cal.getTime());
        this.assertJqlColumns(String.format("%s is empty", fieldName), expectedColumns, expectedIssues);
        this.assertJqlColumns(String.format("%s = empty", fieldName), expectedColumns, expectedIssues);
        this.assertJqlColumns(String.format("%s = null", fieldName), expectedColumns, expectedIssues);
        this.assertJqlColumns(String.format("%s in (empty, %s)", fieldName, previousDate), expectedColumns, expectedIssues);
        this.assertJqlColumns(String.format("%1$s is empty or %1$s = %2$s", fieldName, previousDate), expectedColumns, expectedIssues);
    }

    private void assertNumberField(String fieldName, int value, List<Field> expectedColumns, Issue ... issues) {
        this.assertRangeField(fieldName, String.valueOf(value - 2), String.valueOf(value), String.valueOf(value + 100), expectedColumns, issues);
    }

    private void assertRangeField(String fieldName, String prev, String value, String next, List<Field> expectedColumns, Issue ... issues) {
        this.assertJqlColumns(String.format("%s = %s", fieldName, value), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s != %s", fieldName, prev), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s >= %s", fieldName, value), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s <= %s", fieldName, value), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s < %s", fieldName, next), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s > %s", fieldName, prev), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s in (%s)", fieldName, value), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s in (%s, %s)", fieldName, value, next), expectedColumns, issues);
        this.assertJqlColumns(String.format("%1$s = %2$s or %1$s = %3$s", fieldName, value, next), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s not in (%s)", fieldName, prev), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s not in (%s, %s)", fieldName, prev, next), expectedColumns, issues);
        this.assertJqlColumns(String.format("%1$s != %2$s and %1$s != %3$s", fieldName, prev, next), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s is not empty", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s != empty", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s != null", fieldName), expectedColumns, issues);
        this.assertJqlColumns(String.format("%s not in (empty, %s)", fieldName, prev), expectedColumns, issues);
        this.assertJqlColumns(String.format("%1$s is not empty and %1$s != %2$s", fieldName, prev), expectedColumns, issues);
    }

    private Set<IssueType> getIssueTypesAndRemove(IssueType ... remove) {
        EnumSet<IssueType> types = EnumSet.allOf(IssueType.class);
        types.removeAll(Arrays.asList(remove));
        return types;
    }

    private List<Issue> getIssuesAndRemoveIssues(Issue ... remove) {
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES);
        issues.removeAll(Arrays.asList(remove));
        return issues;
    }

    private List<Issue> getIssuesAndRemoveIssues(Collection<Issue> remove) {
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES);
        issues.removeAll(remove);
        return issues;
    }

    private List<Issue> getIssuesAndRemoveProject(Project ... projects) {
        if (projects.length == 0) {
            return Issue.ALL_ISSUES;
        }
        EnumSet<Project> projectCheck = EnumSet.copyOf(Arrays.asList(projects));
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES.size());
        for (Issue issue : Issue.ALL_ISSUES) {
            if (projectCheck.contains((Object)issue.getProject())) continue;
            issues.add(issue);
        }
        return issues;
    }

    private List<Issue> getIssuesForProjects(Project ... projects) {
        if (projects.length == 0) {
            return Issue.ALL_ISSUES;
        }
        EnumSet<Project> projectCheck = EnumSet.copyOf(Arrays.asList(projects));
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES.size());
        for (Issue issue : Issue.ALL_ISSUES) {
            if (!projectCheck.contains((Object)issue.getProject())) continue;
            issues.add(issue);
        }
        return issues;
    }

    private void assertJqlColumns(String jqlQuery, List<Field> expectedColumns, Collection<Issue> expectedIssues) {
        this.assertJqlColumns(jqlQuery, expectedColumns, expectedIssues.toArray(new Issue[expectedIssues.size()]));
    }

    private void assertJqlColumns(String jqlQuery, List<Field> expectedColumns, Issue ... expectedIssues) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertColumns(jqlQuery, expectedColumns, expectedIssues);
    }

    private void assertColumns(String msg, List<Field> expectedColumns, Issue ... expectedIssues) {
        List<String> columnNames = this.extractColumnNames(expectedColumns);
        ArrayList<SearchResultsCondition> condition = new ArrayList<SearchResultsCondition>();
        condition.add(new ColumnsCondition(columnNames));
        condition.add(new ContainsIssueKeysCondition(this.text, TestContextColumns.issuesToKeys(expectedIssues)));
        condition.add(new NumberOfIssuesCondition(this.text, expectedIssues.length));
        this.log(String.format("Checking that columns '%s' are visible for '%s'", columnNames, msg));
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(condition);
    }

    private static String[] issuesToKeys(Issue ... issues) {
        String[] keys = new String[issues.length];
        int i = 0;
        for (Issue issue : issues) {
            keys[i++] = issue.getKey();
        }
        return keys;
    }

    private List<String> extractColumnNames(List<Field> columns) {
        ArrayList<String> column = new ArrayList<String>();
        for (Field defaultField : columns) {
            column.add(defaultField.getFieldName());
        }
        return column;
    }

    private List<Field> getDefaultFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Field.TYPE);
        fields.add(Field.KEY);
        fields.add(Field.STATUS);
        fields.add(Field.DATE_PICKER_BOTH);
        fields.add(Field.DATE_PICKER_COMPLEX);
        fields.add(Field.DATE_PICKER_GLOBAL);
        fields.add(Field.DATE_PICKER_PROJECT);
        fields.add(Field.DATE_PICKER_TYPE);
        fields.add(Field.DATE_TIME_BOTH);
        fields.add(Field.DATE_TIME_COMPLEX);
        fields.add(Field.DATE_TIME_GLOBAL);
        fields.add(Field.DATE_TIME_PROJECT);
        fields.add(Field.DATE_TIME_TYPE);
        fields.add(Field.URL_BOTH);
        fields.add(Field.URL_COMPLEX);
        fields.add(Field.URL_GLOBAL);
        fields.add(Field.URL_PROJECT);
        fields.add(Field.URL_TYPE);
        fields.add(Field.USER_BOTH);
        fields.add(Field.USER_COMPLEX);
        fields.add(Field.USER_GLOBAL);
        fields.add(Field.USER_PROJECT);
        fields.add(Field.USER_TYPE);
        fields.add(Field.MULTI_USER_BOTH);
        fields.add(Field.MULTI_USER_COMPLEX);
        fields.add(Field.MULTI_USER_GLOBAL);
        fields.add(Field.MULTI_USER_PROJECT);
        fields.add(Field.MULTI_USER_TYPE);
        fields.add(Field.GROUP_BOTH);
        fields.add(Field.GROUP_COMPLEX);
        fields.add(Field.GROUP_GLOBAL);
        fields.add(Field.GROUP_PROJECT);
        fields.add(Field.GROUP_TYPE);
        fields.add(Field.MULTI_GROUP_BOTH);
        fields.add(Field.MULTI_GROUP_COMPLEX);
        fields.add(Field.MULTI_GROUP_GLOBAL);
        fields.add(Field.MULTI_GROUP_PROJECT);
        fields.add(Field.MULTI_GROUP_TYPE);
        fields.add(Field.NUMBER_BOTH);
        fields.add(Field.NUMBER_COMPLEX);
        fields.add(Field.NUMBER_GLOBAL);
        fields.add(Field.NUMBER_PROJECT);
        fields.add(Field.NUMBER_TYPE);
        fields.add(Field.IMPORT_BOTH);
        fields.add(Field.IMPORT_COMPLEX);
        fields.add(Field.IMPORT_GLOBAL);
        fields.add(Field.IMPORT_PROJECT);
        fields.add(Field.IMPORT_TYPE);
        fields.add(Field.PROJECT_BOTH);
        fields.add(Field.PROJECT_COMPLEX);
        fields.add(Field.PROJECT_GLOBAL);
        fields.add(Field.PROJECT_PROJECT);
        fields.add(Field.PROJECT_TYPE);
        fields.add(Field.SINGLE_VERSION_BOTH);
        fields.add(Field.SINGLE_VERSION_COMPLEX);
        fields.add(Field.SINGLE_VERSION_GLOBAL);
        fields.add(Field.SINGLE_VERSION_PROJECT);
        fields.add(Field.SINGLE_VERSION_TYPE);
        fields.add(Field.MULTI_VERSION_BOTH);
        fields.add(Field.MULTI_VERSION_COMPLEX);
        fields.add(Field.MULTI_VERSION_GLOBAL);
        fields.add(Field.MULTI_VERSION_PROJECT);
        fields.add(Field.MULTI_VERSION_TYPE);
        fields.add(Field.FREE_TEXT_BOTH);
        fields.add(Field.FREE_TEXT_COMPLEX);
        fields.add(Field.FREE_TEXT_GLOBAL);
        fields.add(Field.FREE_TEXT_PROJECT);
        fields.add(Field.FREE_TEXT_TYPE);
        fields.add(Field.SELECT_LIST_COMPLEX);
        fields.add(Field.SELECT_LIST_PROJECT_GLOBAL);
        fields.add(Field.SELECT_LIST_TYPE);
        fields.add(Field.RADIO_COMPLEX);
        fields.add(Field.RADIO_PROJECT_GLOBAL);
        fields.add(Field.RADIO_TYPE);
        fields.add(Field.READ_TEXT_BOTH);
        fields.add(Field.READ_TEXT_COMPLEX);
        fields.add(Field.READ_TEXT_GLOBAL);
        fields.add(Field.READ_TEXT_PROJECT);
        fields.add(Field.READ_TEXT_TYPE);
        fields.add(Field.TEXT_BOTH);
        fields.add(Field.TEXT_COMPLEX);
        fields.add(Field.TEXT_GLOBAL);
        fields.add(Field.TEXT_PROJECT);
        fields.add(Field.TEXT_TYPE);
        fields.add(Field.CHECKBOX_COMPLEX);
        fields.add(Field.CHECKBOX_PROJECT_GLOBAL);
        fields.add(Field.CHECKBOX_TYPE);
        fields.add(Field.MULTI_SELECT_COMPLEX);
        fields.add(Field.MULTI_SELECT_PROJECT_GLOBAL);
        fields.add(Field.MULTI_SELECT_TYPE);
        fields.add(Field.CASCADING_SELECT_COMPLEX);
        fields.add(Field.CASCADING_SELECT_PROJECT);
        fields.add(Field.INVISIBLE_FIELD);
        return fields;
    }

    private List<Field> columnsForAdminUser() {
        return this.getDefaultFields();
    }

    private List<Field> columnsForFredUser() {
        List<Field> fields = this.getDefaultFields();
        fields.remove(Field.READ_TEXT_BOTH);
        fields.remove(Field.MULTI_VERSION_BOTH);
        fields.remove(Field.GROUP_BOTH);
        fields.remove(Field.SINGLE_VERSION_BOTH);
        fields.remove(Field.PROJECT_BOTH);
        fields.remove(Field.MULTI_GROUP_BOTH);
        fields.remove(Field.INVISIBLE_FIELD);
        return fields;
    }

    private static class Field {
        private static final Field TYPE = new Field("T");
        private static final Field KEY = new Field("Key");
        private static final Field STATUS = new Field("Status");
        private static final Field DATE_PICKER_BOTH = new Field("DatePickerBoth");
        private static final Field DATE_PICKER_COMPLEX = new Field("DatePickerComplex");
        private static final Field DATE_PICKER_GLOBAL = new Field("DatePickerGlobal");
        private static final Field DATE_PICKER_PROJECT = new Field("DatePickerProject");
        private static final Field DATE_PICKER_TYPE = new Field("DatePickerType");
        private static final Field DATE_TIME_BOTH = new Field("DateTimeBoth");
        private static final Field DATE_TIME_COMPLEX = new Field("DateTimeComplex");
        private static final Field DATE_TIME_GLOBAL = new Field("DateTimeGlobal");
        private static final Field DATE_TIME_PROJECT = new Field("DateTimeProject");
        private static final Field DATE_TIME_TYPE = new Field("DateTimeType");
        private static final Field FREE_TEXT_BOTH = new Field("FreeTextBoth");
        private static final Field FREE_TEXT_COMPLEX = new Field("FreeTextComplex");
        private static final Field FREE_TEXT_GLOBAL = new Field("FreeTextGlobal");
        private static final Field FREE_TEXT_PROJECT = new Field("FreeTextProject");
        private static final Field FREE_TEXT_TYPE = new Field("FreeTextType");
        private static final Field TEXT_BOTH = new Field("TextBoth");
        private static final Field TEXT_COMPLEX = new Field("TextComplex");
        private static final Field TEXT_GLOBAL = new Field("TextGlobal");
        private static final Field TEXT_PROJECT = new Field("TextProject");
        private static final Field TEXT_TYPE = new Field("TextType");
        private static final Field URL_BOTH = new Field("UrlBoth");
        private static final Field URL_COMPLEX = new Field("UrlComplex");
        private static final Field URL_GLOBAL = new Field("UrlGlobal");
        private static final Field URL_PROJECT = new Field("UrlProject");
        private static final Field URL_TYPE = new Field("UrlType");
        private static final Field READ_TEXT_COMPLEX = new Field("ReadTextComplex");
        private static final Field READ_TEXT_BOTH = new Field("ReadTextBoth");
        private static final Field READ_TEXT_GLOBAL = new Field("ReadTextGlobal");
        private static final Field READ_TEXT_PROJECT = new Field("ReadTextProject");
        private static final Field READ_TEXT_TYPE = new Field("ReadTextType");
        private static final Field USER_BOTH = new Field("UserBoth");
        private static final Field USER_COMPLEX = new Field("UserComplex");
        private static final Field USER_GLOBAL = new Field("UserGlobal");
        private static final Field USER_PROJECT = new Field("UserProject");
        private static final Field USER_TYPE = new Field("UserType");
        private static final Field MULTI_USER_BOTH = new Field("MultiUserBoth");
        private static final Field MULTI_USER_COMPLEX = new Field("MultiUserComplex");
        private static final Field MULTI_USER_GLOBAL = new Field("MultiUserGlobal");
        private static final Field MULTI_USER_PROJECT = new Field("MultiUserProject");
        private static final Field MULTI_USER_TYPE = new Field("MultiUserType");
        private static final Field GROUP_BOTH = new Field("GroupBoth");
        private static final Field GROUP_COMPLEX = new Field("GroupComplex");
        private static final Field GROUP_GLOBAL = new Field("GroupGlobal");
        private static final Field GROUP_PROJECT = new Field("GroupProject");
        private static final Field GROUP_TYPE = new Field("GroupType");
        private static final Field MULTI_GROUP_BOTH = new Field("MultiGroupBoth");
        private static final Field MULTI_GROUP_COMPLEX = new Field("MultiGroupComplex");
        private static final Field MULTI_GROUP_GLOBAL = new Field("MultiGroupGlobal");
        private static final Field MULTI_GROUP_PROJECT = new Field("MultiGroupProject");
        private static final Field MULTI_GROUP_TYPE = new Field("MultiGroupType");
        private static final Field NUMBER_BOTH = new Field("NumberBoth");
        private static final Field NUMBER_COMPLEX = new Field("NumberComplex");
        private static final Field NUMBER_GLOBAL = new Field("NumberGlobal");
        private static final Field NUMBER_PROJECT = new Field("NumberProject");
        private static final Field NUMBER_TYPE = new Field("NumberType");
        private static final Field IMPORT_BOTH = new Field("ImportBoth");
        private static final Field IMPORT_COMPLEX = new Field("ImportComplex");
        private static final Field IMPORT_GLOBAL = new Field("ImportGlobal");
        private static final Field IMPORT_PROJECT = new Field("ImportProject");
        private static final Field IMPORT_TYPE = new Field("ImportType");
        private static final Field PROJECT_BOTH = new Field("ProjectBoth");
        private static final Field PROJECT_COMPLEX = new Field("ProjectComplex");
        private static final Field PROJECT_GLOBAL = new Field("ProjectGlobal");
        private static final Field PROJECT_PROJECT = new Field("ProjectProject");
        private static final Field PROJECT_TYPE = new Field("ProjectType");
        private static final Field SINGLE_VERSION_BOTH = new Field("SingleVersionBoth");
        private static final Field SINGLE_VERSION_COMPLEX = new Field("SingleVersionComplex");
        private static final Field SINGLE_VERSION_GLOBAL = new Field("SingleVersionGlobal");
        private static final Field SINGLE_VERSION_PROJECT = new Field("SingleVersionProject");
        private static final Field SINGLE_VERSION_TYPE = new Field("SingleVersionType");
        private static final Field MULTI_VERSION_BOTH = new Field("MultiVersionBoth");
        private static final Field MULTI_VERSION_COMPLEX = new Field("MultiVersionComplex");
        private static final Field MULTI_VERSION_GLOBAL = new Field("MultiVersionGlobal");
        private static final Field MULTI_VERSION_PROJECT = new Field("MultiVersionProject");
        private static final Field MULTI_VERSION_TYPE = new Field("MultiVersionType");
        private static final Field SELECT_LIST_COMPLEX = new Field("SelectListComplex");
        private static final Field SELECT_LIST_PROJECT_GLOBAL = new Field("SelectListProjectGlobal");
        private static final Field SELECT_LIST_TYPE = new Field("SelectListType");
        private static final Field RADIO_COMPLEX = new Field("RadioComplex");
        private static final Field RADIO_PROJECT_GLOBAL = new Field("RadioProjectGlobal");
        private static final Field RADIO_TYPE = new Field("RadioType");
        private static final Field CHECKBOX_COMPLEX = new Field("CheckboxComplex");
        private static final Field CHECKBOX_PROJECT_GLOBAL = new Field("CheckboxProjectGlobal");
        private static final Field CHECKBOX_TYPE = new Field("CheckboxType");
        private static final Field MULTI_SELECT_COMPLEX = new Field("MultiSelectComplex");
        private static final Field MULTI_SELECT_PROJECT_GLOBAL = new Field("MultiSelectProjectGlobal");
        private static final Field MULTI_SELECT_TYPE = new Field("MultiSelectType");
        private static final Field CASCADING_SELECT_COMPLEX = new Field("CascasingSelectComplex");
        private static final Field CASCADING_SELECT_PROJECT = new Field("CascadingSelectProject");
        private static final Field INVISIBLE_FIELD = new Field("InvisibleField");
        private final String fieldName;

        private Field(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return String.format("Field Config: %s .%n", this.fieldName);
        }
    }

    private static class Issue
    implements Comparable<Issue> {
        private static final Issue TWO2 = new Issue("TWO-2", Project.TWO, IssueType.SUBTASK);
        private static final Issue TWO1 = new Issue("TWO-1", Project.TWO, IssueType.TASK);
        private static final Issue THREE2 = new Issue("THREE-2", Project.THREE, IssueType.BUG);
        private static final Issue THREE1 = new Issue("THREE-1", Project.THREE, IssueType.FEATURE);
        private static final Issue ONE1 = new Issue("ONE-1", Project.ONE, IssueType.BUG);
        private static final Issue FOUR3 = new Issue("FOUR-3", Project.FOUR, IssueType.BUG);
        private static final Issue FOUR2 = new Issue("FOUR-2", Project.FOUR, IssueType.SUBTASK);
        private static final Issue FOUR1 = new Issue("FOUR-1", Project.FOUR, IssueType.IMPROVEMENT);
        private static final List<Issue> ALL_ISSUES = Arrays.asList(TWO2, TWO1, THREE2, THREE1, ONE1, FOUR3, FOUR2, FOUR1);
        private final String key;
        private final Project project;
        private final IssueType type;

        private Issue(String key, Project project, IssueType type) {
            this.key = key;
            this.project = project;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public Project getProject() {
            return this.project;
        }

        public IssueType getType() {
            return this.type;
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Issue issue = (Issue)o;
            return !(this.key == null ? issue.key != null : !this.key.equals(issue.key));
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        @Override
        public int compareTo(Issue o) {
            return this.key.compareTo(o.key);
        }
    }

    private static enum IssueType {
        BUG,
        IMPROVEMENT,
        FEATURE,
        TASK,
        SUBTASK;

    }

    private static enum Project {
        ONE,
        TWO,
        THREE,
        FOUR;

    }
}

