/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.concurrent.atomic.AtomicBoolean;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestClausesDependentOnProperties
extends FuncTestCase {
    private static final ThreadLocal<AtomicBoolean> dataSetUp = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };

    @Override
    protected void setUpTest() {
        super.setUpTest();
        if (!dataSetUp.get().getAndSet(true)) {
            this.administration.restoreBlankInstance();
        }
    }

    public void testUserClausesSearchOnFullName() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        this.issueTableAssertions.assertSearchWithResults("assignee = 'Fred Normal'", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("assignee = fred", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter = 'Fred Normal'", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("reporter = fred", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("UserCF = 'Fred Normal'", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("UserCF = fred", new String[0]);
    }

    public void testTimeTrackingClausesInvalid() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.issueTableAssertions.assertSearchWithResults("originalEstimate = 999", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("timeOriginalEstimate = 999", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("remainingEstimate = 999", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("timeEstimate = 999", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("timeSpent = 999", new String[0]);
        this.issueTableAssertions.assertSearchWithResults("workRatio = 999", new String[0]);
        this.administration.timeTracking().disable();
        this.issueTableAssertions.assertSearchWithError("originalEstimate = 999", "Field 'originalEstimate' does not exist or you do not have permission to view it.");
        this.issueTableAssertions.assertSearchWithError("timeOriginalEstimate = 999", "Field 'timeOriginalEstimate' does not exist or you do not have permission to view it.");
        this.issueTableAssertions.assertSearchWithError("remainingEstimate = 999", "Field 'remainingEstimate' does not exist or you do not have permission to view it.");
        this.issueTableAssertions.assertSearchWithError("timeEstimate = 999", "Field 'timeEstimate' does not exist or you do not have permission to view it.");
        this.issueTableAssertions.assertSearchWithError("timeSpent = 999", "Field 'timeSpent' does not exist or you do not have permission to view it.");
        this.issueTableAssertions.assertSearchWithError("workRatio = 999", "Field 'workRatio' does not exist or you do not have permission to view it.");
    }

    public void testVotingClausesInvalid() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.administration.generalConfiguration().enableVoting();
        this.issueTableAssertions.assertSearchWithResults("votes = 123", new String[0]);
        this.administration.generalConfiguration().disableVoting();
        this.issueTableAssertions.assertSearchWithError("votes = 123", "Field 'votes' does not exist or you do not have permission to view it.");
    }

    public void testSubTaskClausesInvalid() throws Exception {
        this.administration.subtasks().enable();
        this.issueTableAssertions.assertSearchWithError("parent = 'HSP-1'", "An issue with key 'HSP-1' does not exist for field 'parent'.");
        this.administration.subtasks().disable();
        this.issueTableAssertions.assertSearchWithError("parent = 'HSP-1'", "Field 'parent' does not exist or you do not have permission to view it.");
    }
}

