/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestAdvancedSimple
extends AbstractJqlFuncTest {
    public void testJQLErrors() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("project = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("issuetype = INVALID");
        this.assertInvalidJqlAndSwitchToBasic("text ~ \"*INVALID\"", "Invalid start character '*'", TestAdvancedSimple.createFilterFormParam("text", "*INVALID"));
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("status = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("resolution = INVALID");
        this.assertInvalidJqlAndSwitchToBasicDoesntFit("priority = INVALID");
        this.assertInvalidJqlAndSwitchToBasic("created >= INVALID AND created <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("created:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("created:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("updated >= INVALID AND updated <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("updated:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("updated:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("due >= INVALID AND due <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("duedate:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("duedate:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("resolved >= INVALID AND resolved <= INVALID", "Invalid date format. Please enter the date in the format", TestAdvancedSimple.createFilterFormParam("resolutiondate:after", "INVALID"), TestAdvancedSimple.createFilterFormParam("resolutiondate:before", "INVALID"));
        this.assertInvalidJqlAndSwitchToBasic("workratio >= INVALID AND workratio <= INVALID", "The min limit must be specified using an integer", TestAdvancedSimple.createFilterFormParam("workratio:min", "INVALID"), TestAdvancedSimple.createFilterFormParam("workratio:max", "INVALID"));
    }

    public void testIdsAreTooComplex() throws Exception {
        this.administration.restoreData("TestSwitchingWithOneProject.xml");
        this.assertFitsFilterForm("fixVersion = \"New Version 1\"", TestAdvancedSimple.createFilterFormParam("fixfor", "New Version 1"));
        this.assertTooComplex("fixVersion = 10000");
        this.assertFitsFilterForm("affectedVersion = \"New Version 1\"", TestAdvancedSimple.createFilterFormParam("affectedVersion", "New Version 1"));
        this.assertTooComplex("affectedVersion = 10000");
        this.assertFitsFilterForm("component = \"New Component 1\"", TestAdvancedSimple.createFilterFormParam("component", "New Component 1"));
        this.assertTooComplex("component = 10000");
    }

    private void assertInvalidJqlAndSwitchToBasic(String invalidJqlQuery, String errorMessage, IssueNavigatorAssertions.FilterFormParam ... params) {
        Response searchersResponse = this.backdoor.searchersClient().getSearchersResponse(invalidJqlQuery);
        TestAdvancedSimple.assertEquals((int)200, (int)searchersResponse.statusCode);
    }

    private void assertInvalidJqlAndSwitchToBasicDoesntFit(String invalidJqlQuery) {
        this.assertTooComplex(invalidJqlQuery);
    }
}

