/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.util.SearchRendererValue;
import com.atlassian.jira.functest.framework.util.SearchRendererValueResults;
import com.atlassian.jira.functest.framework.util.SearchResults;
import com.atlassian.jira.testkit.client.restclient.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public abstract class AbstractJqlFuncTest
extends FuncTestCase {
    void assertFitsFilterForm(String jqlQuery, IssueNavigatorAssertions.FilterFormParam ... formParams) {
        Response searchersResponse = this.backdoor.searchersClient().getSearchersResponse(jqlQuery);
        AbstractJqlFuncTest.assertEquals((int)200, (int)searchersResponse.statusCode);
    }

    void assertTooComplex(String jqlQuery) {
        Response searchersResponse = this.backdoor.searchersClient().getSearchersResponse(jqlQuery);
        AbstractJqlFuncTest.assertEquals((int)400, (int)searchersResponse.statusCode);
        AbstractJqlFuncTest.assertEquals((String)"jqlTooComplex", (String)((String)searchersResponse.entity.errorMessages.get(0)));
    }

    void assertInvalidContext(String jqlQuery) {
        SearchResults searchers = this.backdoor.searchersClient().getSearchers(jqlQuery);
        SearchRendererValueResults values = searchers.values;
        boolean invalid = false;
        for (String s : values.keySet()) {
            if (((SearchRendererValue)values.get((Object)s)).validSearcher) continue;
            invalid = true;
        }
        AbstractJqlFuncTest.assertTrue((String)"Expected invalid searcher", (boolean)invalid);
    }

    void assertInvalidValue(String jqlQuery) {
        SearchResults searchers = this.backdoor.searchersClient().getSearchers(jqlQuery);
        SearchRendererValueResults values = searchers.values;
        boolean invalid = false;
        for (String s : values.keySet()) {
            Document editHtml = Jsoup.parse((String)((SearchRendererValue)values.get((Object)s)).editHtml);
            if (editHtml.getElementsByClass("invalid_sel").size() <= 0) continue;
            invalid = true;
            break;
        }
        AbstractJqlFuncTest.assertTrue((String)"Expected invalid value", (boolean)invalid);
    }

    void assertFilterFormValue(IssueNavigatorAssertions.FilterFormParam formParam) {
        this.tester.setWorkingForm("issue-filter");
        AbstractJqlFuncTest.assertSameElements(formParam.getValues(), this.tester.getDialog().getForm().getParameterValues(formParam.getName()));
    }

    private static void assertSameElements(String[] a, String[] b) {
        HashSet<String> as = a == null || a.length == 0 ? null : new HashSet<String>(Arrays.asList(a));
        HashSet<String> bs = b == null || b.length == 0 ? null : new HashSet<String>(Arrays.asList(b));
        AbstractJqlFuncTest.assertEquals(as, (Object)bs);
    }

    void assertEmptyIssues() {
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsAreEmpty();
    }

    void assertIssues(String ... keys) {
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }

    protected void executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode startEditMode, IssueNavigatorNavigation.NavigatorEditMode expectedEditMode, boolean resetQuery, String ... urlParameter) throws UnsupportedEncodingException {
        if (this.navigation.issueNavigator().getCurrentEditMode() != startEditMode) {
            this.navigation.issueNavigator().displayAllIssues();
            this.navigation.issueNavigator().gotoEditMode(startEditMode);
            AbstractJqlFuncTest.assertEquals((Object)((Object)startEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        }
        String params = this.encodeQueryString(urlParameter);
        params = resetQuery ? params.concat("&reset=true") : params.concat("&addParams=true");
        System.out.println("URL=secure/IssueNavigator.jspa?" + params + "&runQuery=true");
        this.tester.gotoPage("secure/IssueNavigator.jspa?" + params + "&runQuery=true");
        AbstractJqlFuncTest.assertEquals((Object)((Object)expectedEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
    }

    protected String encodeQueryString(String ... urlParameter) throws UnsupportedEncodingException {
        StringBuilder params = new StringBuilder();
        for (String parameter : urlParameter) {
            int index = parameter.indexOf("=");
            String parameterName = parameter.substring(0, index);
            String parameterValue = parameter.substring(index + 1);
            params.append("&").append(parameterName).append("=").append(URLEncoder.encode(parameterValue, "UTF8"));
        }
        return params.substring(1);
    }

    protected void assertSearchWithResultsForUser(String username, String jqlString, String ... issueKeys) {
        this.issueTableAssertions.assertSearchWithResultsForUser(username, jqlString, issueKeys);
    }

    protected void assertSearchWithResults(String jqlString, String ... issueKeys) {
        this.issueTableAssertions.assertSearchWithResults(jqlString, issueKeys);
    }

    protected void assertOrderedSearchWithResults(String jqlString, String ... issueKeys) {
        this.issueTableAssertions.assertOrderedSearchWithResults(jqlString, issueKeys);
    }

    protected void assertExactSearchWithResults(String jqlString, String ... issueKeys) {
        this.navigation.issueNavigator().createSearch(jqlString);
        this.assertIssues(issueKeys);
    }

    protected void assertSearchWithErrorForUser(String username, String jqlString, String error) {
        this.issueTableAssertions.assertSearchWithErrorForUser(username, jqlString, error);
    }

    protected void assertSearchWithError(String jqlString, String error) {
        this.issueTableAssertions.assertSearchWithError(jqlString, error);
    }

    protected void assertSearchWithWarningForUser(String username, String jqlString, String warning) {
        this.issueTableAssertions.assertSearchWithWarningForUser(username, jqlString, warning);
    }

    protected void assertSearchWithWarning(String jqlString, String warning) {
        this.issueTableAssertions.assertSearchWithWarning(jqlString, warning);
    }

    protected static IssueNavigatorAssertions.FilterFormParam createFilterFormParam(String name, String ... values) {
        return new IssueNavigatorAssertions.FilterFormParam(name, values);
    }

    protected void assertJqlQueryInTextArea(String expectedJQL) {
        XPathLocator locator = new XPathLocator(this.tester, "//textarea[@id='jqltext']");
        this.text.assertTextPresent(locator, expectedJQL);
    }
}

