/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
public class TestNavigationBarWebFragment
extends FuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestNavigationBarWebFragment.xml");
    }

    @Override
    public void tearDownTest() {
        this.navigation.login("admin", "admin");
        this.administration.restoreBlankInstance();
        super.tearDownTest();
    }

    public void testNavigationBarWebFragment() {
        this.navigation.login("admin", "admin");
        this.tester.assertLinkPresent("home_link");
        this._checkBrowseAndFindIssueLinksVisiblity();
        this._checkCreateIssueLinkVisiblity();
        this._checkAdminLinkVisiblityToProjectAdmin();
        this._checkAdminLinkVisiblityToSystemAdmin();
    }

    public void _checkBrowseAndFindIssueLinksVisiblity() {
        this.tester.assertLinkPresent("browse_link");
        this.tester.assertLinkPresent("find_link");
        this.removeBrowsePermission();
        this.tester.assertLinkNotPresent("find_link");
        this.addBrowsePermission();
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("find_link");
        this.tester.assertLinkPresent("browse_link");
        this.tester.assertLinkPresentWithText("Projects");
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("browse_link");
        this.tester.assertLinkPresentWithText("Projects");
    }

    public void _checkCreateIssueLinkVisiblity() {
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.assertLinkPresent("create_link");
        this.removeCreatePermission();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.assertLinkNotPresent("create_link");
        this.addCreatePermission();
        this.navigation.gotoDashboard();
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.assertLinkPresent("create_link");
    }

    public void _checkAdminLinkVisiblityToProjectAdmin() {
        this.navigation.login("project_admin", "project_admin");
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.login("admin", "admin");
        this.removeProjectAdminPermission();
        this.navigation.gotoDashboard();
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("project_admin", "project_admin");
        TestNavigationBarWebFragment.assertFalse((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.addProjectAdminPermission();
        this.navigation.gotoDashboard();
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("project_admin", "project_admin");
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
    }

    public void _checkAdminLinkVisiblityToSystemAdmin() {
        this.navigation.login("system_admin", "system_admin");
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.login("admin", "admin");
        this.administration.usersAndGroups().removeUserFromGroup("system_admin", "jira-administrators");
        this.navigation.gotoDashboard();
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.logout();
        this.navigation.login("system_admin", "system_admin");
        TestNavigationBarWebFragment.assertFalse((boolean)this.administration.link().isPresent());
        this.navigation.login("admin", "admin");
        this.administration.usersAndGroups().addUserToGroup("system_admin", "jira-administrators");
        this.navigation.gotoDashboard();
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
        this.navigation.login("system_admin", "system_admin");
        TestNavigationBarWebFragment.assertTrue((boolean)this.administration.link().isPresent());
    }

    public void removeBrowsePermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLink("0_edit");
        this.tester.clickLink("del_perm_" + ProjectPermissions.BROWSE_PROJECTS.permissionKey() + "_10000");
        this.tester.submit("Delete");
    }

    public void removeCreatePermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLink("0_edit");
        this.tester.clickLink("del_perm_" + ProjectPermissions.CREATE_ISSUES.permissionKey() + "_10000");
        this.tester.submit("Delete");
    }

    public void removeProjectAdminPermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLink("0_edit");
        this.tester.clickLink("del_perm_" + ProjectPermissions.ADMINISTER_PROJECTS.permissionKey() + "_jira-developers");
        this.tester.submit("Delete");
    }

    public void addBrowsePermission() {
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.BROWSE_PROJECTS.permissionKey(), "jira-users");
    }

    public void addCreatePermission() {
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.CREATE_ISSUES.permissionKey(), "jira-users");
    }

    public void addProjectAdminPermission() {
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ADMINISTER_PROJECTS.permissionKey(), "jira-developers");
    }
}

