/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
public class TestIssueNavigatorRedirects
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
    }

    @Override
    protected void tearDownTest() {
        this.navigation.issueNavigator().createSearch("");
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
    }

    public void testRedirectWithNewQuery() {
        this.assertRedirectionsTo("/secure/IssueNavigator.jspa?createNew=true", "/issues/?jql=", "/issues/?jql");
    }

    public void testRedirectWithSimpleTextQuery() {
        this.assertRedirectionsTo("/secure/IssueNavigator.jspa?searchString=summary text", "/issues/?jql=text%20~%20%22summary%20text%22", "/issues/?jql=text%20%7E%20%22summary%20text%22");
    }

    public void testRedirectWithSimpleJQLQuery() {
        this.assertRedirectionsTo("/secure/IssueNavigator.jspa?jqlQuery=project in (MKY)", "/issues/?jql=project%20in%20(MKY)", "/issues/?jql=project+in+%28MKY%29");
    }

    public void testRedirectWithJQLQueryWithTimestamp() {
        this.assertRedirectionsTo("/secure/IssueNavigator.jspa?jqlQuery=createdDate <= '2014-01-01 9:30'", "/issues/?jql=createdDate%20%3C%3D%20%222014-01-01%209%3A30%22", "/issues/?jql=createdDate+%3C%3D+%272014-01-01+9%3A30%27");
    }

    private void assertRedirectionsTo(String startUrl, String expectedUrl, String otherExpectedUrl) {
        WebResponse response = this.goTo(startUrl);
        MatcherAssert.assertThat((String)"Explicit redirection to user's search should work", (Object)response.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        response = this.goTo("/secure/IssueNavigator.jspa");
        MatcherAssert.assertThat((String)"Implicit redirection to user's last JQL search should work", (Object)response.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        this.tester.clickLink("set_my_jira_home_issuenav");
        MatcherAssert.assertThat((String)"Redirection when setting JIRA Home should work", (Object)this.navigation.getCurrentPage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.endsWith((String)expectedUrl), (Matcher)CoreMatchers.endsWith((String)otherExpectedUrl)));
        this.navigation.logout();
        this.navigation.login("admin");
        MatcherAssert.assertThat((String)"Redirection on login should work", (Object)this.navigation.getCurrentPage(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.endsWith((String)expectedUrl), (Matcher)CoreMatchers.endsWith((String)otherExpectedUrl)));
    }

    private WebResponse goTo(String url) {
        this.tester.gotoPage(url);
        return this.tester.getDialog().getResponse();
    }
}

