/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorColumnsView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestIssueNavigatorPrintableView
extends AbstractTestIssueNavigatorColumnsView {
    public TestIssueNavigatorPrintableView(String name) {
        super(name);
    }

    public void testTimeTrackingPrintableView() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.activateSubTasks();
        this.issueTableClient.getIssueTable("");
        this.backdoor.columnControl().addLoggedInUserColumns(Arrays.asList("aggregatetimeoriginalestimate", "aggregateprogress", "aggregatetimeestimate", "aggregatetimespent"));
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=&tempMax=1000");
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.tableCellHasText(issueTable, 0, 44, "\u03a3 Original Estimate");
        this.tableCellHasText(issueTable, 0, 45, "\u03a3 Remaining Estimate");
        this.tableCellHasText(issueTable, 0, 46, "\u03a3 Time Spent");
        this.tableCellHasText(issueTable, 0, 47, "\u03a3 Progress");
        this.tableCellHasText(issueTable, 2, 45, "30 minutes");
        this.tableCellHasText(issueTable, 2, 46, "3 hours, 20 minutes");
        this.tableCellHasText(issueTable, 2, 47, "86%");
        this.tableCellHasText(issueTable, 3, 44, "1 day");
        this.tableCellHasText(issueTable, 3, 45, "1 day");
        this.tableCellHasText(issueTable, 3, 47, "0%");
    }

    public void testAllColumnsPrintableView() {
        TestIssueNavigatorPrintableView.log("Issue Navigator: Test that the printable view shows all required items");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=&tempMax=1000");
        try {
            WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
            for (AbstractTestIssueNavigatorView.Item item : this.items) {
                new AbstractTestIssueNavigatorColumnsView.ItemVerifier(this, item, issueTable, this.getEnvironmentData().getBaseUrl()).verify();
            }
        }
        catch (Exception e) {
            TestIssueNavigatorPrintableView.log("Failed to parse the printable view", e);
            TestIssueNavigatorPrintableView.fail();
        }
    }

    public void testPrintableViewXSSBug() {
        String filter = this.backdoor.filters().createFilter("", "<script>alert('evil');</script>");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/" + filter + "/SearchRequest-" + filter + ".html?tempMax=1000");
        this.assertTextPresent("&lt;script&gt;alert(&#39;evil&#39;);&lt;/script&gt; (Your Company JIRA)");
    }

    public void testAllColumnsPrintableViewDaysFormat() {
        this.reconfigureTimetracking("days");
        this.testAllColumnsPrintableView();
    }

    public void testAllColumnsPrintableViewHoursFormat() {
        this.reconfigureTimetracking("hours");
        this.testAllColumnsPrintableView();
    }

    public void testSearchRequestHeaderSummaryDisplaysCorrectTotals() {
        TestIssueNavigatorPrintableView.log("Issue Navigator: Test that the printable view shows all required items");
        this.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?sorter/field=issuekey&sorter/order=DESC&tempMax=2");
        this.assertTextPresent("<b>1</b>&ndash;<b>2</b> of <b>3</b>");
        this.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?sorter/field=issuekey&sorter/order=DESC");
        this.assertTextPresent("<b>1</b>&ndash;<b>3</b> of <b>3</b>");
    }

    public void testSearchRequestSummaryWithSimpleAndAdvancedQuery() throws Exception {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=status%20=%20'In Progress'&tempMax=1000");
        CssLocator summaryLocator = new CssLocator(this.tester, ".result-header");
        this.text.assertTextSequence(summaryLocator, "Status", "In Progress");
        this.text.assertTextNotPresent(summaryLocator, "JQL Query");
        this.text.assertTextNotPresent(summaryLocator, "status = 'In Progress'");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?jqlQuery=status%20!=%20'In Progress'&tempMax=1000");
        summaryLocator = new CssLocator(this.tester, ".result-header");
        this.text.assertTextSequence(summaryLocator, "JQL Query", "status != 'In Progress'");
        this.text.assertTextNotPresent(summaryLocator, "Status");
    }
}

