/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorColumnsView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebResponseUtil;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestIssueNavigatorExcelView
extends AbstractTestIssueNavigatorColumnsView {
    public TestIssueNavigatorExcelView(String name) {
        super(name);
    }

    public void testAllExcelViewHaveCorrectLinkToTheFilter() {
        this._testExcelViewHaveCorrectLinkToTheFilter("currentExcelFields");
    }

    public void _testExcelViewHaveCorrectLinkToTheFilter(String excelView) {
        TestIssueNavigatorExcelView.log("Issue Navigator: Test that the " + excelView + " views show correct link to the search filter");
        String filterName = "rssview";
        String filterId = this.backdoor.filters().createFilter("issuetype=\"New Feature\"", filterName);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/" + filterId + "/SearchRequest-" + filterId + ".xls?tempMax=1000");
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
                TestIssueNavigatorExcelView.log("Failed to replace response content type with 'text/html'");
                TestIssueNavigatorExcelView.fail();
            } else {
                String expectedFilterUrl = this.getEnvironmentData().getBaseUrl().toString() + "/secure/IssueNavigator.jspa?requestId=" + filterId;
                String expectedLink = expectedFilterUrl + "\">" + filterName;
                this.assertTextPresent(expectedLink);
            }
        }
        catch (Exception e) {
            TestIssueNavigatorExcelView.log("Failed to parse the printable view", e);
            TestIssueNavigatorExcelView.fail();
        }
    }

    public void testAllColumnsExcelView() {
        TestIssueNavigatorExcelView.log("Issue Navigator: Test that the excel (All fields) view shows all required items");
        this.goToExcelViewForAllIssues();
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
                TestIssueNavigatorExcelView.log("Failed to replace response content type with 'text/html'");
                TestIssueNavigatorExcelView.fail();
            } else {
                WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
                for (Object itemObject : this.items) {
                    AbstractTestIssueNavigatorView.Item item = (AbstractTestIssueNavigatorView.Item)itemObject;
                    new ExcelItemVerifier((AbstractTestIssueNavigatorColumnsView)this, item, issueTable, this.getEnvironmentData().getBaseUrl()).verify();
                }
            }
        }
        catch (Exception e) {
            TestIssueNavigatorExcelView.log("Failed to parse the printable view", e);
            TestIssueNavigatorExcelView.fail();
        }
    }

    private void goToExcelViewForAllIssues() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/temp/SearchRequest.xls?jqlQuery=&tempMax=1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExcelFilenameWithNonAsciiCharacters() {
        String encodedFilename = "%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls";
        String oldUserAgent = this.getDialog().getWebClient().getClientProperties().getUserAgent();
        try {
            TestIssueNavigatorExcelView.log("Issue Navigator: Test that the excel view generates the correct filename when the search request has non-ASCII characters");
            this.administration.restoreData("TestSearchRequestViewNonAsciiSearchName.xml");
            this.tester.getDialog().getWebClient().getClientProperties().setUserAgent("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)");
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            String contentDisposition = this.tester.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertTrue((String)("Expected the content disposition to contain '%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls' but got '" + contentDisposition + "'!"), (contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls\"") >= 0 ? 1 : 0) != 0);
            this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            contentDisposition = this.tester.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertTrue((contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls\"") >= 0 ? 1 : 0) != 0);
            this.tester.getDialog().getWebClient().getClientProperties().setUserAgent("Mozilla/5.001 (windows; U; NT4.0; en-US; rv:1.0) Gecko/25250101");
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            contentDisposition = this.tester.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertTrue((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls\"") >= 0 ? 1 : 0) != 0);
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls?tempMax=1000");
            contentDisposition = this.tester.getDialog().getResponse().getHeaderField("content-disposition");
            TestIssueNavigatorExcelView.assertTrue((contentDisposition.indexOf("filename*=UTF-8''%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls") >= 0 ? 1 : 0) != 0);
            TestIssueNavigatorExcelView.assertFalse((contentDisposition.indexOf("filename=\"%D0%B5%D1%81%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F%20%28jWebTest%20JIRA%20installation%29.xls\"") >= 0 ? 1 : 0) != 0);
        }
        finally {
            this.tester.getDialog().getWebClient().getClientProperties().setUserAgent(oldUserAgent);
        }
    }

    public void testExcelViewCanBeCached() {
        TestIssueNavigatorExcelView.log("Issue Navigator: Test that the excel view does not contain the Cache-control: no-cache header");
        this.goToExcelViewForAllIssues();
        if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
            TestIssueNavigatorExcelView.log("Failed to replace response content type with 'text/html'");
            TestIssueNavigatorExcelView.fail();
        } else {
            this.assertResponseCanBeCached();
        }
    }

    public void testTempMax() throws SAXException, IOException {
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?pid=10000&sorter/field=issuekey&sorter/order=DESC&tempMax=1&noResponseHeaders=true");
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.assertTextSequence(new String[]{"Displaying", "1", "issues at"});
        TestIssueNavigatorExcelView.assertEquals((int)2, (int)issueTable.getRowCount());
    }

    public void testPagerStartParam() throws SAXException {
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?pid=10000&sorter/field=issuekey&sorter/order=DESC&noResponseHeaders=true");
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestIssueNavigatorExcelView.assertEquals((int)4, (int)issueTable.getRowCount());
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?pid=10000&sorter/field=issuekey&sorter/order=DESC&noResponseHeaders=true&pager/start=2");
        issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestIssueNavigatorExcelView.assertEquals((int)2, (int)issueTable.getRowCount());
    }

    public void testGroupCustomFieldEscaped() throws Exception {
        this.restoreData("TestXssCustomFields.xml");
        this.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls?tempMax=1000");
        TestIssueNavigatorExcelView.assertEquals((String)"application/vnd.ms-excel", (String)this.getDialog().getResponse().getContentType());
        String text = this.getDialog().getResponse().getText();
        TestIssueNavigatorExcelView.assertTrue((text.indexOf("&lt;xxx&gt;delta&lt;/xxx&gt;") >= 0 ? 1 : 0) != 0);
        TestIssueNavigatorExcelView.assertFalse((text.indexOf("<xxx>delta</xxx>") >= 0 ? 1 : 0) != 0);
    }

    @Override
    protected void initFieldColumnMap() {
        this.issueFieldColumnMap.add("issueProject");
        this.issueFieldColumnMap.add("issueKey");
        this.issueFieldColumnMap.add("issueSummary");
        this.issueFieldColumnMap.add("issueType");
        this.issueFieldColumnMap.add("issueStatus");
        this.issueFieldColumnMap.add("issuePriority");
        this.issueFieldColumnMap.add("issueResolution");
        this.issueFieldColumnMap.add("issueAssignee");
        this.issueFieldColumnMap.add("issueReporter");
        this.issueFieldColumnMap.add("issueCreator");
        this.issueFieldColumnMap.add("issueCreated");
        this.issueFieldColumnMap.add("lastViewed");
        this.issueFieldColumnMap.add("issueUpdated");
        this.issueFieldColumnMap.add("issueResolved");
        this.issueFieldColumnMap.add("issueAffectsVersions");
        this.issueFieldColumnMap.add("issueFixVersions");
        this.issueFieldColumnMap.add("issueComponents");
        this.issueFieldColumnMap.add("issueDue");
        this.issueFieldColumnMap.add("issueVotes");
        this.issueFieldColumnMap.add("issueWatches");
        this.issueFieldColumnMap.add("issueImages");
        this.issueFieldColumnMap.add("issueOriginalEstimate");
        this.issueFieldColumnMap.add("issueRemainingEstimate");
        this.issueFieldColumnMap.add("issueTimeSpent");
        this.issueFieldColumnMap.add("issueWorkRatio");
        this.issueFieldColumnMap.add("issueLinks");
        this.issueFieldColumnMap.add("issueEnvironment");
        this.issueFieldColumnMap.add("issueDescription");
        this.issueFieldColumnMap.add("issueSecurityLevel");
        this.issueFieldColumnMap.add("issueTimeTrackingProgress");
        this.issueFieldColumnMap.add("issueLabels");
        this.issueFieldColumnMap.add("issueCascadingSelectField");
        this.issueFieldColumnMap.add("issueDatePickerField");
        this.issueFieldColumnMap.add("issueDateTimeField");
        this.issueFieldColumnMap.add("issueFreeTextField");
        this.issueFieldColumnMap.add("issueGroupPickerField");
        this.issueFieldColumnMap.add("issueImportIdField");
        this.issueFieldColumnMap.add("issueMultiCheckboxesField");
        this.issueFieldColumnMap.add("issueMultiGroupPickerField");
        this.issueFieldColumnMap.add("issueMultiSelectField");
        this.issueFieldColumnMap.add("issueMultiUserPickerField");
        this.issueFieldColumnMap.add("issueNumberField");
        this.issueFieldColumnMap.add("issueProjectPickerField");
        this.issueFieldColumnMap.add("issueROTextField");
        this.issueFieldColumnMap.add("issueRadioButtonsField");
        this.issueFieldColumnMap.add("issueSelectList");
        this.issueFieldColumnMap.add("issueSingleVersionPickerField");
        this.issueFieldColumnMap.add("issueTextField255");
        this.issueFieldColumnMap.add("issueURLField");
        this.issueFieldColumnMap.add("issueUserPickerField");
        this.issueFieldColumnMap.add("issueVersionPickerField");
    }

    @Override
    protected AbstractTestIssueNavigatorView.Item createItem1() {
        AbstractTestIssueNavigatorView.Item item = super.createItem1();
        item.setAttribute("lastViewed", null);
        return item;
    }

    @Override
    protected AbstractTestIssueNavigatorView.Item createItem2() {
        AbstractTestIssueNavigatorView.Item item = super.createItem2();
        item.setAttribute("timeestimate", "1800");
        item.setAttribute("timespent", "12000");
        item.setAttribute("lastViewed", null);
        return item;
    }

    @Override
    protected AbstractTestIssueNavigatorView.Item createItem3() {
        AbstractTestIssueNavigatorView.Item item = super.createItem3();
        item.setAttribute("timeoriginalestimate", "86400");
        item.setAttribute("timeestimate", "86400");
        item.setAttribute("lastViewed", null);
        return item;
    }

    protected class ExcelItemVerifier
    extends AbstractTestIssueNavigatorColumnsView.ItemVerifier {
        public ExcelItemVerifier(AbstractTestIssueNavigatorColumnsView test, AbstractTestIssueNavigatorView.Item item, WebTable table, URL baseUrl) {
            super(test, item, table, baseUrl);
        }

        @Override
        public void verify() {
            AbstractTestIssueNavigatorView.IssueLink link;
            String key = this.item.getAttribute("key");
            AbstractTestIssueNavigatorColumnsView.log("Checking item [" + key + "] on row [" + this.row + "]");
            String issueLink = this.baseUrl + "/browse/" + key;
            this.verifyCellIssueAttributeEmptyOrEquals("issueType", "type");
            this.verifyLinkExists("issueKey", issueLink);
            this.verifyCellIssueAttributeEmptyOrEquals("issueSummary", "summary");
            this.verifyCellIssueAttributeEmptyOrEquals("issueAssignee", "assignee");
            this.verifyCellIssueAttributeEmptyOrEquals("issueReporter", "reporter");
            this.verifyCellIssueAttributeEmptyOrEquals("issueCreator", "creator");
            this.verifyCellIssueAttributeEmptyOrEquals("issuePriority", "priority");
            this.verifyCellIssueAttributeEmptyOrEquals("issueStatus", "status");
            String resolution = this.item.getAttribute("resolution");
            this.verifyCellValueEmptyOrEquals("issueResolution", resolution.equals("Unresolved") ? "Unresolved" : resolution);
            this.verifyCellIssueAttributeEmptyOrEquals("issueCreated", "created");
            this.verifyCellIssueAttributeEmptyOrEquals("lastViewed", "lastViewed");
            this.verifyCellIssueAttributeEmptyOrEquals("issueUpdated", "updated");
            this.verifyCellIssueAttributeEmptyOrEquals("issueDue", "due");
            this.verifyCellIssueAttributeEmptyOrEquals("issueResolved", "resolved");
            this.verifyCellIssueAttributeEmptyOrEquals("issueAffectsVersions", "version");
            this.verifyCustomFieldDisplayValues("issueCascadingSelectField", "CascadingSelectField");
            for (String component : this.item.getComponents()) {
                this.verifyCellValueEmptyOrEquals("issueComponents", component);
            }
            this.verifyCustomFieldDisplayValues("issueDatePickerField", "DatePickerField");
            this.verifyCustomFieldDisplayValues("issueDateTimeField", "DateTimeField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueDescription", "description");
            this.verifyCellIssueAttributeEmptyOrEquals("issueSecurityLevel", "securityLevel");
            this.verifyCellIssueAttributeEmptyOrEquals("issueEnvironment", "environment");
            this.verifyCellIssueAttributeEmptyOrEquals("issueFixVersions", "fixVersion");
            this.verifyCustomFieldDisplayValues("issueFreeTextField", "FreeTextField");
            this.verifyCustomFieldDisplayValues("issueGroupPickerField", "GroupPickerField");
            this.verifyCustomFieldDisplayValues("issueImportIdField", "ImportIdField");
            AbstractTestIssueNavigatorView.IssueLinks links = this.item.getLinks();
            for (Object o1 : links.getInLinks()) {
                link = (AbstractTestIssueNavigatorView.IssueLink)o1;
                this.verifyCellValueEmptyOrEquals("issueLinks", link.getLink());
            }
            for (Object o : links.getOutLinks()) {
                link = (AbstractTestIssueNavigatorView.IssueLink)o;
                this.verifyCellValueEmptyOrEquals("issueLinks", link.getLink());
            }
            this.verifyCustomFieldDisplayValues("issueMultiCheckboxesField", "MultiCheckboxesField");
            this.verifyCustomFieldDisplayValues("issueMultiGroupPickerField", "MultiGroupPickerField");
            this.verifyCustomFieldDisplayValues("issueMultiSelectField", "MultiSelectField");
            this.verifyCustomFieldDisplayValues("issueMultiUserPickerField", "MultiUserPickerField");
            this.verifyCustomFieldDisplayValues("issueNumberField", "NumberField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueOriginalEstimate", "timeoriginalestimate");
            this.verifyCellIssueAttributeEmptyOrEquals("issueProject", "project");
            this.verifyCustomFieldDisplayValues("issueProjectPickerField", "ProjectPickerField");
            this.verifyCustomFieldDisplayValues("issueROTextField", "ROTextField");
            this.verifyCustomFieldDisplayValues("issueRadioButtonsField", "RadioButtonsField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueRemainingEstimate", "timeestimate");
            this.verifyCustomFieldDisplayValues("issueSelectList", "SelectList");
            this.verifyCustomFieldDisplayValues("issueSingleVersionPickerField", "SingleVersionPickerField");
            this.verifyCustomFieldDisplayValues("issueTextField255", "TextField255");
            this.verifyCellIssueAttributeEmptyOrEquals("issueTimeSpent", "timespent");
            this.verifyCustomFieldDisplayValues("issueURLField", "URLField");
            this.verifyCustomFieldLinks("issueURLField", "URLField");
            this.verifyCustomFieldDisplayValues("issueUserPickerField", "UserPickerField");
            this.verifyCustomFieldDisplayValues("issueVersionPickerField", "VersionPickerField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueVotes", "votes");
            this.verifyCellIssueAttributeEmptyOrEquals("issueWorkRatio", "workRatio");
        }
    }
}

