/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.ISSUES})
public class TestIssueNavigatorEncoding
extends FuncTestCase {
    public void testCustomFieldValuesThatShouldBeEncoded() {
        this.administration.restoreData("TestXssCustomFields.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().createSearch("");
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>delta</xxx>");
        this.text.assertTextPresent(pageLocator.getHTML(), "&lt;xxx&gt;delta&lt;/xxx&gt;");
        this.tester.clickLinkWithText("HSP-1");
        pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextNotPresent(pageLocator.getHTML(), "<xxx>delta</xxx>");
        this.text.assertTextPresent(pageLocator.getHTML(), "&lt;xxx&gt;delta&lt;/xxx&gt;");
    }

    public void testCustomFieldLabelsEncoded() {
        this.administration.restoreData("TestIssueNavigatorCustomFieldLabelXss.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10030");
        this.assertCustomFieldLabelEncoded(new WebPageLocator(this.tester));
        this.navigation.issueNavigator().displayAllIssues();
        this.assertCustomFieldLabelEncoded(new WebPageLocator(this.tester));
    }

    private void assertCustomFieldLabelEncoded(Locator locator) {
        this.text.assertTextPresent(locator.getHTML(), "&quot;&gt;&lt;iframe src=&quot;http://www.google.com&quot;&gt;&lt;/iframe&gt;&lt;a href=&quot;#&quot; rel=&quot;");
        this.text.assertTextNotPresent(locator.getHTML(), "\"><iframe src=\"http://www.google.com\"></iframe><a href=\"#\" rel=\"");
    }
}

