/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.Searcher;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestIssueNavigator
extends AbstractJqlFuncTest {
    private static final String FIELD_FIX_VERSION = "Fix Version";
    private static final String FIELD_AFFECTS_VERSION = "Affects Version";
    private static final String FIELD_COMPONENTS = "Component";
    private static final String CUSTOM_FIELD_GLOBAL = "global custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE = "issueType only custom field";
    private static final String CUSTOM_FIELD_PROJECT = "project only custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE_AND_PROJECT = "issue type & project custom field";
    private static final String PROJECT_DOG = "dog";
    private static final String PROJECT_HOMOSAP = "homosapien";
    private static final String homosapId = "10000";
    private static final Long homosapIdLong = 1000L;
    private static final Long hspUnresolvedFilterId = 10010L;
    private static final String GROUP_NAME = "test group";
    private static final List<CustomFieldValue>[] cfValuesPerIssue = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
    private static final String issueKey = "HSP-1";
    private static final String issueKey2 = "HSP-2";
    private static final String issueKey3 = "HSP-3";
    private static final String issueKey4 = "HSP-4";
    private static final String customFieldIdSelectList = "10000";
    private static final String customFieldIdRadioButton = "10001";
    private static final String customFieldIdMultiSelect = "10002";
    private static final String customFieldIdCheckBox = "10003";
    private static final String customFieldIdTextField = "10004";
    private static final String customFieldIdUserPicker = "10005";
    private static final String customFieldIdDatePicker = "10006";
    private static final String CUSTOM_FIELD_SELECT = "Custom Field Select";
    private static final String CUSTOM_FIELD_RADIO = "Custom Field Radio";
    private static final String CUSTOM_FIELD_MULTI_SELECT = "Custom Field Multi Select";
    private static final String CUSTOM_FIELD_TEXTFIELD = "Custom Field Text Field";
    private static final String CUSTOM_FIELD_CHECKBOX = "Custom Field Check Box";
    private static final String CUSTOM_FIELD_USERPICKER = "Custom Field User Picker";
    private static final String CUSTOM_FIELD_DATEPICKER = "Custom Field Date Picker";
    private static final String ABC_USERNAME = "abcuser";
    private static final String DEF_USERNAME = "defuser";
    private static final String GHI_USERNAME = "ghiuser";
    private static final String RESULTS_COUNT_CLASS = ".results-count";
    private static final String[] defaultOptions = new String[]{"abc", "def", "ghi"};
    private static final String[] dateOptions = new String[]{"01/Jan/05", "01/Feb/05", "01/Mar/05"};
    private static final String[] userOptions = new String[]{"abcuser", "defuser", "ghiuser"};
    private static final String[] customFieldNames = new String[]{"Custom Field Select", "Custom Field Radio", "Custom Field Text Field", "Custom Field Multi Select", "Custom Field Check Box", "Custom Field User Picker", "Custom Field Date Picker"};
    private static final String[] customFieldIds = new String[]{"10000", "10001", "10004", "10002", "10003", "10005", "10006"};

    public void testSubtaskIssueNavigatorColumn() {
        this.administration.restoreData("TestIssueNavigatorSubtaskColumnView.xml");
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().createSearch("");
        this.text.assertTextPresent("HSP-5");
        this.text.assertTextPresent("HSP-6");
        this.log("Successfully found subtask issue keys in the subtask issue navigator column");
    }

    protected void removeColumnFromIssueNavigatorByPosition(int pos) {
        this.tester.clickLink("Profile");
        this.tester.clickLink("view_nav_columns");
        this.tester.clickLink("del_col_" + pos);
    }

    public void testNavigatorColumnVisibilityForCustomFields() {
        this.administration.restoreData("TestIssueNavigatorColumnVisibilityForCustomFields.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String dogProjectId = "10010";
        this.navigation.issueNavigator().displayAllIssues();
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=homosapien");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=homosapien AND issuetype= Bug");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=dog");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project=dog AND issuetype= Bug");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project in (10010, 10000)");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
        this.navigation.issueNavigator().createSearch("project in (10010, 10000) AND issuetype= Bug");
        this.assertTextInIssueTable("homosapien cf");
        this.assertTextInIssueTable("homosapien bug cf");
        this.assertTextInIssueTable("dog cf");
        this.assertTextInIssueTable("dog bug cf");
    }

    public void testSearchAfterProjectRemoval() {
        this.log("Issue Navigator: Searching right after removal of the last searched project");
        this.administration.restoreData("TestIssueNavigatorSearchAfterProjectRemoval.xml");
        this.tester.gotoPage("/issues/?filter=10000");
        this.administration.project().deleteProject(homosapIdLong);
        this.administration.project().addProject(PROJECT_HOMOSAP, "HSP", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextNotPresent("A system error has occurred");
    }

    public void testJQLWarningShownForInvalidProject() {
        this.log("Issue Navigator: Test project componenets visibility");
        this.administration.restoreData("TestIssueNavigatorProjectComponentsVisibility.xml");
        this.issueTableAssertions.assertSearchWithError("project=99999", "A value with ID '99999' does not exist for the field 'project'.");
        this.issueTableAssertions.assertSearchWithErrors("project=99999 AND project=88888", Lists.newArrayList((Object[])new String[]{"A value with ID '99999' does not exist for the field 'project'.", "A value with ID '88888' does not exist for the field 'project'."}));
        this.issueTableAssertions.assertSearchWithErrors("project=99999 AND project=88888 AND project=10010", Lists.newArrayList((Object[])new String[]{"A value with ID '99999' does not exist for the field 'project'.", "A value with ID '88888' does not exist for the field 'project'."}));
    }

    public void testCustomfieldVisibility() {
        this.administration.restoreData("TestIssueNavigatorCustomfieldVisibility.xml");
        List<Searcher> searchers = this.backdoor.searchersClient().allSearchers("");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        searchers = this.backdoor.searchersClient().allSearchers("type=bug");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        searchers = this.backdoor.searchersClient().allSearchers("project=10000");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherNotPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        searchers = this.backdoor.searchersClient().allSearchers("project=10000 and type=bug");
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_GLOBAL);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_ISSUETYPE);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_PROJECT);
        this.assertSearcherPresent(searchers, CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
    }

    private void assertSearcherPresent(List<Searcher> searchers, String name) {
        for (Searcher searcher : searchers) {
            if (!name.equals(searcher.getName())) continue;
            TestIssueNavigator.assertTrue((String)("Expected searcher with name " + name + " is shown"), (boolean)searcher.getShown());
            return;
        }
        TestIssueNavigator.fail((String)("Searcher with name " + name + " expected in response"));
    }

    private void assertSearcherNotPresent(List<Searcher> searchers, String name) {
        for (Searcher searcher : searchers) {
            if (!name.equals(searcher.getName())) continue;
            TestIssueNavigator.assertFalse((String)("Expected searcher with name " + name + " is not shown"), (boolean)searcher.getShown());
        }
    }

    public void testIssueNavigatorSortByCustomField() {
        this.log("Issue Navigator: Test that the filter correctly orders issues for custom fields.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().addColumnToIssueNavigator(customFieldNames);
        this.navigation.issueNavigator().displayAllIssues();
        for (int i = 0; i < customFieldIds.length; ++i) {
            this.log("Sorting by " + customFieldNames[i]);
            this.navigation.issueNavigator().sortIssues("cf[" + customFieldIds[i] + "]", "ASC");
            this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey, issueKey2, issueKey3, issueKey4});
            this.navigation.issueNavigator().sortIssues("cf[" + customFieldIds[i] + "]", "DESC");
            this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey4, issueKey3, issueKey2, issueKey});
        }
        this.navigation.issueNavigator().restoreColumnDefaults();
    }

    public void testIssueNavigatorSortByComponent() {
        this.log("Issue Navigator: Test that the filter correctly orders issues for components.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.tester.gotoPage("/issues/?jql=ORDER BY component ASC, key ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey4, issueKey2, issueKey, issueKey3});
        this.tester.gotoPage("/issues/?jql=ORDER BY component DESC, key DESC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey3, issueKey, issueKey2, issueKey4});
    }

    public void testIssueNavigatorHideReporter() {
        this.log("Issue Navigator: Test that the filter correctly hides the reporter field with full content view.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Reporter");
        this.navigation.gotoFullContentView("");
        this.text.assertTextNotPresent("Reporter");
        this.tester.clickLinkWithText("test issue 1");
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Reporter");
        this.navigation.gotoFullContentView("");
        this.text.assertTextPresent("Reporter");
        this.tester.clickLinkWithText("test issue 1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueNavigatorSelectGroup() {
        this.log("Issue Navigator: Test that all issues are filtered for a specific group");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.usersAndGroups().addGroup(GROUP_NAME);
        this.backdoor.usersAndGroups().addUserToGroup("bob", GROUP_NAME);
        String testIssueKey = this.navigation.issue().createIssue(PROJECT_HOMOSAP, "Bug", "test issue 5");
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        try {
            this.navigation.issue().assignIssue(testIssueKey, "Assign to Bob", "Bob The Builder");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.assertSearchWithResults("assignee in membersOf(\"test group\")", testIssueKey, issueKey3, issueKey);
        this.navigation.issue().deleteIssue(testIssueKey);
        this.administration.usersAndGroups().deleteGroup(GROUP_NAME);
    }

    public void testIssueNavigatorXMLViewWithCustomFields() throws Exception {
        this.log("Issue Navigator: Test that the RSS page correctly shows the custom field information.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.navigation.issueNavigator().addColumnToIssueNavigator(customFieldNames);
        this.navigation.gotoXmlView("");
        this.text.assertTextPresent("An XML representation of a search request");
        this.text.assertTextPresent("[HSP-1] test issue 1");
        Document doc = XMLUnit.buildControlDocument((String)this.tester.getDialog().getResponse().getText());
        for (List<CustomFieldValue> values : cfValuesPerIssue) {
            for (CustomFieldValue customFieldValue : values) {
                if (customFieldValue.getCfType().equals("datepicker")) continue;
                this.log("Searching for existence of xpath //item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]");
                XMLAssert.assertXpathExists((String)("//item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]"), (Document)doc);
            }
        }
    }

    private String getCustomFieldNameFromType(String type) {
        if (type.equals("select")) {
            return CUSTOM_FIELD_SELECT;
        }
        if (type.equals("radiobuttons")) {
            return CUSTOM_FIELD_RADIO;
        }
        if (type.equals("multiselect")) {
            return CUSTOM_FIELD_MULTI_SELECT;
        }
        if (type.equals("multicheckboxes")) {
            return CUSTOM_FIELD_CHECKBOX;
        }
        if (type.equals("textfield")) {
            return CUSTOM_FIELD_TEXTFIELD;
        }
        if (type.equals("userpicker")) {
            return CUSTOM_FIELD_USERPICKER;
        }
        if (type.equals("datepicker")) {
            return CUSTOM_FIELD_DATEPICKER;
        }
        return null;
    }

    private void assertExpectedIssueLinksPresent() {
        this.tester.assertLinkNotPresentWithText("test issue 1");
        this.tester.assertLinkNotPresentWithText("test issue 3");
        this.tester.assertLinkPresentWithText("test issue 2");
        this.tester.assertLinkPresentWithText("test issue 4");
    }

    public void testNavigatorOrdering() {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.tester.gotoPage("/issues/?jql=ORDER BY summary ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.tester.gotoPage("/issues/?jql=ORDER BY assignee ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"Administrator", "Administrator", "Bob The Builder", "Bob The Builder"});
        this.tester.gotoPage("/issues/?jql=ORDER BY summary ASC, duedate ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.tester.gotoPage("/issues/?jql=ORDER BY summary ASC, workratio ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
    }

    public void testSearchSortDescriptionForInvalidField() throws Exception {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        long id = Long.parseLong(this.backdoor.filters().createFilter("ORDER BY cf[10006] ASC", "My Test Filter"));
        this.tester.gotoPage("/issues/?filter=" + id);
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("del_customfield_10006");
        this.tester.submit("Delete");
        this.tester.gotoPage("/issues/?filter=" + id);
        this.tester.assertElementNotPresent("issuetable");
    }

    public void testNoColumnsDialog() throws Exception {
        this.administration.restoreData("TestIssueNavigatorNoColumns.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        new TextAssertionsImpl().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"No columns selected"});
    }

    public void testCanSearchForTextWithDotAndColon() throws Exception {
        this.administration.restoreData("TestIssueNavigatorTextWithDotAndColon.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().createSearch("description ~ \"d.dude:123\" order by key desc");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("TST-1");
        this.navigation.issueNavigator().createSearch("description ~ \"dude\" order by key asc");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("TST-1", "TST-2");
    }

    public void testXssInImageUrls() throws Exception {
        this.administration.restoreData("TestImageUrlXss.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().createSearch("");
        this.tester.assertTextNotPresent("\"'/><script>alert('prioritiezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('prioritiezz');&lt;/script&gt;");
        this.tester.assertTextNotPresent("\"'/><script>alert('issue typezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('issue typezz');&lt;/script&gt;");
    }

    private void assertTextNotInIssueTable(String pagetext) {
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//table[@id='issuetable']"), pagetext);
    }

    private void assertTextInIssueTable(String pagetext) {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='issuetable']"), pagetext);
    }
}

