/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigator.IssueTableDoesNotHaveColumnCondition;
import com.atlassian.jira.functest.framework.navigator.IssueTableHasColumnCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponseUtil;
import java.util.Arrays;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestCustomFieldsVisibilityWhenExportingAllColumnsToExcel
extends FuncTestCase {
    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAllProjectsAndWeSearchForAllIssuesInAllProjects() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInAllProjects();
        String allIssuesInAllProjects = "";
        this.exportJqlToExcel(allIssuesInAllProjects);
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAllProjectsAndWeSearchForASpecificProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInAllProjects();
        this.exportJqlToExcel("project = 'project 1'");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAllProjectsAndWeSearchForASpecificIssueType() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInAllProjects();
        this.exportJqlToExcel("issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAllProjectsAndWeSearchForASpecificProjectAndIssueType() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInAllProjects();
        this.exportJqlToExcel("project = 'project 1' AND issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllProjectsAndASpecificIssueTypeAndWeSearchForAllIssuesInAllProjects() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInAllProjects();
        String allIssuesInAllProjects = "";
        this.exportJqlToExcel(allIssuesInAllProjects);
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllProjectsAndASpecificIssueTypeAndWeSearchForAllIssuesInASpecificProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInAllProjects();
        this.exportJqlToExcel("project = 'project 1'");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllProjectsAndASpecificIssueTypeAndWeSearchForAllIssuesOfThatSpecificType() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInAllProjects();
        this.exportJqlToExcel("issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllProjectsAndASpecificIssueTypeAndWeSearchForAllIssuesOfThatSpecificTypeWithinAProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInAllProjects();
        this.exportJqlToExcel("project = 'project 1' AND issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsNotExportedToExcelWhenCustomFieldAppliesToAllProjectsAndASpecificIssueTypeAndWeSearchForAllIssuesOfADifferentIssueType() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInAllProjects();
        this.exportJqlToExcel("issuetype = Task");
        this.assertColumnIsNotExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAProjectAndWeSearchForAllIssuesInAllProjects() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInProject1();
        String allIssuesInAllProjects = "";
        this.exportJqlToExcel(allIssuesInAllProjects);
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAProjectAndWeSearchForAllIssuesInThatSpecificProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInProject1();
        this.exportJqlToExcel("project = 'project 1'");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAProjectAndWeSearchForIssuesOfASpecificTypeOnAnyProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInProject1();
        this.exportJqlToExcel("issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToAllIssuesInAProjectAndWeSearchForIssuesOfASpecificTypeInThatSpecificProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInProject1();
        this.exportJqlToExcel("project = 'project 1' AND issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsNotExportedToExcelWhenCustomFieldAppliesToAllIssuesInAProjectAndWeSearchForAllIssuesInADifferentProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInProject1();
        this.exportJqlToExcel("project = 'project 2'");
        this.assertColumnIsNotExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToIssuesOfASpecificTypeInAProjectAndWeSearchForAllIssuesInAllProjects() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInProject1();
        String allIssuesInAllProjects = "";
        this.exportJqlToExcel(allIssuesInAllProjects);
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToIssuesOfASpecificTypeInAProjectAndWeSearchForAllIssuesInThatProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInProject1();
        this.exportJqlToExcel("project = 'project 1'");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToIssuesOfASpecificTypeInAProjectAndWeSearchForAllIssuesOfThatType() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInProject1();
        this.exportJqlToExcel("issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsExportedToExcelWhenCustomFieldAppliesToIssuesOfASpecificTypeInAProjectAndWeSearchForAllIssuesOfThatTypeAndInThatProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInProject1();
        this.exportJqlToExcel("project = 'project 1' AND issuetype = Bug");
        this.assertColumnIsExported("Custom Field");
    }

    public void testCustomFieldIsNotExportedToExcelWhenCustomFieldAppliesToIssuesOfASpecificTypeInAProjectAndWeSearchForAllIssuesInADifferentProject() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInProject1();
        this.exportJqlToExcel("project = 'project 2'");
        this.assertColumnIsNotExported("Custom Field");
    }

    public void testCustomFieldIsNotExportedToExcelWhenCustomFieldAppliesToIssuesOfASpecificTypeInAProjectAndWeSearchForAllIssuesWithDifferentType() {
        this.restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInProject1();
        this.exportJqlToExcel("issuetype = Task");
        this.assertColumnIsNotExported("Custom Field");
    }

    public void testCustomFieldIsNotExportedToExcelWhenCustomFieldDoesNotHaveConfigurationSchemesAndWeSearchForAllIssuesInAllProjects() {
        this.restoreJiraWithOneProjectAndACustomFieldWithNoConfigurationSchemes();
        String allIssuesInAllProjects = "";
        this.exportJqlToExcel(allIssuesInAllProjects);
        this.assertColumnIsNotExported("Custom Field");
    }

    private void restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInAllProjects() {
        this.administration.restoreDataAndLogin("TestExportAllColumnsExcel/CustomFieldAppliesToAllIssuesInAllProjects.xml", "admin");
    }

    private void restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInAllProjects() {
        this.administration.restoreDataAndLogin("TestExportAllColumnsExcel/CustomFieldAppliesToAllBugsInAllProjects.xml", "admin");
    }

    private void restoreJiraWithTwoProjectsAndACustomFieldForAllIssuesInProject1() {
        this.administration.restoreDataAndLogin("TestExportAllColumnsExcel/CustomFieldAppliesToAllIssuesInProject1.xml", "admin");
    }

    private void restoreJiraWithTwoProjectsAndACustomFieldForAllBugsInProject1() {
        this.administration.restoreDataAndLogin("TestExportAllColumnsExcel/CustomFieldAppliesToAllBugsInProject1.xml", "admin");
    }

    private void restoreJiraWithOneProjectAndACustomFieldWithNoConfigurationSchemes() {
        this.administration.restoreDataAndLogin("TestExportAllColumnsExcel/CustomFieldHasNoConfigurationSchemes.xml", "admin");
    }

    private void exportJqlToExcel(String jql) {
        String filterId = this.backdoor.filters().createFilter(jql, "filterName");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-excel-all-fields/" + filterId + "/SearchRequest-" + filterId + ".xls?tempMax=1000");
        if (!WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html")) {
            TestCustomFieldsVisibilityWhenExportingAllColumnsToExcel.fail((String)"Failed to replace response content type with 'text/html'");
        }
    }

    private void assertColumnIsExported(String columnName) {
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(Arrays.asList(new IssueTableHasColumnCondition(columnName)));
    }

    private void assertColumnIsNotExported(String columnName) {
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(Arrays.asList(new IssueTableDoesNotHaveColumnCondition(columnName)));
    }
}

