/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigator.ValueForRowAtColumnCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
public class TestCustomFieldsVisibilityOnIssueTable
extends FuncTestCase {
    private static final String ALL_ISSUES_IN_ALL_PROJECTS_JQL = "";

    public void testOldFieldValuesForCustomFieldsAreNotDisplayedOnIssueTableWhenCustomFieldIsNotVisibleAccordingToTheProjectFieldScheme() {
        this.restoreJiraWithAnIssueWithAValueOnACustomFieldThatItsHiddenAccordingToTheProjectFieldScheme();
        this.searchForAllIssues();
        this.assertCustomFieldColumnDoesNotShowOldValueForTheIssue();
    }

    private void restoreJiraWithAnIssueWithAValueOnACustomFieldThatItsHiddenAccordingToTheProjectFieldScheme() {
        this.administration.restoreDataAndLogin("CustomFieldHiddenOnProjectByFieldScheme.xml", "admin");
    }

    private void searchForAllIssues() {
        this.navigation.issueNavigator().createSearch(ALL_ISSUES_IN_ALL_PROJECTS_JQL);
    }

    private void assertCustomFieldColumnDoesNotShowOldValueForTheIssue() {
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(Arrays.asList(new ValueForRowAtColumnCondition(1, "Custom Field", null)));
    }
}

