/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.config.FuncProperties;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.LICENSING, Category.DATABASE})
public class TestSetup
extends FuncTestCase {
    private static final String CONFIGURE_APP_PROPERTIES_TITLE = "Set Up Application Properties";
    private static final String SET_UP_LICENSE = "Specify Your License Key";
    private static final String SET_UP_ADMIN_ACCOUNT_TITLE = "Set Up Administrator Account";

    public void testSetupCannotBeRunTwice() {
        this.administration.restoreBlankInstance();
        String[] actions = new String[]{"SetupDatabase.jspa", "SetupApplicationProperties.jspa", "SetupApplicationProperties!default.jspa", "SetupAdminAccount.jspa", "SetupAdminAccount!default.jspa", "SetupMailNotifications.jspa", "SetupMailNotifications!default.jspa", "SetupComplete.jspa", "SetupComplete!default.jspa", "SetupImport.jspa", "SetupImport!default.jspa"};
        String[] views = new String[]{"setup-application-properties.jsp", "setup-admin-account.jsp", "setup-mail-notifications.jsp", "setup-import.jsp"};
        for (String action : actions) {
            this.tester.gotoPage("/secure/" + action);
            this.assertSetupAlreadyLong();
        }
        for (String view : views) {
            this.tester.gotoPage("/views/" + view);
            this.assertSetupAlreadyShort();
        }
    }

    public void testMissingTitle() throws Exception {
        this.gotoSetUpApplicationProperties();
        this.tester.submit();
        this.tester.assertTextPresent(CONFIGURE_APP_PROPERTIES_TITLE);
        this.tester.assertTextPresent("You must specify a title.");
    }

    public void testInvalidBaseUrls() throws Exception {
        String[] invalidBaseUrls = new String[]{"", "http", "http://", "http://*&^%$#@", "http://example url.com:8090", "ldap://example.url.com:8090", "http://example.url.com:not_a_port", "http://example.url.com:8090/invalid path"};
        this.gotoSetUpApplicationProperties();
        for (String invalidBaseUrl : invalidBaseUrls) {
            this.tester.setFormElement("baseURL", invalidBaseUrl);
            this.tester.submit();
            this.tester.assertTextPresent("The URL specified is not valid.");
        }
    }

    public void testMissingLicense() throws Exception {
        this.doConfigureApplicationProperties();
        this.doSetupProductBundle();
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.submit();
        this.tester.assertTextPresent(SET_UP_LICENSE);
    }

    public void testInvalidLicense() throws Exception {
        this.doConfigureApplicationProperties();
        this.doSetupProductBundle();
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", "blah");
        this.tester.submit();
        this.tester.assertTextPresent(SET_UP_LICENSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidSmtpPorts() throws Exception {
        this.doConfigureApplicationProperties();
        this.doSetupProductBundle();
        this.doSetupLicense();
        this.doSetUpAdminAccount();
        try {
            this.tester.checkRadioOption("noemail", "false");
            this.tester.setFormElement("serverName", "localhost");
            this.tester.setFormElement("port", "-1");
            this.tester.submit("finish");
            this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
            this.tester.setFormElement("serverName", "localhost");
            this.tester.setFormElement("port", String.valueOf(65536));
            this.tester.submit("finish");
            this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
        }
        finally {
            this.tester.setFormElement("serverName", "localhost");
            this.tester.setFormElement("port", "23000");
            this.tester.submit("finish");
        }
    }

    public void testSetupWithDefaulExctDirectories() throws IOException {
        this.gotoSetUpApplicationProperties();
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.submit();
        this.doSetupProductBundle();
        this.doSetupLicense();
        this.doSetUpAdminAccountAndEmailNotifications();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "h2"), "Attachments");
        WebTable AttachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("table-AttachmentSettings");
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowHeading(1)), "Allow Attachments");
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowValue(1)), "ON");
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowHeading(2)), "Attachment Path");
        this.assertions.assertNodeHasText(new XPathLocator(this.tester, this.tableAttachmentSettingsRowValue(2)), "Default Directory [");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INDEXING);
        this.tester.assertTextPresent("Re-Indexing");
        this.administration.services().goTo();
        this.tester.assertTextPresent("Backup Service");
        this.tester.assertTextPresent("<strong>USE_DEFAULT_DIRECTORY:</strong> true");
        this.tester.assertTextNotPresent("DIR_NAME:");
        this.assertTimeTrackingActivationAndDefaultValues();
        this.assertIssueLinking();
    }

    private String tableAttachmentSettingsRowHeading(int rowNumber) {
        return "//table[@id='table-AttachmentSettings']/tbody/tr[" + rowNumber + "]/td/strong";
    }

    private String tableAttachmentSettingsRowValue(int rowNumber) {
        return "//table[@id='table-AttachmentSettings']/tbody/tr[" + rowNumber + "]/td";
    }

    public void testSetupImportMissingFilename() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.setFormElement("filename", "");
        this.tester.submit();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("You must enter the location of an XML file.");
        this.tester.assertTextNotPresent("You must specify a location for index files");
    }

    public void testSetupImportInvalidLicense() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.setFormElement("filename", File.createTempFile("import", ".xml").getAbsolutePath());
        this.tester.setFormElement("license", "wrong");
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("Invalid license key specified.");
        this.tester.assertTextNotPresent("You must enter the location of an XML file.");
    }

    public void testSetupImportWithDodgyIndexPath() throws IOException {
        this.restoreEmptyInstance();
        File indexPath = File.createTempFile("testXmlImportWithInvalidIndexDirectory", null);
        indexPath.createNewFile();
        indexPath.deleteOnExit();
        File dataFile = this.administration.replaceTokensInFile("TestSetupInvalidIndexPath.xml", EasyMap.build((Object)"@@INDEX_PATH@@", (Object)indexPath.getAbsolutePath()));
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.administration.waitForRestore();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Cannot write to index directory. Check that the application server and JIRA have permissions to write to: " + indexPath.getAbsolutePath());
    }

    public void testSetupImportWithDodgyAttachmentPath() throws IOException {
        this.restoreEmptyInstance();
        File attachmentPath = File.createTempFile("testXmlImportWithInvalidAttachmentDirectory", null);
        attachmentPath.createNewFile();
        attachmentPath.deleteOnExit();
        File dataFile = this.administration.replaceTokensInFile("TestSetupInvalidAttachmentPath.xml", EasyMap.build((Object)"@@ATTACHMENT_PATH@@", (Object)attachmentPath.getAbsolutePath()));
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.administration.waitForRestore();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Cannot write to attachment directory. Check that the application server and JIRA have permissions to write to: " + attachmentPath.getAbsolutePath());
    }

    public void testSetupImportShouldDisplayAnErrorWhenAttemptingToDowngradeFromAnAllowedVersion() throws Exception {
        this.restoreEmptyInstance();
        File dataFile = this.administration.replaceTokensInFile("TestSetupDowngrade.xml", (Map<String, String>)ImmutableMap.of((Object)"@@VERSION@@", (Object)"4.0"));
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.administration.waitForRestore();
        this.text.assertTextPresent(this.locator.css("div.error"), "You are attempting to import data from JIRA X");
        this.text.assertTextPresent(this.locator.css("div.error"), "Click here to acknowledge this error and proceed anyway.");
        this.assertions.assertNodeExists(this.locator.css("a#acknowledgeDowngradeError"));
    }

    public void testSetupImportShouldAllowDowngradeOnceDowngradeErrorHasBeenAcknowledged() throws Exception {
        this.restoreEmptyInstance();
        File dataFile = this.administration.replaceTokensInFile("TestSetupDowngrade.xml", (Map<String, String>)ImmutableMap.of((Object)"@@VERSION@@", (Object)"4.0"));
        this.tester.gotoPage("secure/SetupImport!default.jspa?downgradeAnyway=true");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("You have finished importing your existing data, JIRA is ready to use.  Please log in and get started.");
    }

    public void testSetupImportDefaultIndexDirectory() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("You have finished importing your existing data, JIRA is ready to use.  Please log in and get started.");
        this.navigation.disableWebSudo();
        this.navigation.login("admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INDEXING);
        this.tester.assertTextPresent("Re-Indexing");
    }

    public void testSetupImportDefaultsForSetupComplete() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.administration.waitForRestore();
        this.tester.assertTextPresent("You have finished importing your existing data, JIRA is ready to use.  Please log in and get started.");
        this.navigation.disableWebSudo();
        this.navigation.login("admin");
        this.assertSubTasksDisabled();
        this.assertDefaultTextRendererIsSetForAllRenderableFields();
    }

    private void assertSubTasksDisabled() {
        TestSetup.assertFalse((String)"Sub-tasks were enabled when they shouldn't have been", (boolean)this.administration.subtasks().isEnabled());
    }

    private void assertDefaultTextRendererIsSetForAllRenderableFields() {
        String[] renderableFields;
        for (String fieldName : renderableFields = new String[]{"Comment", "Description", "Environment"}) {
            TestSetup.assertEquals((String)"Default Text Renderer", (String)this.administration.fieldConfigurations().defaultFieldConfiguration().getRenderer(fieldName));
        }
    }

    private void restoreEmptyInstance() {
        this.administration.restoreNotSetupInstance();
    }

    private void assertTimeTrackingActivationAndDefaultValues() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.tester.assertTextPresent("The number of working hours per day is <b>8");
        this.tester.assertTextPresent("The number of working days per week is <b>5");
    }

    private void assertIssueLinking() {
        this.tester.gotoPage("secure/admin/ViewLinkTypes!default.jspa");
        WebPageLocator page = new WebPageLocator(this.tester);
        this.text.assertTextPresent(page, "Issue linking is currently ON.");
        this.text.assertTextSequence(page, new String[]{"Blocks", "blocks", "is blocked by"});
        this.text.assertTextSequence(page, new String[]{"Cloners", "clones", "is cloned by"});
        this.text.assertTextSequence(page, new String[]{"Duplicate", "duplicates", "is duplicated by"});
        this.text.assertTextSequence(page, new String[]{"Relates", "relates to", "relates to"});
    }

    private void assertSetupAlreadyLong() {
        this.tester.assertTextPresent("JIRA Setup has already completed");
        this.tester.assertTextPresent("It seems that you have tried to set up JIRA when this process has already been done.");
    }

    private void assertSetupAlreadyShort() {
        this.tester.assertTextPresent("JIRA has already been set up.");
    }

    private void doConfigureApplicationProperties() {
        this.gotoSetUpApplicationProperties();
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "TestSetup JIRA");
        this.tester.submit();
    }

    private void doSetUpAdminAccountAndEmailNotifications() {
        this.doSetUpAdminAccount();
        this.doSetUpEmailNotifications();
    }

    private void doSetUpEmailNotifications() {
        this.log("Noemail");
        this.tester.submit("finish");
        this.log("Noemail");
        this.tester.assertLinkPresent("header-details-user-fullname");
        this.navigation.disableWebSudo();
    }

    private void doSetUpAdminAccount() {
        this.tester.assertTextPresent(SET_UP_ADMIN_ACCOUNT_TITLE);
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
    }

    private void gotoSetUpApplicationProperties() {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupApplicationProperties.jspa");
        this.tester.assertTextPresent(CONFIGURE_APP_PROPERTIES_TITLE);
    }

    private void doSetupProductBundle() {
        this.tester.assertElementPresent("jira-setup-product-bundle");
        this.tester.setWorkingForm("jira-setup-product-bundle");
        this.withHiddenFieldsTemporarilyEditable(new Runnable(){

            @Override
            public void run() {
                TestSetup.this.tester.setFormElement("selectedBundle", "TRACKING");
            }
        });
        this.tester.submit();
    }

    private void doSetupLicense() {
        this.tester.assertTextPresent(SET_UP_LICENSE);
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent(SET_UP_ADMIN_ACCOUNT_TITLE);
    }

    private String getDowngradeAllowedVersion() {
        return FuncProperties.get("jira.downgrade.minimum.build.version");
    }

    private void withHiddenFieldsTemporarilyEditable(Runnable runnable) {
        boolean isHiddenFieldsEditable = this.tester.getDialog().getWebClient().getClientProperties().isHiddenFieldsEditable();
        if (!isHiddenFieldsEditable) {
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
            runnable.run();
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(isHiddenFieldsEditable);
        } else {
            runnable.run();
        }
    }
}

