/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.meterware.httpunit.WebLink;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestSessionIdInUrl
extends FuncTestCase {
    public void testBrowseIssue() throws SAXException {
        this.administration.restoreBlankInstance();
        this.navigation.logout();
        this.tester.beginAt("/login.jsp");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.checkCheckbox("os_cookie", "true");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Bug 1");
        this.tester.selectOption("versions", "New Version 4");
        this.tester.selectOption("fixVersions", "New Version 5");
        this.tester.selectOption("components", "New Component 1");
        this.tester.selectOption("components", "New Component 2");
        this.tester.submit("Create");
        this.text.assertTextPresent(this.locator.page(), "New Component 2");
        this.text.assertTextPresent(this.locator.page(), "New Version 4");
        this.text.assertTextPresent(this.locator.page(), "New Version 5");
        this.tester.assertLinkPresentWithText("New Component 2");
        this.tester.assertLinkNotPresentWithText("New Version 4");
        this.tester.assertLinkPresentWithText("New Version 5");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        Long schemeId = this.backdoor.project().getSchemes((Long)projectId).permissionScheme.id;
        this.tester.gotoPage("/secure/admin/EditPermissions!default.jspa?schemeId=" + schemeId);
        this.tester.clickLink("add_perm_" + ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
        this.tester.getDialog().getWebClient().clearContents();
        WebTesterFactory.setupWebTester(this.tester, this.environmentData);
        this.tester.gotoPage("/browse/HSP-1");
        this.text.assertTextPresent(this.locator.page(), "New Component 2");
        this.text.assertTextPresent(this.locator.page(), "New Version 4");
        this.text.assertTextPresent(this.locator.page(), "New Version 5");
        this.tester.assertLinkPresentWithText("New Component 2");
        this.tester.assertLinkNotPresentWithText("New Version 4");
        this.tester.assertLinkPresentWithText("New Version 5");
        WebLink componentLink = this.tester.getDialog().getResponse().getLinkWith("New Component 2");
        this.verifyUrl(componentLink.getURLString());
        WebLink fixVersionLink = this.tester.getDialog().getResponse().getLinkWith("New Version 5");
        this.verifyUrl(fixVersionLink.getURLString());
    }

    private void verifyUrl(String url) {
        String JSESSIONID = "jsessionid";
        int index = url.indexOf("jsessionid");
        int index2 = url.lastIndexOf("jsessionid");
        TestSessionIdInUrl.assertEquals((int)index, (int)index2);
    }
}

