/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST})
public class TestReportProblem
extends FuncTestCase {
    private static final String SUPPORT_TOOLS_PLUGIN_PATH = "/plugins/servlet/stp/view/";
    private static final String CONTACT_ADMIN_PATH = "/secure/ContactAdministrators!default.jspa";
    private static final String CREATE_ISSUE_PATH = "/secure/CreateIssue!default.jspa";
    private static final String JIRA_SHOW_CONTACT_ADMINISTRATORS_FORM = "jira.show.contact.administrators.form";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReportProblemDoesNotRedirectToSupportToolsPluginForJiraAdmin() {
        this.administration.restoreData("TestWithSystemAdmin.xml");
        try {
            this.navigation.login("admin", "admin");
            this.text.assertTextNotPresent(this.getReportProblemHref(), SUPPORT_TOOLS_PLUGIN_PATH);
        }
        finally {
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReportProblemRedirectsToSupportToolsPluginForSysAdmin() {
        this.administration.restoreData("TestWithSystemAdmin.xml");
        try {
            this.navigation.login("root", "root");
            this.text.assertTextPresent(this.getReportProblemHref(), SUPPORT_TOOLS_PLUGIN_PATH);
        }
        finally {
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReportProblemRedirectsToContactAdminWhenEnabledForLoggedInUsers() {
        try {
            this.administration.restoreBlankInstance();
            this.setShowContactAdminForm(true);
            this.navigation.login("fred", "fred");
            this.text.assertTextPresent(this.getReportProblemHref(), CONTACT_ADMIN_PATH);
        }
        finally {
            this.setShowContactAdminForm(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReportProblemRedirectsToContactAdminWhenEnabledForLoggedOutUsers() {
        this.setShowContactAdminForm(true);
        try {
            this.navigation.logout();
            this.text.assertTextPresent(this.getReportProblemHref(), CONTACT_ADMIN_PATH);
        }
        finally {
            this.setShowContactAdminForm(false);
        }
    }

    public void testReportProblemRedirectsToCreateIssueWhenContactAdminDisabledForLoggedInUsers() {
        this.administration.restoreBlankInstance();
        this.setShowContactAdminForm(false);
        this.navigation.login("fred", "fred");
        this.text.assertTextPresent(this.getReportProblemHref(), CREATE_ISSUE_PATH);
    }

    public void testReportProblemRedirectsToCreateIssueWhenContactAdminDisabledForLoggedOutUsers() {
        this.navigation.logout();
        this.text.assertTextPresent(this.getReportProblemHref(), CREATE_ISSUE_PATH);
    }

    private String getReportProblemHref() {
        return this.page.getFooter().getReportProblemLink().getURLString();
    }

    private void setShowContactAdminForm(boolean show) {
        this.backdoor.applicationProperties().setOption(JIRA_SHOW_CONTACT_ADMINISTRATORS_FORM, show);
    }
}

