/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestRememberMeCookie
extends FuncTestCase {
    private static final String USER_LAGONIL = "lagonil";
    private static final String SERAPH_REMEMBERME_COOKIE = "seraph.rememberme.cookie";

    public void testRememberMeCookieWorks() {
        this.administration.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUser(USER_LAGONIL);
        this.navigation.login(USER_LAGONIL, USER_LAGONIL, true);
        this.tester.assertLinkPresent("find_link");
        TestRememberMeCookie.assertTrue((boolean)this.navigation.userProfile().link().isPresent());
        TestRememberMeCookie.assertEquals((String)this.navigation.userProfile().userName(), (String)USER_LAGONIL);
        String seraphCookie = this.tester.getDialog().getWebClient().getCookieValue(SERAPH_REMEMBERME_COOKIE);
        TestRememberMeCookie.assertNotNull((String)"Didnt find cookie as expected", (Object)seraphCookie);
        TestRememberMeCookie.assertFalse((String)("Found bad characters in cookie: " + seraphCookie), (boolean)seraphCookie.contains(">"));
        TestRememberMeCookie.assertFalse((String)("Found bad characters in cookie: " + seraphCookie), (boolean)seraphCookie.contains("<"));
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkNotPresent("find_link");
        TestRememberMeCookie.assertFalse((boolean)this.navigation.userProfile().link().isPresent());
        this.tester.getDialog().getWebClient().clearCookies();
        this.tester.getDialog().getWebClient().addCookie(SERAPH_REMEMBERME_COOKIE, seraphCookie);
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkPresent("find_link");
        TestRememberMeCookie.assertTrue((boolean)this.navigation.userProfile().link().isPresent());
        TestRememberMeCookie.assertEquals((String)this.navigation.userProfile().userName(), (String)USER_LAGONIL);
    }
}

