/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

@WebTest(value={Category.DEV_MODE, Category.PLATFORM_COMPATIBILITY})
public class TestPlatformCompatibility
extends FuncTestCase {
    public static final String PROJECT_NAME = "tautomerism";
    public static final String ISSUE_SUMMARY = "jira blah blah";
    public static final String ISSUE_DESCRIPTION = "ho ho ho and a bottle of rum";
    private static final ImmutableMap<String, String> CTK_PROPERTIES = ImmutableMap.builder().put((Object)"platform.ctk.test.admin.username", (Object)"admin").put((Object)"platform.ctk.test.admin.password", (Object)"admin").put((Object)"platform.ctk.test.admin.fullname", (Object)"Administrator").put((Object)"platform.ctk.test.validlicense", (Object)LicenseKeys.V2_OPEN_SOURCE.getLicenseString()).put((Object)"platform.ctk.test.search.term", (Object)"jira blah blah").put((Object)"platform.ctk.test.search.term.matches", (Object)"ho ho ho and a bottle of rum").build();
    private static final String PLATFORM_CTK_PLUGIN_KEY = "com.atlassian.refapp.ctk";
    private static final String WEBSUDO_PROPERTY = "jira.websudo.is.disabled";
    private boolean shouldRun;
    private Boolean webSudoEnabled = null;
    private RestRule restRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.restRule = new RestRule(this);
        this.restRule.before();
        this.administration.restoreBlankInstance();
        this.shouldRun = this.isPlatformCtkPluginInstalled();
        if (this.shouldRun) {
            this.administration.project().addProject(PROJECT_NAME, "TTM", "admin");
            this.navigation.issue().createIssue(PROJECT_NAME, "Bug", ISSUE_SUMMARY, (Map<String, String[]>)ImmutableMap.of((Object)"description", (Object)new String[]{ISSUE_DESCRIPTION}));
            this.administration.reIndex();
            this.navigation.logout();
            this.webSudoEnabled = Boolean.valueOf(this.backdoor.systemProperties().getProperty(WEBSUDO_PROPERTY));
            this.backdoor.systemProperties().setProperty(WEBSUDO_PROPERTY, "false");
            for (String property : CTK_PROPERTIES.keySet()) {
                this.backdoor.systemProperties().setProperty(property, (String)CTK_PROPERTIES.get((Object)property));
            }
            this.backdoor.darkFeatures().enableForSite("foo");
        }
    }

    @Override
    protected void tearDownTest() {
        this.restRule.after();
        if (this.shouldRun) {
            for (String property : CTK_PROPERTIES.keySet()) {
                this.backdoor.systemProperties().unsetProperty(property);
            }
            this.backdoor.systemProperties().setProperty(WEBSUDO_PROPERTY, this.webSudoEnabled.toString());
        }
        super.tearDownTest();
    }

    public void testCtk() throws IOException, SAXException, JSONException {
        if (this.shouldRun) {
            this.log.log((Object)"found platform-ctk plugin. run it now!!");
            List<String> skipClasses = this.getSkippedClasses();
            if (skipClasses.size() == 0) {
                this.log.log((Object)"No skipped test. Full suite will be executed.");
            } else {
                this.log.log((Object)("Tests to be skipped: " + StringUtils.join(skipClasses, (String)"\n")));
            }
            String excludeParam = "";
            if (skipClasses.size() > 0) {
                excludeParam = this.generateExcludeRestParam(skipClasses);
            }
            WebResponse response = this.restRule.GET("/rest/functest/1.0/junit/runTests?outdir=target/runtest" + excludeParam, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            TestPlatformCompatibility.assertEquals((String)"application/json", (String)response.getContentType());
            TestPlatformCompatibility.assertEquals((String)"UTF-8", (String)response.getCharacterSet());
            JSONObject contents = new JSONObject(response.getText());
            int failures = Integer.parseInt(contents.getString("result"));
            if (failures > 0) {
                TestPlatformCompatibility.fail((String)("There were " + failures + " failures. See test output below.\n\n\n" + contents.getString("output")));
            }
        } else {
            this.log.log((Object)"platform-ctk plugin not found. skipped the test");
        }
    }

    private List<String> getSkippedClasses() {
        String skips = System.getProperty("platform.ctk.skips");
        if (skips == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Object[])StringUtils.split((String)skips, (String)","));
    }

    private String generateExcludeRestParam(List<String> skippedClasses) {
        StringBuilder output = new StringBuilder();
        for (String skippedClass : skippedClasses) {
            output.append("&excludes=");
            output.append(skippedClass);
        }
        return output.toString();
    }

    private boolean isPlatformCtkPluginInstalled() {
        this.navigation.gotoAdmin();
        return this.administration.plugins().isPluginInstalled(PLATFORM_CTK_PLUGIN_KEY);
    }
}

