/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestNoSessionOnRoot
extends FuncTestCase {
    public void testNoSessionAtRoot() throws Exception {
        String url = this.getEnvironmentData().getBaseUrl().toExternalForm();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        URL baseUrl = new URL(url);
        HttpURLConnection uc = (HttpURLConnection)baseUrl.openConnection();
        uc.setInstanceFollowRedirects(false);
        uc.connect();
        int responseCode = uc.getResponseCode();
        MatcherAssert.assertThat((String)"expect redirect", (Object)responseCode, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)301), Matchers.equalTo((Object)302)}));
        for (Map.Entry<String, List<String>> entry : uc.getHeaderFields().entrySet()) {
            if (!"Set-Cookie".equalsIgnoreCase(entry.getKey())) continue;
            String cookie = StringUtils.join((Collection)entry.getValue(), (String)" ").toLowerCase();
            MatcherAssert.assertThat((Object)cookie, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"jsessionid")));
            break;
        }
    }
}

