/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.SystemTenantOnly;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SystemTenantOnly
@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SETUP})
public class TestJohnsonFiltersWhileNotSetup
extends FuncTestCase {
    private static final Logger log = LoggerFactory.getLogger(TestJohnsonFiltersWhileNotSetup.class);

    public void test503Only() throws IOException {
        this.assert503Only("/si/whatever");
        this.assert503Only("/sr/whatever");
        this.assert503Only("/download/*");
        this.assert503Only("/plugins/servlet/*");
        this.assert503Only("/secure/attachment/blah-tricky.gif");
        this.assert503Only("/rest/some/rest");
        this.assert503Only("/rest/a");
    }

    public void testNotSetupMessage() {
        this.tester.beginAt("/browse/ABC-123");
        WebResponse webResponse = this.tester.getDialog().getResponse();
        TestJohnsonFiltersWhileNotSetup.assertEquals((String)"should be a 200 response", (int)200, (int)webResponse.getResponseCode());
        this.text.assertTextPresent(this.locator.page(), "JIRA setup");
    }

    private void assert503Only(String atUrl) throws IOException {
        try {
            this.tester.beginAt(atUrl);
        }
        catch (RuntimeException re) {
            log.warn("Not able to properly assert the response code, using crude (websphere) workaround instead");
            TestJohnsonFiltersWhileNotSetup.assertTrue((boolean)re.getMessage().contains("IOException"));
            TestJohnsonFiltersWhileNotSetup.assertTrue((boolean)re.getMessage().contains("503"));
            return;
        }
        WebResponse webResponse = this.tester.getDialog().getResponse();
        TestJohnsonFiltersWhileNotSetup.assertEquals((String)("expected service unavailable response for url: '" + atUrl + "'"), (int)503, (int)webResponse.getResponseCode());
        TestJohnsonFiltersWhileNotSetup.assertEquals((String)("should be no content for this url: '" + atUrl + "'"), (int)0, (int)webResponse.getText().length());
    }

    @Override
    protected boolean shouldSkipSetup() {
        return true;
    }

    @Override
    protected void setUpHttpUnitOptions() {
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Override
    public void setUpTest() {
        this.tester.getTestContext().setBaseUrl(this.getEnvironmentData().getBaseUrl().toExternalForm());
    }
}

