/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.SETUP})
public class TestDatabaseSetup
extends FuncTestCase {
    private RestRule restRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.restRule = new RestRule(this);
        this.restRule.before();
    }

    @Override
    protected void tearDownTest() {
        this.restRule.after();
        super.tearDownTest();
    }

    public void testAll() throws IOException, SAXException, JSONException {
        if (this.getEnvironmentData().getProperty("databaseType") != null) {
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
            this._testDirectJdbcSuccessful();
            this._testDirectJdbcMissingHostname();
            this._testDirectJdbcMissingPortNumber();
            this._testDirectJdbcInvalidPort();
            this._testDirectJdbcIncorrectPort();
            this._testDirectJdbcMissingUsername();
            this._testDirectJdbcInvalidCredential();
            this.configureDirectJdbc();
        } else {
            FuncTestOut.log((Object)"Skipping TestDatabaseSetup: Internal DB configured.");
        }
    }

    @Override
    protected boolean shouldSkipSetup() {
        return true;
    }

    private void configureDirectJdbc() {
        this.navigation.gotoPage("/secure/SetupDatabase!default.jspa");
        JiraSetupInstanceHelper.setupDirectJDBCConnection(this.tester, this.getEnvironmentData());
        this.text.assertTextPresent(this.locator.page(), "Set Up Application Properties");
    }

    private void _testDirectJdbcSuccessful() throws IOException, SAXException, JSONException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        this.assertTestConnectionSuccessful(query);
    }

    private void _testDirectJdbcMissingHostname() throws IOException, SAXException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        query.put("jdbcHostname", "");
        this.text.assertTextPresent(this.testConnection(query), "Hostname required");
    }

    private void _testDirectJdbcMissingPortNumber() throws IOException, SAXException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        query.put("jdbcPort", "");
        this.text.assertTextPresent(this.testConnection(query), "Port required");
    }

    private void _testDirectJdbcInvalidPort() throws IOException, SAXException, JSONException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        query.put("jdbcPort", "not-a-number");
        this.assertTestConnectionFailed(query);
    }

    private void _testDirectJdbcIncorrectPort() throws IOException, SAXException, JSONException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        query.put("jdbcPort", "999");
        this.assertTestConnectionFailed(query);
    }

    private void _testDirectJdbcInvalidCredential() throws IOException, SAXException, JSONException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        query.put("jdbcPassword", this.getEnvironmentData().getProperty("password") + "extra-text-to-invalidate-password");
        this.assertTestConnectionFailed(query);
    }

    private void _testDirectJdbcMissingUsername() throws IOException, SAXException {
        Map<String, String> query = this.fillValidDirectJdbcValues();
        query.put("jdbcUsername", "");
        this.text.assertTextPresent(this.testConnection(query), "Username required");
    }

    private Map<String, String> fillValidDirectJdbcValues() throws IOException, SAXException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("databaseOption", "external");
        query.put("databaseType", this.getEnvironmentData().getProperty("databaseType"));
        query.put("jdbcHostname", this.environmentData.getProperty("db.host"));
        query.put("jdbcPort", this.environmentData.getProperty("db.port"));
        query.put("jdbcSid", this.environmentData.getProperty("db.instance"));
        query.put("jdbcDatabase", this.environmentData.getProperty("db.instance"));
        query.put("jdbcUsername", this.getEnvironmentData().getProperty("username"));
        query.put("jdbcPassword", this.getEnvironmentData().getProperty("password"));
        query.put("schemaName", this.getEnvironmentData().getProperty("schema-name"));
        return query;
    }

    private void assertTestConnectionSuccessful(Map<String, String> query) throws IOException, SAXException, JSONException {
        Assert.assertTrue((boolean)new JSONObject(this.testConnection(query)).getJSONObject("data").getBoolean("dbTestSuccessful"));
    }

    private void assertTestConnectionFailed(Map<String, String> query) throws IOException, SAXException, JSONException {
        Assert.assertFalse((boolean)new JSONObject(this.testConnection(query)).getJSONObject("data").getBoolean("dbTestSuccessful"));
    }

    private String testConnection(Map<String, String> query) throws IOException, SAXException {
        WebResponse response = this.restRule.GET("/secure/SetupDatabase!connectionCheck.jspa?" + this.toQueryString(query));
        return response.getText();
    }

    private String toQueryString(Map<String, String> query) {
        return StringUtils.join((Iterable)Iterables.transform(query.entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> e) {
                return e.getKey() + "=" + e.getValue();
            }
        }), (char)'&');
    }
}

