/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestBasic
extends JIRAWebTest {
    private static final String NEW_FEATURE_I18N_KEY = "jira.translation.issuetype.newfeature.name";
    private static final String BUG_I18N_KEY = "jira.translation.issuetype.bug.name";
    private static final String GERMAN_LOCALE = "de_DE";
    private static final String IMPROVEMENT_I18N_KEY = "jira.translation.issuetype.improvement.name";
    private static final String TASK_I18N_KEY = "jira.translation.issuetype.task.name";

    public TestBasic(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    @Override
    public void tearDown() {
        this.navigation.userProfile().changeUserLanguageToJiraDefault();
        super.tearDown();
    }

    public void testI18NDates() throws IOException {
        this.setLocaleTo("Deutsch (Deutschland)");
        this.createIssueInGermanWithDueDate("25/Dez/05");
        this.assertTextPresent("Es liegen noch keine Kommentare zu diesem Vorgang vor.");
        this.createIssueInGermanWithDueDate("25/Dec/05");
        this.assertTextPresent("Datum eingegeben. Geben Sie das Datum im Format");
    }

    public void testIssueConstantTranslations() {
        this.setLocaleTo("Deutsch (Deutschland)");
        this.updateBugTranslationWith("", "");
        this.browseToCustomFieldAdd();
        this.assertTextPresent("Alle Vorgangstypen");
        this.assertTextPresent("Bug");
        this.assertTextPresent(this.getBackdoor().i18n().getText(IMPROVEMENT_I18N_KEY, GERMAN_LOCALE));
        this.assertTextPresent(this.getBackdoor().i18n().getText(NEW_FEATURE_I18N_KEY, GERMAN_LOCALE));
        this.assertTextPresent(this.getBackdoor().i18n().getText(TASK_I18N_KEY, GERMAN_LOCALE));
        this.updateBugTranslationWith("bugenzee", "bugenzee desc");
        this.browseToCustomFieldAdd();
        this.text.assertTextPresent(this.locator.css(".jiraform"), "bugenzee");
        this.text.assertTextNotPresent(this.locator.css(".jiraform"), "Fehler");
    }

    private void updateBugTranslationWith(String name, String desc) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.clickLink("translate_link");
        this.setWorkingForm("update");
        this.setFormElement("jira.translation.Vorgangstyp.1.name", name);
        this.setFormElement("jira.translation.Vorgangstyp.1.desc", desc);
        this.submit();
    }

    private void browseToCustomFieldAdd() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:textarea");
        this.submit("nextBtn");
    }

    private void createIssueInGermanWithDueDate(String dueDate) {
        this.navigation.issue().goToCreateIssueForm("homosapien", this.getBackdoor().i18n().getText(BUG_I18N_KEY, GERMAN_LOCALE));
        this.setWorkingForm("issue-create");
        this.setFormElement("duedate", dueDate);
        this.setFormElement("summary", "test issue");
        this.assertFormElementHasValue("issue-create", "issue-create-submit", "Erstellen");
        this.submit("Create");
    }

    private void setLocaleTo(String localeName) {
        this.navigation.userProfile().changeUserLanguage(localeName);
    }
}

