/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestAnnouncementBanner
extends JIRAWebTest {
    private static final String ANNOUNCEMENT = "<p>JIRA 3.4 IS NOW INSTALLED <a href=\"http://confluence.atlassian.com/display/JIRA/JIRA+3.4+and+3.4.1+Release%20Notes\" target=\"_blank\">Review Release Notes Here</a></p>";

    public TestAnnouncementBanner(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnouncementBanner() {
        try {
            this.setBannerText(ANNOUNCEMENT);
        }
        finally {
            this.clearBannerText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnouncementBannerDoesNotShowInPrivateModeWithNoUser() {
        try {
            this.setBannerText(ANNOUNCEMENT);
            this.setBannerDisplayMode(false);
            this.logout();
            this.beginAt("/secure/Dashboard.jspa");
            this.assertTextNotPresent(ANNOUNCEMENT);
        }
        finally {
            this.login("admin", "admin");
            this.clearBannerText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnouncementBannerShownInPublicModeWithNoUser() {
        try {
            this.setBannerText(ANNOUNCEMENT);
            this.setBannerDisplayMode(true);
            this.logout();
            this.beginAt("/secure/Dashboard.jspa");
            this.assertTextPresent(ANNOUNCEMENT);
        }
        finally {
            this.login("admin", "admin");
            this.clearBannerText();
        }
    }

    private void setJIRAModePublic(boolean publicMode) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.selectOption("mode", publicMode ? "Public" : "Private");
        this.submit();
    }

    protected void setBannerDisplayMode(boolean isPublic) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EDIT_ANNOUNCEMENT);
        this.setWorkingForm("announcementbanner-edit");
        if (isPublic) {
            this.checkCheckbox("bannerVisibility", "public");
        } else {
            this.checkCheckbox("bannerVisibility", "private");
        }
        this.submit();
    }

    protected void clearBannerText() {
        this.gotoBannerPage();
        this.tester.setWorkingForm("announcementbanner-edit");
        this.tester.setFormElement("announcement", "");
        this.tester.submit();
    }

    protected void setBannerText(String bannerText) {
        this.gotoBannerPage();
        this.tester.setWorkingForm("announcementbanner-edit");
        this.tester.setFormElement("announcement", bannerText);
        this.tester.submit();
        CssLocator css = this.locator.css(".alertHeader");
        TestAnnouncementBanner.assertTrue((boolean)css.getHTML().contains(bannerText));
    }

    protected void gotoBannerPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EDIT_ANNOUNCEMENT);
    }
}

