/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS})
public class TestAddPermission
extends FuncTestCase {
    private static final String PROJECT_PERMISSION_KEY = "func.test.project.permission";
    private static final String PROJECT_PERMISSION_KEY_COMPLETE = "com.atlassian.jira.dev.func-test-plugin:func.test.project.permission";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testValidationOnPermission() {
        this.administration.permissionSchemes().defaultScheme();
        this.tester.clickLinkWithText("Grant permission");
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
        this.text.assertTextPresent("Errors");
        this.text.assertTextPresent("You must select a permission to add.");
    }

    public void testCannotAddEntryToDisabledPermission() {
        this.backdoor.plugins().enablePluginModule(PROJECT_PERMISSION_KEY_COMPLETE);
        this.administration.permissionSchemes().defaultScheme();
        this.tester.clickLink("add_perm_func.test.project.permission");
        this.tester.checkCheckbox("type", "group");
        this.backdoor.plugins().disablePluginModule(PROJECT_PERMISSION_KEY_COMPLETE);
        this.tester.submit(" Add ");
        this.text.assertTextPresent("Errors");
        this.text.assertTextPresent("Permission with key &#39;func.test.project.permission&#39; doesn&#39;t exist.");
    }
}

