/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import net.sourceforge.jwebunit.TestContext;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class Test500Page
extends FuncTestCase {
    private boolean isBeforeJdk = false;

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("Test500Page.xml");
        this.isBeforeJdk = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isJavaBeforeJdk15();
        this.navigation.gotoDashboard();
    }

    public void test500PageServiceParamVisibility() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("/internal-error");
        this.text.assertTextSequence(this.locator.page(), "ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.text.assertTextSequence(this.locator.page(), "Param1", "paramKey");
        this.text.assertTextSequence(this.locator.page(), "Param2", "paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService", "123");
        this.text.assertTextSequence(this.locator.page(), "popserver:", "fake server");
        this.text.assertTextSequence(this.locator.page(), "handler.params:", "project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.text.assertTextSequence(this.locator.page(), "forwardEmail:", "fake@example.com");
        this.text.assertTextSequence(this.locator.page(), "handler:", "Create a new issue or add a comment to an existing issue");
        this.navigation.logout();
        this.setDevMode("false");
        this.tester.gotoPage("/internal-error");
        this.text.assertTextNotPresent(this.locator.page(), "ParamListeners");
        this.text.assertTextNotPresent(this.locator.page(), "Param1:");
        this.text.assertTextNotPresent(this.locator.page(), "paramKey");
        this.text.assertTextNotPresent(this.locator.page(), "Param2:");
        this.text.assertTextNotPresent(this.locator.page(), "paramValue");
        this.assertServiceHeaderNotPresent("Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService");
        this.assertServiceParamsNotVisible();
        this.navigation.login("bob", "bob");
        this.tester.gotoPage("/internal-error");
        this.text.assertTextNotPresent(this.locator.page(), "ParamListeners");
        this.text.assertTextNotPresent(this.locator.page(), "Param1:");
        this.text.assertTextNotPresent(this.locator.page(), "paramKey");
        this.text.assertTextNotPresent(this.locator.page(), "Param2:");
        this.text.assertTextNotPresent(this.locator.page(), "paramValue");
        this.assertServiceHeaderNotPresent("Pop Service", "com.atlassian.jira.service.services.mail.MailFetcherService");
        this.assertServiceParamsNotVisible();
        this.setDevMode("true");
    }

    private void setDevMode(String value) {
        this.backdoor.systemProperties().setProperty("jira.dev.mode", value);
        this.backdoor.systemProperties().setProperty("atlassian.dev.mode", value);
    }

    public void test500PageIsShownToRegularUserInDevMode() {
        this.setDevMode("true");
        this.navigation.login("bob", "bob");
        this.tester.gotoPage("/internal-error");
        this.text.assertTextPresent(this.locator.page(), "Server ID");
        this.text.assertTextPresent(this.locator.page(), "File Paths");
        this.text.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        this.text.assertTextPresent(this.locator.page(), "-Xmx");
    }

    public void test500PageContainsMemoryAndInputArgsInfo() {
        this.tester.gotoPage("/internal-error");
        if (this.isJvmWithPermGen()) {
            this.text.assertTextPresent(this.locator.page(), "Used PermGen Memory");
            this.text.assertTextPresent(this.locator.page(), "Free PermGen Memory");
        }
        this.text.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        if (this.isBeforeJdk) {
            this.text.assertTextPresent(this.locator.page(), "Unable to determine, this requires running JDK 1.5 and higher.");
        } else {
            this.text.assertTextNotPresent(this.locator.page(), "Unable to determine, this requires running JDK 1.5 and higher.");
        }
    }

    public void testExternalUserManagement() {
        this.tester.gotoPage("/internal-error");
        this.text.assertTextPresent(this.locator.page(), "External user management");
    }

    public void testHtmlEscapingOfErrors() throws Exception {
        String badHtml = "<body onload=alert('XSSATTACK')>";
        String badHtmlEscaped = "%3Cbody%20onload=alert('XSSATTACK')%3E";
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + "/secure/Dashboard!default" + badHtmlEscaped + ".jspa");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        webClient.setExceptionsThrownOnErrorStatus(false);
        WebResponse response = webClient.sendRequest((WebRequest)request);
        String responseText = response.getText();
        Test500Page.assertFalse((String)"Found bad HTML in the response", (responseText.indexOf(badHtml) >= 0 ? 1 : 0) != 0);
    }

    public void testAdministratorDoesntSeeContactYourAdmin() {
        this.tester.gotoPage("/internal-error");
        this.text.assertTextPresent(this.locator.page(), "Raise an issue for the Support team");
        this.text.assertTextNotPresent(this.locator.page(), "JIRA Administrator contact form");
    }

    public void testNonAdministratorSeesContactYourAdmin() {
        this.navigation.login("bob", "bob");
        this.tester.gotoPage("/internal-error");
        this.text.assertTextPresent(this.locator.page(), "to your JIRA Administrator");
        this.text.assertTextNotPresent(this.locator.page(), "Raise an issue for the Support team");
    }

    public void testSystemAdministratorCanSeeSysAdminOnlyProperties() {
        this.tester.gotoPage("/internal-error");
        this.text.assertTextNotPresent(this.locator.page(), "Contact your System Administrator to discover file path information.");
        this.text.assertTextNotPresent(this.locator.page(), "Contact your System Administrator to discover this property value.");
        this.text.assertTextSequence(this.locator.page(), "Server ID", "ABN9-RZYJ-WI2T-37UF");
        this.text.assertTextSequence(this.locator.page(), "server logs", "Support ZIP", " technical details");
        this.text.assertTextSequence(this.locator.page(), "File Paths", "atlassian-jira.log", "entityengine.xml");
        this.text.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        if (!this.isBeforeJdk) {
            this.text.assertTextPresent(this.locator.page(), "-D");
        }
        this.text.assertTextPresent(this.locator.page(), "Current Working Directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonSystemAdministratorDoesntSeeFilePaths() {
        this.setDevMode("false");
        try {
            this.navigation.login("bob", "bob");
            this.tester.gotoPage("/internal-error");
            this.text.assertTextNotPresent(this.locator.page(), "attach the application server log file");
            this.text.assertTextNotPresent(this.locator.page(), "atlassian-jira.log");
            this.text.assertTextNotPresent(this.locator.page(), "Server ID");
            this.text.assertTextNotPresent(this.locator.page(), "File Paths");
            this.text.assertTextNotPresent(this.locator.page(), "Current Working Directory");
            this.text.assertTextNotPresent(this.locator.page(), "JVM Input Arguments");
            this.text.assertTextNotPresent(this.locator.page(), "-Xmx");
            this.navigation.login("admin_non_sysadmin", "admin_non_sysadmin");
            this.tester.gotoPage("/internal-error");
            this.text.assertTextNotPresent("File Paths");
            this.text.assertTextSequence(this.locator.page(), "Server ID", "ABN9-RZYJ-WI2T-37UF", "Current Working Directory", "Contact your System Administrator to discover this property value.", "JVM Input Arguments", "Contact your System Administrator to discover this property value.");
            this.text.assertTextNotPresent(this.locator.page(), "-Xmx");
        }
        finally {
            this.setDevMode("true");
        }
    }

    private void assertServiceHeaderPresent(String serviceName, String serviceClass, String delay) {
        this.text.assertTextSequence(this.locator.page(), "Services", serviceName, serviceClass, "0 0 0/2 * * ?");
    }

    private void assertServiceHeaderNotPresent(String serviceName, String serviceClass) {
        this.text.assertTextNotPresent(serviceName);
        this.text.assertTextNotPresent(serviceClass);
    }

    private void assertServiceParamsNotVisible() {
        this.text.assertTextNotPresent(this.locator.page(), "usessl:");
        this.text.assertTextNotPresent(this.locator.page(), "No SSL");
        this.text.assertTextNotPresent(this.locator.page(), "popserver:");
        this.text.assertTextNotPresent(this.locator.page(), "fake server");
        this.text.assertTextNotPresent(this.locator.page(), "handler.params:");
        this.text.assertTextNotPresent(this.locator.page(), "project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.text.assertTextNotPresent(this.locator.page(), "forwardEmail:");
        this.text.assertTextNotPresent(this.locator.page(), "fake@example.com");
        this.text.assertTextNotPresent(this.locator.page(), "handler:");
        this.text.assertTextNotPresent(this.locator.page(), "Create a new issue or add a comment to an existing issue");
    }

    private boolean isJvmWithPermGen() {
        return new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isJvmWithPermGen();
    }
}

