/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
public class TestUserLimitedLicense
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testCreateIssueOverLicenseLimit_Starter() {
        this._testCreateIssueOverLicenseLimit(LicenseKeys.V2_STARTER);
    }

    public void testCreateIssueOverLicenseLimit_CommercialLimited() {
        this._testCreateIssueOverLicenseLimit(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testCreateIssueOverLicenseLimit(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "A little bug");
        this.tester.submit("Create");
        this.tester.assertTextPresent("A little bug");
        this.tester.assertTextPresent("Details");
        this.backdoor.usersAndGroups().addUser("bob");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "This is a big one!");
        this.tester.submit("Create");
        this.tester.assertTextPresent("This is a big one!");
        this.tester.assertTextPresent("Details");
        this.administration.restoreData("TestStarterLicenseTooManyUsers.xml");
        this.administration.switchToLicense(license);
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        this.tester.assertTextPresent("You will not be able to create new issues because the user limit for your JIRA instance has been exceeded, please contact your JIRA administrators.");
        String atlToken = this.page.getXsrfToken();
        this.tester.gotoPage("/secure/CreateIssueDetails.jspa?atl_token=" + atlToken);
        this.tester.assertTextPresent("You have not selected a valid project to create an issue in.");
        this.tester.assertElementNotPresent("details-module");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("editgroups_michael");
        this.tester.selectOption("groupsToLeave", "jira-users");
        this.tester.submit("leave");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Let's create another bug!");
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Let's create another bug!");
        this.tester.assertTextPresent("Details");
    }

    public void testAddUserOverLimitShowsWarning_Starter() {
        this._testAddUserOverLimitShowsWarning(LicenseKeys.V2_STARTER);
    }

    public void testAddUserOverLimitShowsWarning_CommercialLimited() {
        this._testAddUserOverLimitShowsWarning(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testAddUserOverLimitShowsWarning(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.addUsersWhileUnderTheLimit("devman");
        this.addUsersWhileUnderTheLimit("prodman");
        this.addUsersWhileUnderTheLimit("fatman");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("create_user");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Creating a new user will exceed the number of users allowed to use JIRA under your license.");
        this.tester.setFormElement("username", "barney");
        this.tester.setFormElement("password", "barney");
        this.tester.setFormElement("confirm", "barney");
        this.tester.setFormElement("fullname", "Barney");
        this.tester.setFormElement("email", "barney@example.com");
        this.tester.submit("Create");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "jira-users");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.loginAttempt("barney", "barney");
        this.tester.assertTextPresent("You do not have a permission to log in");
    }

    private void addUsersWhileUnderTheLimit(String userName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("create_user");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Creating a new user will exceed the number of users allowed to use JIRA under your license.");
        this.tester.setFormElement("username", userName);
        this.tester.setFormElement("password", userName);
        this.tester.setFormElement("confirm", userName);
        this.tester.setFormElement("fullname", userName);
        this.tester.setFormElement("email", userName + "@example.com");
        this.tester.submit("Create");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Groups:", "jira-users"});
    }

    public void testDeleteUserClearsActiveUserCount_Starter() {
        this._testDeleteUserClearsActiveUserCount(LicenseKeys.V2_STARTER);
    }

    public void testDeleteUserClearsActiveUserCount_CommercialLimited() {
        this._testDeleteUserClearsActiveUserCount(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testDeleteUserClearsActiveUserCount(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.navigation.gotoAdminSection(Navigation.AdminSection.LICENSE_DETAILS);
        this.tester.assertTextPresent("2 currently active");
        this.administration.usersAndGroups().deleteUser("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.LICENSE_DETAILS);
        this.tester.assertTextPresent("1 currently active");
    }

    public void testModifyGlobalPermissionsShowsWarning_Starter() {
        this._testModifyGlobalPermissionsShowsWarning(LicenseKeys.V2_STARTER);
    }

    public void testModifyGlobalPermissionsShowsWarning_CommercialLimited() {
        this._testModifyGlobalPermissionsShowsWarning(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testModifyGlobalPermissionsShowsWarning(LicenseKeys.License license) {
        this.administration.restoreData("TestStarterLicenseGlobalPermissions.xml");
        this.administration.switchToLicense(license);
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        this.tester.assertTextPresent("Global Permissions");
        this.tester.assertTextPresent("These permissions apply to all projects. They are independent of project specific permissions.");
        this.tester.assertTextNotPresent("You have exceeded the number of users allowed to use JIRA under");
        this.administration.addGlobalPermission(1, "jira-developers");
        this.tester.assertTextPresent("You have exceeded the number of users allowed to use JIRA under");
        this.administration.removeGlobalPermission(1, "jira-developers");
        this.tester.assertTextNotPresent("You have exceeded the number of users allowed to use JIRA under");
    }

    private void addMailServerConfig() {
        this.administration.mailServers().Smtp().goTo();
        this.tester.clickLinkWithText("Configure new SMTP mail server");
        this.tester.setFormElement("name", "mail");
        this.tester.setFormElement("description", "");
        this.tester.setFormElement("from", "mail_jira@example.com");
        this.tester.setFormElement("prefix", "JIRA:");
        this.tester.setFormElement("serverName", "localhost");
        this.tester.submit("Add");
    }

    public void testSignupOverLicenseLimit_Starter() {
        this._testSignupOverLicenseLimit(LicenseKeys.V2_STARTER);
    }

    public void testSignupOverLicenseLimit_CommercialLimited() {
        this._testSignupOverLicenseLimit(LicenseKeys.V2_COMMERCIAL_LIMITED);
    }

    private void _testSignupOverLicenseLimit(LicenseKeys.License license) {
        this.administration.switchToLicense(license);
        this.addUsersWhileUnderTheLimit("dudeman");
        this.addUsersWhileUnderTheLimit("prodman");
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.setFormElement("username", "devman");
        this.tester.setFormElement("password", "devman");
        this.tester.setFormElement("confirm", "devman");
        this.tester.setFormElement("fullname", "Devman");
        this.tester.setFormElement("email", "devman@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("You have successfully signed up. If you forget your password, you can have it emailed to you.");
        this.tester.clickLinkWithText("Click here to log in");
        this.navigation.login("devman", "devman");
        TestUserLimitedLicense.assertEquals((String)"Devman", (String)this.navigation.userProfile().userName());
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.assertTextPresent("You cannot sign up at this time, as the user limit for JIRA has been exceeded.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "For further assistance, please contact your JIRA administrators.");
        this.tester.gotoPage("/secure/Signup.jspa");
        this.tester.assertTextPresent("You cannot sign up at this time, as the user limit for JIRA has been exceeded.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "For further assistance, please contact your JIRA administrators.");
    }
}

