/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.xmlbackup.XmlBackupCopier;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.regex.Pattern;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
public class TestLicenseMessages
extends FuncTestCase {
    private static final String URL_WWW_ATLASSIAN_COM_ORDER = "http://www.atlassian.com/order";
    private static final String URL_WWW_ATLASSIAN_COM_EXPIRED_EVAL = "http://www.atlassian.com/software/jira/expiredevaluation.jsp";
    private static final String[] NOT_EXPIRED_MESSAGES = new String[]{"JIRA support and updates for this license ended on ", "You are currently running a version of JIRA that was created after that date.", "Your evaluation period will expire in ", "If you wish to have access to support and updates, please "};
    private static final String[] EXPIRED_MESSAGES = new String[]{"JIRA support and updates for this license ended on ", "You are currently running a version of JIRA that was created after that date.", "Your evaluation period has expired.", "If you wish to have access to support and updates, please "};
    private static final Pattern dateToken = Pattern.compile("TIMESTAMPTOCHANGE");
    private static final DataLicenseInfo licenseInfo = new DataLicenseInfo("TestLicenseMessagesNewBuildOldLicenseFull.xml", EXPIRED_MESSAGES, NOT_EXPIRED_MESSAGES, new LicenseInfoUrl[]{new LicenseInfoUrl("renew your maintenance", "http://www.atlassian.com/order")});
    private File importDirectory;
    private final String timestampNow;
    private final String timestampExpired;

    public TestLicenseMessages() {
        long now = System.currentTimeMillis();
        this.timestampNow = Long.toString(now);
        this.timestampExpired = Long.toString(now - 31L * DateUtils.DAY_MILLIS);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.importDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
    }

    public void testSwitchableLicenses() throws Exception {
        ImmutableList switchableLicenses = ImmutableList.of((Object)new LicenseInfo(LicenseKeys.V2_EVAL_EXPIRED, new String[]{"(Your evaluation has expired.)", "Your JIRA evaluation period expired on ", "You are not able to create new issues in JIRA.", "To reactivate JIRA, please "}, new String[0], new LicenseInfoUrl[]{new LicenseInfoUrl("purchase JIRA", URL_WWW_ATLASSIAN_COM_EXPIRED_EVAL)}), (Object)new LicenseInfo(LicenseKeys.V2_COMMERCIAL, new String[]{"(Support and updates available until "}, new String[0], new LicenseInfoUrl[0]), (Object)TestLicenseMessages.createSupportedLicense(LicenseKeys.V2_COMMUNITY), (Object)TestLicenseMessages.createSupportedLicense(LicenseKeys.V2_DEVELOPER), (Object)TestLicenseMessages.createUnsupportedLicense(LicenseKeys.V2_PERSONAL), (Object)TestLicenseMessages.createSupportedLicense(LicenseKeys.V2_OPEN_SOURCE), (Object)TestLicenseMessages.createUnsupportedLicense(LicenseKeys.V2_DEMO));
        for (LicenseInfo licenseInfo : switchableLicenses) {
            this.log("Testing license for " + licenseInfo.description);
            this.administration.switchToLicense(licenseInfo.license, licenseInfo.description);
            this.assertLicense(licenseInfo);
            if (!licenseInfo.license.equals(LicenseKeys.V2_EVAL_EXPIRED.getLicenseString())) continue;
            this.tester.gotoPage("secure/CreateIssue!default.jspa");
            this.assertCantCreateIssues();
            this.tester.gotoPage("secure/CreateIssue.jspa?pid=10000&issuetype=1");
            this.assertCantCreateIssues();
        }
    }

    private void assertCantCreateIssues() {
        CssLocator locator = new CssLocator(this.tester, ".aui-message.error");
        this.text.assertTextPresent(locator, "You will not be able to create new issues because your JIRA evaluation period has expired, please contact your JIRA administrators.");
    }

    public void testNewBuildOldLicensesCommercialFullExpired() throws Exception {
        this.testNewBuildOldLicense(licenseInfo, true);
    }

    public void testNewBuildOldLicensesCommercialFullNotExpired() throws Exception {
        this.testNewBuildOldLicense(licenseInfo, false);
    }

    private void testNewBuildOldLicense(DataLicenseInfo info, boolean expired) throws Exception {
        this.modifyTimestampAndRestore(this.importDirectory, info.dataFile, expired ? this.timestampExpired : this.timestampNow);
        this.navigation.gotoAdminSection(Navigation.AdminSection.LICENSE_DETAILS);
        this.assertDataLicense(expired ? info.expiredMessages : info.notExpiredMessages, info.urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyTimestampAndRestore(File importDirectory, String fileName, String timestamp) throws Exception {
        File generatedDataFile = null;
        try {
            this.log("Modifying timestamp for backup data at " + fileName);
            File templateDataFile = new File(this.getEnvironmentData().getXMLDataLocation(), fileName);
            generatedDataFile = File.createTempFile("generated", ".xml", importDirectory);
            XmlBackupCopier xmlBackupCopier = new XmlBackupCopier(this.getEnvironmentData().getBaseUrl());
            xmlBackupCopier.copyXmlBackupTo(templateDataFile.getAbsolutePath(), generatedDataFile.getAbsolutePath(), MapBuilder.build(dateToken, timestamp));
            this.log("Restoring data '" + generatedDataFile.getAbsolutePath() + "'");
            this.navigation.disableWebSudo();
            this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
            this.tester.setWorkingForm("restore-xml-data-backup");
            this.tester.setFormElement("filename", generatedDataFile.getName());
            this.tester.submit();
            this.log("Waiting for restore...");
            this.administration.waitForRestore();
            this.tester.assertTextPresent("Your import has been successful");
            this.navigation.disableWebSudo();
            this.navigation.login("admin", "admin");
            this.administration.generalConfiguration().setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
        }
        finally {
            if (generatedDataFile != null && generatedDataFile.exists() && !generatedDataFile.delete()) {
                TestLicenseMessages.fail((String)("Failed to delete generated xml file: " + generatedDataFile.getAbsolutePath()));
            }
        }
    }

    private void assertLicense(LicenseInfo licenseInfo) {
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator, licenseInfo.messages);
        for (String notMessage : licenseInfo.notMessages) {
            this.text.assertTextNotPresent(pageLocator, notMessage);
        }
        for (LicenseInfoUrl licenseInfoUrl : licenseInfo.urls) {
            this.assertions.getLinkAssertions().assertLinkLocationEndsWith(licenseInfoUrl.text, licenseInfoUrl.url);
        }
    }

    private void assertDataLicense(String[] messages, LicenseInfoUrl[] urls) {
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator, messages);
        for (LicenseInfoUrl licenseInfoUrl : urls) {
            this.assertions.getLinkAssertions().assertLinkLocationEndsWith(licenseInfoUrl.text, licenseInfoUrl.url);
        }
    }

    private static LicenseInfo createSupportedLicense(LicenseKeys.License forLicense) {
        return new LicenseInfo(forLicense, new String[]{"(Support and updates available until "}, new String[]{"JIRA support and updates for this license ended on ", "JIRA support and updates created after ", "are not valid for this license."}, new LicenseInfoUrl[0]);
    }

    private static LicenseInfo createUnsupportedLicense(LicenseKeys.License forLicense) {
        return new LicenseInfo(forLicense, new String[]{"(Updates available until "}, new String[0], new LicenseInfoUrl[0]);
    }

    private static class LicenseInfoUrl {
        String text;
        String url;

        private LicenseInfoUrl(String text, String url) {
            this.text = text;
            this.url = url;
        }
    }

    private static class DataLicenseInfo {
        final String dataFile;
        final String[] expiredMessages;
        final String[] notExpiredMessages;
        final LicenseInfoUrl[] urls;

        private DataLicenseInfo(String dataFile, String[] expiredMessages, String[] notExpiredMessages, LicenseInfoUrl[] urls) {
            this.dataFile = dataFile;
            this.expiredMessages = expiredMessages;
            this.notExpiredMessages = notExpiredMessages;
            this.urls = urls;
        }
    }

    private static class LicenseInfo {
        final String license;
        final String description;
        final String[] messages;
        final String[] notMessages;
        final LicenseInfoUrl[] urls;

        private LicenseInfo(LicenseKeys.License forLicense, String[] messages, String[] notMessages, LicenseInfoUrl[] urls) {
            this.license = forLicense.getLicenseString();
            this.description = forLicense.getDescription();
            this.messages = messages;
            this.notMessages = notMessages;
            this.urls = urls;
        }
    }
}

