/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.LicenseKeys;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
public class TestLicenseFooters
extends JIRAWebTest {
    public TestLicenseFooters(String name) {
        super(name);
    }

    public void testEnterpriseCommunityLicense() {
        this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_COMMUNITY);
        this.assertTextPresentBeforeText("Powered by a free Atlassian", "community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseCommunityLicenseLoggedOut() {
        try {
            this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_COMMUNITY);
            this.logout();
            this.assertTextPresentBeforeText("Powered by a free Atlassian", "community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseDeveloperLicense() {
        this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_DEVELOPER);
        this.assertTextPresentBeforeText("This", "site is for non-production use only.");
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseDeveloperLicenseLoggedOut() {
        try {
            this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_DEVELOPER);
            this.logout();
            this.assertTextPresentBeforeText("This", "site is for non-production use only.");
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterprisePersonalLicense() {
        this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_PERSONAL);
        this.assertTextSequence(new String[]{"A", "free bug tracker", "for up to three users? Try", "JIRA Personal", "Edition."});
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        this.assertTextNotPresent("site is for non-production use only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterprisePersonalLicenseLoggedOut() {
        try {
            this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_PERSONAL);
            this.logout();
            this.assertTextSequence(new String[]{"A", "free bug tracker", "for up to three users? Try", "JIRA Personal", "Edition."});
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
            this.assertTextNotPresent("site is for non-production use only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseOpenSourceLicense() {
        this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_OPEN_SOURCE);
        this.assertTextPresentBeforeText("Powered by a free Atlassian", "open source license for Atlassian.");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseOpenSourceLicenseLoggedOut() {
        try {
            this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_OPEN_SOURCE);
            this.logout();
            this.assertTextPresentBeforeText("Powered by a free Atlassian", "open source license for Atlassian.");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseDemonstrationLicense() {
        this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_DEMO);
        this.assertTextPresentBeforeText("This JIRA site is for demonstration purposes only.", "bug tracking software for your team.");
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("open source license for Atlassian.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseDemonstrationLicenseLoggedOut() {
        try {
            this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_DEMO);
            this.logout();
            this.assertTextPresentBeforeText("This JIRA site is for demonstration purposes only.", "bug tracking software for your team.");
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseLicense() {
        this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_COMMERCIAL);
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("Powered by a free Atlassian");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseLicenseLoggedOut() {
        try {
            this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_COMMERCIAL);
            this.logout();
            this.assertTextNotPresent("Powered by a free Atlassian");
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        }
        finally {
            this.login("admin", "admin");
        }
    }

    public void testEnterpriseEvaluationLicense() {
        this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_EVAL_EXPIRED);
        this.navigation.gotoAdminSection(Navigation.AdminSection.LICENSE_DETAILS);
        this.assertTextPresent("(Your evaluation has expired.)");
        this.navigation.gotoPage("secure/BrowseProjects.jspa");
        this.assertTextSequence(new String[]{"Powered by a free Atlassian", "JIRA evaluation license", "Please consider", "purchasing it", "today"});
        this.assertTextNotPresent("community license for Atlassian.");
        this.assertTextNotPresent("site is for non-production use only.");
        this.assertTextNotPresent("open source license for Atlassian.");
        this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
        this.assertTextNotPresent("for up to three users? Try");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnterpriseEvaluationLicenseLoggedOut() {
        try {
            this.getAdministration().restoreBlankInstanceWithLicense(LicenseKeys.V2_EVAL_EXPIRED);
            this.logout();
            this.assertTextSequence(new String[]{"Powered by a free Atlassian", "JIRA evaluation license", "Please consider", "purchasing it", "today"});
            this.assertTextNotPresent("community license for Atlassian.");
            this.assertTextNotPresent("site is for non-production use only.");
            this.assertTextNotPresent("open source license for Atlassian.");
            this.assertTextNotPresent("This JIRA site is for demonstration purposes only.");
            this.assertTextNotPresent("for up to three users? Try");
        }
        finally {
            this.login("admin", "admin");
        }
    }
}

