/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.subtasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
public class TestMoveSubtask
extends FuncTestCase {
    public void testMoveSubtask() throws Exception {
        this.administration.restoreData("TestMoveSubtask.xml");
        this.navigation.issue().viewIssue("RAT-14");
        this.tester.clickLink("edit-issue");
        this.tester.clickLinkWithText("moving");
        this.tester.assertTextNotPresent("Sub-tasks cannot be moved independently of the parent issue.");
        this.tester.assertTextPresent("Move Sub-Task: Choose Operation");
        this.tester.assertTextPresent("Change issue type for this subtask");
    }

    public void testMoveSubtaskWithComponents() throws Exception {
        this.administration.restoreData("TestMoveSubtaskWithComponent.xml");
        this.navigation.issue().viewIssue("SRC-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("TARGET", "10010_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.selectOption("components_10010", "TGT2");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Below is a summary of all issues that will be moved");
        this.assertions.getTextAssertions().assertTextSequence(new TableLocator(this.tester, "10010_1_components"), new String[]{"SRC1 [Project: SOURCE] TGT2"});
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Source Subtask for Issue 1");
        this.assertions.getTextAssertions().assertTextPresent(new IdLocator(this.tester, "components-val"), "None");
    }

    public void testMoveSubtasksAcrossProjectsWithDifferentRenderers() {
        this.administration.restoreData("TestMoveSubtaskAcrossProjectsWithDifferentRenderers.xml");
        this.navigation.issue().viewIssue("DTRP-2");
        this.assertions.getTextAssertions().assertTextPresent(new IdLocator(this.tester, "descriptionmodule"), "Subtask description.");
        this.navigation.issue().viewIssue("DTRP-1");
        this.assertions.getTextAssertions().assertTextPresent(new IdLocator(this.tester, "descriptionmodule"), "Task description.");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Wiki Text Renderer Project", "10030_3_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.checkCheckbox("retain_description");
        this.tester.assertTextPresent("Update fields for issues with current issue type(s)");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Below is a summary of all issues that will be moved");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue("WTRP-1");
        this.assertions.getTextAssertions().assertTextPresent("Subtask with default renderer");
        this.navigation.issue().viewIssue("WTRP-2");
        this.assertions.getTextAssertions().assertTextPresent(new IdLocator(this.tester, "descriptionmodule"), "Subtask description.");
    }
}

