/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.ISSUES})
public class TestXsrfSpecificLinks
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestXsrfSpecificLinks.xml");
    }

    public void testLinksThatShouldNOTHaveAtlTokens() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertAnchorsDoNotHaveToken("//dl[contains(@class, 'links-list')]//dd//span//a/@href");
        this.assertAnchorsDoNotHaveToken("//ul[@id='issue-tabs']//a/@href");
        this.navigation.browseProject("HSP");
        this.assertAnchorsDoNotHaveToken("//section[@id='content']//ul/li/a/@href");
        this.navigation.issueNavigator().createSearch("project=HSP");
        this.navigation.issueNavigator().createSearch("project=HSP and summary ~ fred");
        this.navigation.issueNavigator().createSearch("project=HSP and summary ~ bill");
    }

    private void assertAnchorsDoNotHaveToken(String xPath) {
        String allHrefs = new XPathLocator(this.tester, xPath).getText();
        TestXsrfSpecificLinks.assertTrue((boolean)StringUtils.isNotBlank((String)allHrefs));
        this.text.assertTextNotPresent(allHrefs, "atl_token");
    }
}

