/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.DoesNotContainIssueKeyCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SECURITY, Category.ISSUES})
public class TestIssueSecurityLevelOnlyCheckedForBrowseProjectPermission
extends FuncTestCase {
    private static final String USERNAME = "test";
    private static final String ISSUE_KEY = "TEST-1";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestIssueSecurityLevelOnlyCheckedForBrowseProjectPermission.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", USERNAME);
    }

    public void testUserCanBeAssignedToIssueEventThoughSheDoesNotBelongToTheGroupsOfTheIssuesSecurityLevel() {
        this.assertUserCanNotSeeIssueSinceSheIsNotAdminNorAssignee(USERNAME, ISSUE_KEY);
        this.assignIssueToUser(ISSUE_KEY, USERNAME);
        this.assertUserCanSeeIssueSinceSheIsTheAssignee(USERNAME, ISSUE_KEY);
    }

    private void assignIssueToUser(String issueKey, String username) {
        this.navigation.login("admin");
        this.navigation.issue().assignIssue(issueKey, "", username);
    }

    private void assertUserCanNotSeeIssueSinceSheIsNotAdminNorAssignee(String username, String issueKey) {
        this.navigation.login(username);
        this.navigation.issueNavigator().createSearch("");
        ArrayList<SearchResultsCondition> condition = new ArrayList<SearchResultsCondition>();
        condition.add(new DoesNotContainIssueKeyCondition(this.text, issueKey));
        condition.add(new NumberOfIssuesCondition(this.text, 0));
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(condition);
    }

    private void assertUserCanSeeIssueSinceSheIsTheAssignee(String username, String issueKey) {
        this.navigation.login(username);
        this.navigation.issueNavigator().createSearch("");
        ArrayList<SearchResultsCondition> condition = new ArrayList<SearchResultsCondition>();
        condition.add(new ContainsIssueKeysCondition(this.text, issueKey));
        condition.add(new NumberOfIssuesCondition(this.text, 1));
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(condition);
    }
}

