/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import net.sourceforge.jwebunit.ExpectedRow;
import net.sourceforge.jwebunit.ExpectedTable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.MOVE_ISSUE, Category.SECURITY, Category.USERS_AND_GROUPS})
public class TestPromptUserForSecurityLevelOnMove
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestPromptUserForSecurityLevelOnMove.xml");
    }

    public void testMoveIssueType_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("RAT-10");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Choose the project and issue type to move to");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertOptionEquals("security", "Level Mouse");
    }

    public void testMoveIssueType_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("RAT-10");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Choose the project and issue type to move to");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextNotPresent("Security Level");
    }

    public void testMoveIssueType_Subtask_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-14");
        this.tester.clickLink("move-issue");
        this.tester.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Update the fields of the sub-task to relate to the new sub-task type.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMoveIssueType_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectIssueType("New Feature", "10022_1_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'New Feature'");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertFormElementPresent("security");
    }

    public void testBulkMoveIssueType_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectIssueType("Improvement", "10022_1_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Improvement'");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextNotPresent("Security Level");
    }

    public void testBulkMoveIssueType_Subtask_RequiresSecurity() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10060", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectIssueType("Secure Sub-task", "10022_5_10022_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Secure Sub-task'");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testMoveProject_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-13");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Canine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Amber");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 2");
    }

    public void testMoveProject_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-13");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Porcine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project");
        Assert.assertThat((Object)this.tester.getDialog().getElement("stepped-process").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Security")));
        this.tester.assertFormElementNotPresent("security");
    }

    public void testMoveProject_Issue_SecurityLevelInvalid() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-12");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Canine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Green");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirm");
    }

    public void testMoveProject_Issue_SecurityLevelNotAvailableToUser() {
    }

    public void testMoveProject_Issue_SecurityLevelAvailableToUser() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-20");
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("security", "Level Mouse");
        this.tester.submit("Update");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Bovine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertFormElementNotPresent("security");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirm");
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"Issue Targets", "Issue Targets"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"Target Project", "Bovine"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"Target Issue Type", "Bug"}));
        this.tester.assertTableEquals("move_confirm_table", expectedTable);
    }

    public void testBulkMoveProject_Issue_RequiresSecurity() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("Canine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.navigation.issue().selectIssueType("Secure Sub-task", "10022_5_10020_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Bug'");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Red");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Secure Sub-task'");
        this.tester.assertTextPresent("Fix Version/s");
        this.tester.assertTextPresent("Affects Version/s");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMoveProject_Issue_DoesntRequireSecurity() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10050", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("Porcine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.navigation.issue().selectIssueType("Secure Sub-task", "10022_5_10021_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Bug'");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertFormElementNotPresent("security");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Porcine' - Issue Type 'Secure Sub-task'");
        this.tester.assertTextPresent("Fix Version/s");
        this.tester.assertTextPresent("Affects Version/s");
        this.tester.assertTextNotPresent("Security Level");
        this.tester.assertFormElementNotPresent("security");
    }

    public void testBulkMoveProject_Issue_SecurityLevelInvalid() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10040", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("Canine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Bug'");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Green");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Sub-task'");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMoveProject_Issue_SecurityLevelNotAvailableToUser() {
    }

    public void testBulkMoveProject_Issue_SecurityLevelAvailableToUser() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-20");
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("security", "Level Mouse");
        this.tester.submit("Update");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10100", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("Bovine", "10022_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.navigation.issue().selectIssueType("Sub-task", "10022_6_10000_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Bovine' - Issue Type 'Bug'");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Bovine' - Issue Type 'Sub-task'");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
    }

    public void testBulkMigrate_SecurityNotRequired() {
        Long projectId = this.backdoor.project().getProjectId("RAT");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugless Scheme");
        this.tester.assertTextPresent("Select Issue Type Scheme for project Rattus");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Issue Type Migration: Overview (Step 1 of 6)");
        this.tester.assertTextPresent("Some issues have issue types that are no longer applicable. You will need to move these issues to another issue type.");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Bug in project Rattus");
        this.navigation.issue().selectIssueType("Task", "issuetype");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Bug in project Rattus.");
        this.tester.assertTextPresent("All field values will be retained.");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Sub-task in project Rattus");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Sub-task in project Rattus.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testBulkMigrate_SecurityRequired() {
        Long projectId = this.backdoor.project().getProjectId("RAT");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugless Scheme");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Issue Type Migration: Overview (Step 1 of 6)");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Bug in project Rattus");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Bug in project Rattus.");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertFormElementPresent("security");
        this.tester.selectOption("security", "Level Mouse");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Select a new issue type for issues with current issue type Sub-task in project Rattus");
        this.tester.submit("nextBtn");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Update fields for issues with current issue type Sub-task in project Rattus.");
        this.tester.assertFormElementNotPresent("security");
        this.tester.assertTextPresent("Security Level");
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
    }

    public void testConvertIssueToSubtask() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-10");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "RAT-13");
        this.tester.assertTextPresent("Convert Issue to Sub-task: RAT-10");
        this.navigation.issue().selectIssueType("Secure Sub-task", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Convert Issue to Sub-task: RAT-10");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Step 3 of 4: Update the fields of the issue to relate to the new issue type ...");
        this.tester.assertTextPresent("All fields will be updated automatically.");
    }

    public void testConvertSubtaskWithoutSecurityToIssueThatRequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-14");
        this.tester.clickLink("subtask-to-issue");
        this.tester.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit("Next >>");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Step 3 of 4: Update the fields of the issue to relate to the new issue type ...");
        this.tester.assertTextPresent("Security Level:");
        this.tester.assertFormElementPresent("security");
    }

    public void testConvertSubtaskWithSecurityToIssueThatRequiresSecurity() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("RAT-14");
        this.tester.clickLink("subtask-to-issue");
        this.tester.assertTextPresent("Convert Sub-task to Issue: RAT-14");
        this.navigation.issue().selectIssueType("Task", "issuetype");
        this.tester.submit("Next >>");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Step 3 of 4: Update the fields of the issue to relate to the new issue type ...");
        this.tester.assertTextNotPresent("Security Level:");
        this.tester.assertFormElementNotPresent("security");
    }
}

