/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.sourceforge.jwebunit.WebTester;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.MOVE_ISSUE})
public class TestMoveIssueAttachment
extends FuncTestCase {
    private String attachmentPath;

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestMoveIssueAttachment.xml");
        this.administration.attachments().enable();
        this.attachmentPath = this.administration.getCurrentAttachmentPath();
    }

    public void testMoveSingleIssueSameWorkflow() throws Exception {
        this.installAttachedFile("AAAAAA");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("AAAAAA");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Bovine");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("AAAAAA");
        File movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("COW-15");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testMoveSingleIssueDifferentWorkflow() throws Exception {
        this.installAttachedFile("testMo");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Step 1 of 4");
        this.navigation.issue().selectProject("Canine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.submit("Move");
        this.tester.assertTextPresent("DOG-1");
        this.navigation.issue().viewIssue("DOG-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testMo");
        File movedFile = new File(this.attachmentPath + "/DOG/DOG-1", "10010");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("DOG-1");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testBulkMoveIssueSameWorkflow() throws Exception {
        this.installAttachedFile("testBu");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("Bovine", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue("COW-15");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testBu");
        File movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("COW-15");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testBulkMoveIssueDifferentWorkflow() throws Exception {
        this.installAttachedFile("testBu");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("Canine", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue("DOG-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testBu");
        File movedFile = new File(this.attachmentPath + "/DOG/DOG-1", "10010");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("DOG-1");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testMoveSingleIssueTwoUsers() throws Exception {
        this.installAttachedFile("WWWWww");
        FuncTestHelperFactory funcTestHelperFactory2 = new FuncTestHelperFactory(this, this.getEnvironmentData());
        WebTester tester2 = funcTestHelperFactory2.getTester();
        Navigation navigation2 = funcTestHelperFactory2.getNavigation();
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        navigation2.issue().viewIssue("RAT-1");
        tester2.clickLink("move-issue");
        this.navigation.issue().selectProject("Bovine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.submit("Next >>");
        navigation2.issue().selectProject("Canine");
        tester2.submit("Next >>");
        tester2.assertTextPresent("Step 3 of 4");
        tester2.submit("Next >>");
        tester2.assertTextPresent("Move Issue: Confirm");
        tester2.submit("Move");
        tester2.assertTextPresent("DOG-1");
        tester2.clickLinkWithText("info.txt");
        tester2.assertTextPresent("WWWWww");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.submit("Move");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.assertTextPresent("Cannot move Issue RAT-1 because it has already been moved to DOG-1.");
        File movedFile = new File(this.attachmentPath + "/DOG/DOG-1", "10010");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("DOG-1");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testBulkMoveIssueTwoUsers() throws Exception {
        this.installAttachedFile("JJJJJJ");
        FuncTestHelperFactory funcTestHelperFactory2 = new FuncTestHelperFactory(this, this.getEnvironmentData());
        WebTester tester2 = funcTestHelperFactory2.getTester();
        Navigation navigation2 = funcTestHelperFactory2.getNavigation();
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("Canine", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Bug'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        navigation2.issueNavigator().bulkEditAllIssues();
        tester2.assertTextPresent("Step 1 of 4: Choose Issues");
        tester2.checkCheckbox("bulkedit_10000", "on");
        tester2.submit("Next");
        tester2.assertTextPresent("Step 2 of 4: Choose Operation");
        tester2.checkCheckbox("operation", "bulk.move.operation.name");
        tester2.submit("Next");
        tester2.assertTextPresent("Select Projects and Issue Types");
        navigation2.issue().selectProject("Bovine", "10000_1_pid");
        tester2.submit("Next");
        tester2.assertTextPresent("Update Fields for Target Project 'Bovine' - Issue Type 'Bug'");
        tester2.submit("Next");
        tester2.assertTextPresent("Confirmation");
        tester2.submit("Next");
        this.waitAndReloadBulkOperationProgressPage(tester2);
        tester2.assertTextPresent("Issue Navigator");
        navigation2.issue().viewIssue("COW-15");
        tester2.clickLinkWithText("info.txt");
        tester2.assertTextPresent("JJJJJJ");
        File movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        this.tester.assertTextPresent("At least one of the issues you are trying to move has been recently moved by another user (RAT-1). Please cancel and start again.");
        movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("COW-15");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installAttachedFile(String contents) throws IOException {
        File attachedFile = new File(this.attachmentPath + "/RAT/RAT-1", "10010");
        attachedFile.getParentFile().mkdirs();
        try (PrintWriter out = new PrintWriter(new FileWriter(attachedFile));){
            out.println(contents);
        }
        return this.attachmentPath;
    }

    private void deleteAttachment(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("manage-attachment-link");
        this.tester.clickLink("del_10010");
        this.tester.submit("Delete");
    }
}

