/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.MOVE_ISSUE})
public class TestMoveIssue
extends JIRAWebTest {
    private static final String ISSUE_KEY_TO_MOVE = "HSP-1";
    private static final String ISSUE_KEY_NORMAL = "HSP-2";
    private static final String ANA_3 = "ANA-3";
    private static final String CURRENT_ISSUE_TYPE = "Current Issue Type";
    private static final String ANOTHER_TEST_PROJECT = "another test";
    private static final String NEW_ISSUE_TYPE = "New Issue Type";
    private static final String MORE_TESTS_ISSUE_TYPE = "more tests";
    private static final String ISSUETYPE_REQUEST_PARAM = "issuetype";
    private static final String PID_REQUEST_PARAM = "pid";
    private static final String JIRAFORM = "jiraform";
    private static final String MOVE_SUBMIT = "Move";
    private static final String RESULTING_ISSUE_TST_3 = "TST-3";
    private static final String TEST_PROJECT = "Test";
    private static final String MOVE_ISSUE_LINK = "move-issue";

    public TestMoveIssue(String name) {
        super(name);
    }

    public void testMoveIssue() {
        this.restoreData("TestMoveIssue.xml");
        this.moveOperationFunctionality(ISSUE_KEY_TO_MOVE);
        this.moveOperationWithMoveIssuesPermission(ISSUE_KEY_NORMAL);
        this.moveOperationWithInvalidDueDate(ISSUE_KEY_NORMAL);
        this.moveOperationWithDueDateRequired(ISSUE_KEY_NORMAL);
        this.moveOperationWithRequiredFields(ISSUE_KEY_NORMAL);
        this.deleteIssue(ISSUE_KEY_NORMAL);
        this.deleteIssue(ISSUE_KEY_TO_MOVE);
    }

    public void testMoveIssueIssueTypeAvailable() {
        TestMoveIssue.log("Move Operation: Test the visibility of the Issue Type field on move.");
        this.restoreData("TestMoveIssueIssueTypeAvailable.xml");
        String projectId = this.getProjectId(TEST_PROJECT);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)ANA_3, (Object)"type", (Object)ANOTHER_TEST_PROJECT), EasyMap.build((Object)"key", (Object)RESULTING_ISSUE_TST_3, (Object)"title", (Object)"[TST-3] Test"), ANA_3);
        this.gotoIssue(ANA_3);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent(CURRENT_ISSUE_TYPE);
        this.assertTextPresent(ANOTHER_TEST_PROJECT);
        this.assertTextPresent(NEW_ISSUE_TYPE);
        this.navigation.issue().selectIssueType(MORE_TESTS_ISSUE_TYPE, ISSUETYPE_REQUEST_PARAM);
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.getDialog().setWorkingForm(JIRAFORM);
        this.submit();
        this.assertTextPresent(ANOTHER_TEST_PROJECT);
        this.assertTextPresent(MORE_TESTS_ISSUE_TYPE);
        this.submit(MOVE_SUBMIT);
        this.assertTextPresent(RESULTING_ISSUE_TST_3);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)RESULTING_ISSUE_TST_3, (Object)"type", (Object)MORE_TESTS_ISSUE_TYPE, (Object)"priority", (Object)"Major"), null, RESULTING_ISSUE_TST_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveIssueAutomaticAssigneeWithComponents() {
        try {
            this.restoreData("TestMoveIssueAutomaticAssigneeWithComponents.xml");
            this.getBackdoor().darkFeatures().enableForSite("no.frother.assignee.field");
            String issueKeyToMove = this.addIssue("homosapien", "HSP", "Bug", "test move issue", "Trivial", new String[]{"New Component 1"}, null, null, "user1", "test environment 5", "test description to be moved to another project", null, null, null);
            this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)ISSUE_KEY_TO_MOVE), EasyMap.build((Object)"key", (Object)"NDT-1", (Object)"component", (Object)"New Component 2"), issueKeyToMove);
            String projectId = this.getProjectId("neanderthal");
            this.gotoIssue(issueKeyToMove);
            this.clickLink(MOVE_ISSUE_LINK);
            this.setFormElement(PID_REQUEST_PARAM, projectId);
            this.submit("Next >>");
            this.selectOption("components", "New Component 2");
            this.submit("Next >>");
            this.submit(MOVE_SUBMIT);
            this.assertTextPresent("user1");
            this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"NDT-1", (Object)"component", (Object)"New Component 2"), EasyMap.build((Object)"key", (Object)ISSUE_KEY_TO_MOVE), "NDT-1");
        }
        finally {
            this.deleteProject("homosapien");
            this.deleteProject("neanderthal");
            this.deletePermissionScheme("test move perm scheme");
            this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-users");
            this.deleteUser("user1");
            this.deleteUser("user2");
            this.getBackdoor().darkFeatures().disableForSite("no.frother.assignee.field");
        }
    }

    public void moveOperationFunctionality(String issueKey) {
        TestMoveIssue.log("Move Operation: Test the functionality of the 'Move' operation");
        String projectId = this.getProjectId("neanderthal");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.getDialog().setWorkingForm(JIRAFORM);
        this.submit();
        this.assertTextPresent("New Value (after move)");
        this.submit(MOVE_SUBMIT);
        this.assertTextNotPresent("homosapien");
        this.assertTextPresent("neanderthal");
    }

    public void moveOperationWithMoveIssuesPermission(String issueKey) {
        TestMoveIssue.log("Move Operation: Test the availability of the 'Move' Link with 'Move Issues' Permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresentWithText(MOVE_SUBMIT);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkPresentWithText(MOVE_SUBMIT);
    }

    public void moveOperationWithInvalidDueDate(String issueKey) {
        this.setDueDateToRequried();
        TestMoveIssue.log("Move Operation: selecting invalid due date");
        String projectId = this.getProjectId("monkey");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.setFormElement("duedate", "stuff");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
        this.resetFields();
    }

    public void moveOperationWithDueDateRequired(String issueKey) {
        this.setDueDateToRequried();
        TestMoveIssue.log("Move Operation: testing the availabilty of the 'Due Date' field with 'Due Date' required");
        String projectId = this.getProjectId("monkey");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.assertFormElementPresent("duedate");
        this.resetFields();
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.assertFormElementNotPresent("duedate");
    }

    public void moveOperationWithRequiredFields(String issueKey) {
        this.setRequiredFields();
        TestMoveIssue.log("Move Operation: Moving issue with required fields.");
        String projectId = this.getProjectId("neanderthal");
        this.gotoIssue(issueKey);
        this.clickLink(MOVE_ISSUE_LINK);
        this.assertTextPresent("Move Issue");
        this.setFormElement(PID_REQUEST_PARAM, projectId);
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.setWorkingForm(JIRAFORM);
        this.submit();
        this.assertErrorMsgFieldRequired("Component/s", "neanderthal", "components");
        this.assertErrorMsgFieldRequired("Fix Version/s", "neanderthal", "versions");
        this.assertErrorMsgFieldRequired("Affects Version/s", "neanderthal", "versions");
        this.resetFields();
    }

    public void testMoveWithMappingStatus() {
        this.restoreData("TestBulkMoveMapWorkflows.xml");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)"HSP-13", (Object)"summary", (Object)"bugs3", (Object)"status", (Object)"Totally Open"), null, "HSP-13");
        this.gotoIssue("HSP-13");
        this.assertTextPresent("Totally Open");
        this.clickLinkWithText(MOVE_SUBMIT);
        this.navigation.issue().selectProject("monkey");
        this.moveIssue();
        String movedIssueKey = this.getIssueKeyWithSummary("bugs3", "MKY");
        this.gotoIssue(movedIssueKey);
        this.assertTextNotPresent("Totally Open");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Open", (Object)"summary", (Object)"bugs3", (Object)"key", (Object)movedIssueKey), EasyMap.build((Object)"status", (Object)"Totally Open", (Object)"key", (Object)"HSP-13"), movedIssueKey);
    }

    public void testMoveIssueWithinProject() {
        this.restoreData("TestMoveIssue.xml");
        this.gotoIssue(ISSUE_KEY_TO_MOVE);
        this.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectIssueType("New Feature", ISSUETYPE_REQUEST_PARAM);
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit(MOVE_SUBMIT);
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.setFormElement("summary", "Test Bug 2");
        this.submit("Create");
        this.assertLinkPresentWithText("HSP-3");
    }

    public void testMoveIssueWithSubtasksBetweenProjects() {
        this.restoreData("TestMoveIssueWithSubtasks.xml");
        this.gotoIssue("HSP-3");
        this.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("neanderthal", "10000_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10000_1_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.assertLinkPresentWithText("NDT-1");
        this.clickLinkWithText("Sub-task 1");
        this.assertLinkPresentWithText("NDT-2");
        this.assertLastChangeHistoryIs("NDT-2", "Key", "HSP-4", "NDT-2");
        this.assertLastChangeHistoryIs("NDT-2", "Project", "homosapien", "neanderthal");
        this.assertLastChangeNotMadeToField("NDT-2", "Workflow");
        this.assertLastChangeNotMadeToField("NDT-2", "Status");
        this.assertLastChangeNotMadeToField("NDT-2", "Issue Type");
        this.assertLastChangeNotMadeToField("NDT-2", "Assignee");
        this.clickLink("parent_issue_summary");
        this.clickLinkWithText("Sub-task 2");
        this.assertLinkPresentWithText("NDT-3");
        this.assertLastChangeHistoryIs("NDT-2", "Project", "homosapien", "neanderthal");
        this.assertLastChangeNotMadeToField("NDT-3", "Workflow");
        this.assertLastChangeNotMadeToField("NDT-3", "Status");
        this.assertLastChangeNotMadeToField("NDT-3", "Issue Type");
        this.assertLastChangeNotMadeToField("NDT-3", "Assignee");
        this.navigation.issue().goToCreateIssueForm("homosapien", null);
        this.setFormElement("summary", "Test Bug 3");
        this.submit("Create");
        this.assertLinkPresentWithText("HSP-6");
        this.navigation.issue().goToCreateIssueForm("neanderthal", null);
        this.setFormElement("summary", "Test Bug 4");
        this.submit("Create");
        this.assertLinkPresentWithText("NDT-4");
    }

    public void testMoveSubtaskWithDifferentWorkflowAndStatuses() {
        this.restoreData("jra-14416-workflows.xml");
        this.gotoIssue("AA-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("B", "10000_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10000_1_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.assertTextPresent("Map Status for Target Project 'B'");
        this.assertTextPresent("Step 1 of 2");
        this.tester.selectOption("3", "Three");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.gotoIssue("BB-2");
        this.assertTextPresent("Three");
        this.assertTextPresent("Go To Fourth Step");
        this.assertLastChangeHistoryIs("BB-2", "Key", "AA-2", "BB-2");
        this.assertLastChangeHistoryIs("BB-2", "Project", "A", "B");
        this.assertLastChangeHistoryIs("BB-2", "Workflow", "classic default workflow", "B");
        this.assertLastChangeHistoryIs("BB-2", "Status", "In Progress", "Three");
        this.assertLastChangeNotMadeToField("BB-2", "Issue Type");
        this.assertLastChangeNotMadeToField("BB-2", "Assignee");
    }

    public void testMoveSubtaskWithDifferentWorkflows() {
        this.restoreData("jra-14416-statuses.xml");
        this.gotoIssue("AA-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("B", "10000_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10000_1_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.gotoIssue("BB-2");
        this.assertTextPresent("Mark As Complete");
        this.assertTextPresent("Sub-task");
        this.assertTextPresent("In Progress");
        this.assertLastChangeHistoryIs("BB-2", "Key", "AA-2", "BB-2");
        this.assertLastChangeHistoryIs("BB-2", "Project", "A", "B");
        this.assertLastChangeHistoryIs("BB-2", "Workflow", "jira", "B");
        this.assertLastChangeNotMadeToField("BB-2", "Status");
        this.assertLastChangeNotMadeToField("BB-2", "Issue Type");
        this.assertLastChangeNotMadeToField("BB-2", "Assignee");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveIssueWithSubtaskIssueTypesBetweenProjects() {
        this.restoreData("jra-14416.xml");
        this.gotoIssue("AL-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("Baloney", "10000_7_pid");
        this.navigation.issue().selectIssueType("Issue Type Bentley", "10000_7_issuetype");
        this.tester.submit("Next");
        this.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.text.assertTextPresent("Subtask Apple");
        this.text.assertTextPresent("Subtask Asterisk");
        this.navigation.issue().selectIssueType("Subtask Bacon", "10000_6_10001_issuetype");
        this.navigation.issue().selectIssueType("Subtask Butter", "10000_9_10001_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        try {
            this.getBackdoor().darkFeatures().enableForSite("no.frother.assignee.field");
            this.assertTextPresent("Workflow Brown");
            this.tester.selectOption("10000", "B-Status-2");
            this.tester.submit("Next");
            this.tester.submit("Next");
            this.tester.submit("Next");
            this.tester.submit("Next");
            this.waitAndReloadBulkOperationProgressPage();
        }
        finally {
            this.getBackdoor().darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.gotoIssue("BA-2");
        this.assertTextPresent("Subtask Bacon");
        this.assertTextPresent("Goto Hajime");
        this.assertLastChangeHistoryIs("BA-2", "Key", "AL-2", "BA-2");
        this.assertLastChangeHistoryIs("BA-2", "Issue Type", "Subtask Apple", "Subtask Bacon");
        this.assertLastChangeHistoryIs("BA-2", "Project", "Alabaster", "Baloney");
        this.assertLastChangeHistoryIs("BA-2", "Fix Version/s", "1.5", "");
        this.assertLastChangeHistoryIs("BA-2", "Affects Version/s", "1.5", "");
        this.assertLastChangeHistoryIs("BA-2", "Workflow", "Workflow Astaire", "Workflow Brown");
        this.assertLastChangeHistoryIs("BA-2", "Status", "A-Status-1", "B-Status-2");
        this.gotoIssue("BA-3");
        this.assertTextPresent("Subtask Butter");
        this.assertLastChangeHistoryIs("BA-3", "Key", "AL-3", "BA-3");
        this.assertLastChangeHistoryIs("BA-3", "Issue Type", "Subtask Asterisk", "Subtask Butter");
        this.assertLastChangeHistoryIs("BA-2", "Project", "Alabaster", "Baloney");
    }

    public void testMoveIssueWithSubtasksBetweenProjectsWithSecurityLevel() throws SAXException {
        this.restoreData("TestReindexingSubtasks.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.gotoIssue("RAT-5");
        this.assertTextPresentAfterText("Level Mouse", "Security Level");
        this.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("Porcine", "10022_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10022_1_issuetype");
        this.submit("Next");
        this.submit("Next");
        this.assertTextPresent("The value of this field must be changed to be valid in the target project");
        this.submit("Next");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Target Project", "Porcine", "Target Issue Type", "Bug", "Security Level", "None"});
        this.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.assertTextPresent("Porcine");
        this.assertTextNotPresent("Rattus");
        this.assertTextNotPresent("RAT-");
        this.assertTextNotPresent("Level Mouse");
        this.gotoIssue("PIG-11");
        this.assertTextNotPresent("Security Level");
        this.displayAllIssues();
        this.assertTextNotPresent("RAT-");
        this.assertTextNotPresent("Level Mouse");
        this.assertTableCellHasText("issuetable", 1, 1, "PIG-11");
        this.assertTableCellHasText("issuetable", 1, 11, "");
        this.assertTableCellHasText("issuetable", 2, 1, "PIG-10");
        this.assertTableCellHasText("issuetable", 2, 11, "");
        this.assertTableCellHasText("issuetable", 3, 1, "PIG-9");
        this.assertTableCellHasText("issuetable", 3, 11, "");
        this.gotoIssue("PIG-9");
        this.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("Canine", "10021_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10021_1_issuetype");
        this.submit("Next");
        this.submit("Next");
        this.selectOption("security", "Level Green");
        this.submit("Next");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Target Project", "Canine", "Target Issue Type", "Bug", "Security Level", "Level Green"});
        this.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.assertTextNotPresent("PIG");
        this.assertTextNotPresent("Porcine");
        this.assertTextPresent("Canine");
        this.assertTextPresentAfterText("Level Green", "Security Level:");
        this.gotoIssue("DOG-11");
        this.assertTextPresentAfterText("Level Green", "Security Level:");
        this.displayAllIssues();
        this.assertTextNotInTable("issuetable", "PIG");
        this.assertTableCellHasText("issuetable", 1, 1, "DOG-11");
        this.assertTableCellHasText("issuetable", 1, 11, "Level Green");
        this.assertTableCellHasText("issuetable", 2, 1, "DOG-10");
        this.assertTableCellHasText("issuetable", 2, 11, "Level Green");
        this.assertTableCellHasText("issuetable", 3, 1, "DOG-9");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Green");
    }

    public void testMoveIssueWithoutVersionPermission() throws SAXException {
        this.restoreData("TestMoveIssueWithoutVersionPermission.xml");
        this.gotoIssue(ISSUE_KEY_TO_MOVE);
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        int lastRow = this.getDialog().getWebTableBySummaryOrId("move_confirm_table").getRowCount() - 1;
        this.assertTableCellHasText("move_confirm_table", 1, 1, "homosapien");
        this.assertTableCellHasText("move_confirm_table", 1, 2, "monkey");
        this.assertTableCellHasText("move_confirm_table", lastRow, 1, "New Version 1");
        this.assertTableCellHasText("move_confirm_table", lastRow, 1, "New Version 4");
        this.assertTableCellHasNotText("move_confirm_table", lastRow, 2, "New Version 1");
        this.assertTableCellHasNotText("move_confirm_table", lastRow, 2, "New Version 4");
        this.tester.submit(MOVE_SUBMIT);
        this.assertTextPresent("MKY-1");
        this.assertTextPresent("Test issue 1");
        this.assertTextNotPresent("New Version 1");
        this.assertTextNotPresent("New Version 4");
    }

    public void testMoveIssueWithRequiredLabels() {
        this.administration.restoreData("TestMoveLabels.xml");
        this.getNavigation().issue().viewIssue("HSP-10");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey");
        this.tester.submit("Next >>");
        this.assertTextPresent("Move Issue: Update Fields");
        this.assertTextPresent("Labels");
        this.tester.submit("Next >>");
        this.assertTextPresent("Labels is required");
        this.getNavigation().issue().viewIssue("HSP-9");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey");
        this.tester.submit("Next >>");
        this.assertTextPresent("Move Issue: Update Fields");
        this.assertTextPresent("All fields will be updated automatically");
        this.tester.submit("Next >>");
        this.tester.submit(MOVE_SUBMIT);
        this.tester.assertTextPresent("MKY-8");
        this.getNavigation().issue().viewIssue("HSP-8");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.assertTextPresent("Update Fields");
        this.assertTextPresent("All field values will be retained");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.assertTextPresent("Labels is required");
    }

    public void testMoveIssueWithSubtasksAndComponents() {
        this.administration.restoreData("JRA-17312.xml");
        this.getNavigation().issue().viewIssue("TWO-1");
        this.assertTextPresent("Date Custom Field:");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("ONE", "10001_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10001_1_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.selectOption("components_10001", "comp-one");
        this.tester.submit("Next");
        this.selectOption("components_10001", "comp-one");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.waitAndReloadBulkOperationProgressPage();
        this.getNavigation().issue().viewIssue("ONE-3");
        this.assertTextNotPresent("Date Custom Field:");
        this.assertTextSequence(new String[]{"Component/s", "comp-one"});
        this.assertTextPresent("Due:");
        this.getNavigation().issue().viewIssue("ONE-3");
        this.assertTextSequence(new String[]{"Component/s", "comp-one"});
        this.assertTextPresent("Due:");
    }

    public void testMoveIssueWithRequiredCustomFields() {
        this.administration.restoreData("JRA-12479.xml");
        this.getNavigation().issue().viewIssue("ONE-1");
        this.tester.clickLink(MOVE_ISSUE_LINK);
        this.navigation.issue().selectProject("TWO");
        this.tester.submit("Next >>");
        this.tester.setFormElement("customfield_10100", "Hello World!");
        this.tester.submit("Next >>");
        this.assertTextSequence(new String[]{"More Summary CF", "Hello World!"});
    }

    private void moveIssue() {
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit(MOVE_SUBMIT);
    }
}

