/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS, Category.MOVE_ISSUE, Category.TIME_TRACKING})
public class TestDeleteHiddenFieldOnMove
extends FuncTestCase {
    @Override
    public void setUpTest() {
        this.administration.restoreData("TestDeleteHiddenFieldOnMove.xml");
    }

    public void testSingleMove() {
        this.navigation.issue().viewIssue("COW-13");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("Rattus", "10010_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10010_1_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        WebTable move_confirm_table = this.tester.getDialog().getWebTableBySummaryOrId("move_confirm_table");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(move_confirm_table, new String[]{"Target Project", "Rattus"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(move_confirm_table, new String[]{"Target Issue Type", "Bug"});
        WebTable removed_fields = this.tester.getDialog().getWebTableBySummaryOrId("removed_fields_table");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Fix Version/s"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Stuff"});
        this.assertions.getTableAssertions().assertTableContainsRow(removed_fields, new String[]{"Milk"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Priority"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Resolution"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Environment"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Affects Version/s"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Description"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Milk2"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Assignee"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Reporter"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Time Tracking"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields, new String[]{"Due Date"});
        this.tester.submit("Next");
        this.assertChangesAfterMove();
    }

    public void testBulkMove() {
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10012", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issueNavigator().bulkEditAllIssues();
        this.tester.checkCheckbox("bulkedit_10012", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("Rattus", "10010_1_pid");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Bug'");
        this.tester.assertTextPresent("All field values will be retained.");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Rattus' - Issue Type 'Sub-task'");
        this.tester.assertTextPresent("All field values will be retained.");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Confirmation");
        WebTable removed_fields_table = this.tester.getDialog().getWebTableBySummaryOrId("removed_fields_table");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Removed Fields"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Time Tracking"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Assignee"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Fix Version/s"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Resolution"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Reporter"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Affects Version/s"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Environment"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Description"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Priority"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Stuff"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Due Date"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Milk2"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Component/s"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(removed_fields_table, new String[]{"Milk"}, true);
        this.tester.submit("Next");
        this.assertChangesAfterMove();
    }

    private void assertChangesAfterMove() {
        this.navigation.issue().viewIssue("RAT-15");
        this.tester.clickLinkWithText("History");
        WebTable changehistory_10070 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10070");
        TestDeleteHiddenFieldOnMove.assertEquals((String)("Expected table to have 17 rows, but found " + changehistory_10070.getRowCount()), (int)17, (int)changehistory_10070.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Project", "Bovine [ 10010 ]", "Rattus [ 10000 ]"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Key", "COW-13", "RAT-15"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Assignee", "Daisy Doolittle [ daisy ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Fix Version/s", "1.1 [ 10002 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Resolution", "Fixed [ 1 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Reporter", "admin [ admin ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Affects Version/s", "1.0 [ 10000 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Environment", "the environment", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Priority", "Major [ 3 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Description", "Hello", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Stuff", "stuff value 1", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Due Date", "27/Oct/09", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Milk2", "milk value 2", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Component/s", "Horns [ 10001 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Milk", "milk value 1", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10070, new String[]{"Original Estimate", "1 week, 3 days [ 230400 ]", ""});
        this.navigation.issue().viewIssue("RAT-16");
        WebTable changehistory_10071 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10071");
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Reporter", "admin [ admin ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Assignee", "Daisy Doolittle [ daisy ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Description", "Hello again", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Environment", "sub env", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Priority", "Major [ 3 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Resolution", "Fixed [ 1 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Due Date", "27/Oct/09", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Project", "Bovine [ 10010 ]", "Rattus [ 10000 ]"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Key", "COW-14", "RAT-16"});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Fix Version/s", "2.0 [ 10001 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Affects Version/s", "1.1 [ 10002 ]", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Stuff", "sub stuff 1", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Milk2", "sub milk 2", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Milk", "sub milk 1", ""});
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10071, new String[]{"Component/s", "Horns [ 10001 ]", ""});
    }
}

