/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.clone;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.CLONE_ISSUE})
public class TestCloneIssueAttachments
extends FuncTestCase {
    private static final String ATTACHMENT_FILE_NAME_1 = "info.txt";
    private static final String ATTACHMENT_FILE_NAME_2 = "anotherfile.txt";
    private static final String ATTACHMENT_ID_1 = "10010";
    private static final String ATTACHMENT_ID_2 = "10020";
    private static final String ATTACHMENT_CONTENTS_1 = "AAAAA";
    private static final String ATTACHMENT_CONTENTS_2 = "BBBBB";
    private static final String CLONE_ATTACHMENTS_CHECKBOX_NAME = "cloneAttachments";
    private static final String ORIGINAL_ISSUE_KEY = "RAT-1";
    private static final String ORIGINAL_SUBTASK_KEY_1 = "RAT-2";
    private static final String ORIGINAL_SUBTASK_KEY_3 = "RAT-4";
    private static final String ORIGINAL_COW_ISSUE_KEY = "COW-16";
    private static final String ATTACH_FILE_ISSUE_OPERATION_LINK_ID = "attach-file";
    private static final String DESIGN_ATTACHMENT_FILE_NAME_1 = "design_attachment_1.txt";
    private static final String DESIGN_ATTACHMENT_FILE_NAME_2 = "design_attachment_2.txt";
    private static final String DESIGN_ATTACHMENT_CONTENTS_1 = "Design Attachments Stuff";
    private static final String DESIGN_ATTACHMENT_CONTENTS_2 = "Some other Design Attachments Stuff";
    private static final String DESIGN_ATTACHMENT_ID_1 = "10030";
    private static final String DESIGN_ATTACHMENT_ID_2 = "10031";
    private static final String IMPLEMENT_ATTACHMENT_FILE_NAME_1 = "implment_attachment_1.txt";
    private static final String IMPLEMENT_ATTACHMENT_CONTENTS_1 = "Implement Attachments Stuff";
    private static final String IMPLEMENT_ATTACHMENT_ID_1 = "10032";
    private static final String COW_ATTACHMENT_FILE_NAME_1 = "cowfile.txt";
    private static final String CLONE_ATTACHMENTS_CHECKBOX_LABEL = "Clone Attachments";
    private static final String CLONE_ISSUE_OPERATION_NAME = "clone-issue";
    private static final String SUMMARY_FIELD_ID = "summary";
    private static final String CLONE_SUBTASKS_CHECK_BOX_ID = "cloneSubTasks";
    private static final String CREATE_BUTTON_NAME = "Create";
    private String attachmentPath;

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestCloneIssueAttachments.xml");
        this.administration.attachments().enable();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.attachmentPath = this.administration.getCurrentAttachmentPath();
        this.installAttachedFile(ORIGINAL_ISSUE_KEY, ATTACHMENT_CONTENTS_1, ATTACHMENT_FILE_NAME_1, ATTACHMENT_ID_1);
        this.installAttachedFile(ORIGINAL_ISSUE_KEY, ATTACHMENT_CONTENTS_2, ATTACHMENT_FILE_NAME_2, ATTACHMENT_ID_2);
        this.installAttachedFile(ORIGINAL_SUBTASK_KEY_1, DESIGN_ATTACHMENT_CONTENTS_1, DESIGN_ATTACHMENT_FILE_NAME_1, DESIGN_ATTACHMENT_ID_1);
        this.installAttachedFile(ORIGINAL_SUBTASK_KEY_1, DESIGN_ATTACHMENT_CONTENTS_2, DESIGN_ATTACHMENT_FILE_NAME_2, DESIGN_ATTACHMENT_ID_2);
        this.installAttachedFile(ORIGINAL_SUBTASK_KEY_3, IMPLEMENT_ATTACHMENT_CONTENTS_1, IMPLEMENT_ATTACHMENT_FILE_NAME_1, IMPLEMENT_ATTACHMENT_ID_1);
    }

    private void installAttachedFile(String issueKey, String contents, String attachmentFileName, String attachmentId) {
        File attachedFile = new File(this.attachmentPath + "/RAT/" + issueKey, attachmentId + "_" + attachmentFileName);
        attachedFile.getParentFile().mkdirs();
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(attachedFile));
            out.print(contents);
        }
    }

    public void testCloneAttachmentsDisabled() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresent(ATTACH_FILE_ISSUE_OPERATION_LINK_ID);
        this.administration.attachments().disable();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkNotPresent(ATTACH_FILE_ISSUE_OPERATION_LINK_ID);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    public void testCloneAttachmentsAvailable() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_3).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().viewIssue(ORIGINAL_COW_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(COW_ATTACHMENT_FILE_NAME_1);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_COW_ISSUE_KEY).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_COW_ISSUE_KEY);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    public void testCloneAttachmentsAvailableForSubTasks() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextNotPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
    }

    public void testCloneNoLinksNoSubTasksNoAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
    }

    public void testCloneNoLinksNoSubTasksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECK_BOX_ID);
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.issue().attachments(cloneIssueKey).manage().delete();
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
    }

    public void testCloneNoLinksWithSubTasksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertFormElementEquals(CLONE_SUBTASKS_CHECK_BOX_ID, "true");
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Library attempts HTTP communications with URLs that are in the Trackback Filter.");
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.clickLinkWithExactText("CLONE - Design Solution");
        String cloneSubtaskIssueKey1 = this.extractIssueKey();
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.clickLinkWithExactText("CLONE - Implement Solution");
        String cloneSubtaskIssueKey2 = this.extractIssueKey();
        this.tester.clickLinkWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(IMPLEMENT_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().attachments(cloneIssueKey).manage().delete();
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_ISSUE_KEY);
        this.tester.clickLinkWithText(ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_ISSUE_KEY).manage().delete();
        this.navigation.issue().attachments(cloneSubtaskIssueKey1).manage().delete();
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
        this.navigation.issue().attachments(cloneSubtaskIssueKey2).manage().delete();
        this.navigation.issue().viewIssue(cloneSubtaskIssueKey2);
        this.tester.assertLinkNotPresentWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_3);
        this.tester.assertLinkPresentWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.clickLinkWithText(IMPLEMENT_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(IMPLEMENT_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_3).manage().delete();
    }

    public void testCloneSubTaskNoLinksCopyAttachments() throws Exception {
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLink(CLONE_ISSUE_OPERATION_NAME);
        this.tester.assertTextPresent(CLONE_ATTACHMENTS_CHECKBOX_LABEL);
        this.tester.assertCheckboxNotSelected(CLONE_ATTACHMENTS_CHECKBOX_NAME);
        String cloneSummary = "CLONE - Sub-Task";
        this.tester.setFormElement(SUMMARY_FIELD_ID, "CLONE - Sub-Task");
        this.tester.checkCheckbox(CLONE_ATTACHMENTS_CHECKBOX_NAME, "true");
        this.tester.submit(CREATE_BUTTON_NAME);
        this.tester.assertTextPresent("CLONE - Sub-Task");
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        String cloneIssueKey = this.extractIssueKey();
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.navigation.issue().attachments(cloneIssueKey).manage().delete();
        this.navigation.issue().viewIssue(cloneIssueKey);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkNotPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertLinkPresentWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_1);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_1);
        this.navigation.issue().viewIssue(ORIGINAL_SUBTASK_KEY_1);
        this.tester.clickLinkWithText(DESIGN_ATTACHMENT_FILE_NAME_2);
        this.tester.assertTextPresent(DESIGN_ATTACHMENT_CONTENTS_2);
        this.navigation.issue().attachments(ORIGINAL_SUBTASK_KEY_1).manage().delete();
    }

    private String extractIssueKey() {
        IdLocator locator = new IdLocator(this.tester, "key-val");
        return locator.getRawText();
    }
}

