/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestAssignToMe
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestAssignToMe.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    public void testAssignToMeWhenTheUserReportedTheIssue() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.text.assertTextPresent(this.locator.id("assignee-val"), "Fred Normal");
        this.text.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.tester.clickLink("assign-to-me");
        this.text.assertTextPresent(this.locator.id("assignee-val"), "Administrator");
        this.text.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    public void testAssignToMeWhenUserNamesContainNonAlphaNumericCharacters() {
        this.navigation.logout();
        this.navigation.login("#test");
        this.navigation.issue().gotoIssue("MKY-1");
        this.text.assertTextPresent(this.locator.id("assignee-val"), "Fred Normal");
        this.text.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.tester.clickLink("assign-to-me");
        this.text.assertTextPresent(this.locator.id("assignee-val"), "#test");
        this.tester.assertLinkNotPresent("assign-to-me");
        this.text.assertTextPresent(this.locator.id("reporter-val"), "Administrator");
        this.navigation.logout();
        this.navigation.login("admin");
    }

    public void testAssignToMeNotVisibleIfNoAssignIssuePermission() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    public void testAssignToMeNotVisibleIfNoAssignableUserPermission() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-users");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    public void testAssignToMeNotVisibleIfIssueIsNotEditable() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.navigation.issue().closeIssue("MKY-1", "Fixed", "Fixed");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkNotPresent("assign-to-me");
    }

    public void testAssignToMeNotVisibleIfAnonymousUser() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.assertLinkPresent("assign-to-me");
        this.navigation.logout();
        this.navigation.issue().gotoIssue("MKY-1");
        this.text.assertTextPresent(this.locator.id("assignee-val"), "Fred Normal");
        this.tester.assertLinkNotPresent("assign-to-me");
    }
}

