/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestAssignToCurrentUserFunction
extends JIRAWebTest {
    public TestAssignToCurrentUserFunction(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestAssignToCurrentUserFunction.xml");
    }

    public void testAssignToCurrentUserWithNoAssignIssuePermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.clickLink("0_edit");
        this.clickLink("del_perm_" + ProjectPermissions.ASSIGN_ISSUES.permissionKey() + "_jira-developers");
        this.submit("Delete");
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertTextSequence(new String[]{"Assignee:", "Administrator", "Reporter:", "Administrator"});
    }

    public void testAssignToCurrentUserWithNoAssignableUserPermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.clickLink("0_edit");
        this.clickLink("del_perm_" + ProjectPermissions.ASSIGNABLE_USER.permissionKey() + "_jira-developers");
        this.submit("Delete");
        this.clickLink("del_perm_" + ProjectPermissions.ASSIGNABLE_USER.permissionKey() + "_jira-users");
        this.submit("Delete");
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
    }

    public void testAssignToCurrentUser() {
        this.gotoIssue("MKY-1");
        this.assertTextSequence(new String[]{"Assignee:", "Fred Normal", "Reporter:", "Administrator"});
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertTextSequence(new String[]{"Assignee:", "Administrator", "Reporter:", "Administrator"});
    }
}

