/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SECURITY})
public class TestXmlIssueViewXss
extends FuncTestCase {
    private static final String XSS_ALERT_RAW = "\"alert('surprise!')";
    private static final String XSS_ALERT_XML_ESCAPED = "&quot;alert(&apos;surprise!&apos;)";
    private static final String HTML_FRAGMENT = "/--><html><body>hi</body>;<!--";
    private static final String HTML_FRAGMENT_ESCAPED = StringEscapeUtils.escapeXml((String)"/--><html><body>hi</body>;<!--");

    @Override
    protected void setUpHttpUnitOptions() {
        super.setUpHttpUnitOptions();
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.navigation.login("admin");
        this.administration.restoreBlankInstance();
    }

    @Override
    protected void tearDownTest() {
        this.navigation.login("admin");
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
        super.tearDownTest();
    }

    public void testXssInModuleKeyParam() throws IOException {
        this.tester.gotoPage("/si/jira.issueviews:<script>alert('XSS')<script>/HSP-1/HSP-1.xml");
        TestXmlIssueViewXss.assertFalse((boolean)this.tester.getDialog().getResponse().getText().contains("<script>alert('XSS')<script>"));
    }

    public void testXssInIssueKeyParam() throws IOException {
        this.tester.gotoPage("/si/jira.issueviews:HSP/<script>alert('XSS')<script>");
        TestXmlIssueViewXss.assertFalse((boolean)this.tester.getDialog().getResponse().getText().contains("<script>alert('XSS')<script>"));
    }

    public void testUsernameAndFullnameEscaping() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        this.navigation.login(XSS_ALERT_RAW, "password");
        String issueKey = this.navigation.issue().createIssue("monkey", null, "Just a bug");
        this.navigation.issue().viewXml(issueKey);
        this.assertions.getTextAssertions().assertTextPresent(XSS_ALERT_XML_ESCAPED);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_ALERT_RAW);
    }

    public void testUsernameAndFullnameEscapingOnUserPicker() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        String cfId = this.administration.customFields().addCustomField(TestXmlIssueViewXss.builtInCustomFieldKey("userpicker"), "test-xss");
        String issueKey = this.navigation.issue().createIssue("monkey", null, "Just a bug", (Map<String, String[]>)ImmutableMap.of((Object)cfId, (Object)new String[]{XSS_ALERT_RAW}));
        this.navigation.issue().viewXml(issueKey);
        this.assertions.getTextAssertions().assertTextPresent(XSS_ALERT_XML_ESCAPED);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_ALERT_RAW);
    }

    public void testUsernameAndFullnameEscapingOnMultiUserPicker() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        String cfId = this.administration.customFields().addCustomField(TestXmlIssueViewXss.builtInCustomFieldKey("multiuserpicker"), "test-xss");
        String issueKey = this.navigation.issue().createIssue("monkey", null, "Just a bug", (Map<String, String[]>)ImmutableMap.of((Object)cfId, (Object)new String[]{XSS_ALERT_RAW, "admin"}));
        this.navigation.issue().viewXml(issueKey);
        this.assertions.getTextAssertions().assertTextPresent("<customfieldvalue><![CDATA[\"alert('surprise!')]]></customfieldvalue>");
        this.assertions.getTextAssertions().assertTextPresentNumOccurences(XSS_ALERT_RAW, 1);
    }

    public void testIssueXMLViewEncodesQueryString() throws IOException {
        this.administration.restoreBlankInstance();
        String linkKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue to link to");
        this.tester.getDialog().gotoPage(this.tester.getTestContext().getBaseUrl() + String.format("/si/jira.issueviews:issue-xml/%s/%s.xml?%s", linkKey, linkKey, HTML_FRAGMENT));
        String responseText = this.tester.getDialog().getResponse().getText();
        Assert.assertThat((Object)responseText, (Matcher)StringContains.containsString((String)HTML_FRAGMENT_ESCAPED));
        Assert.assertThat((Object)responseText, (Matcher)CoreMatchers.not((Matcher)StringContains.containsString((String)HTML_FRAGMENT)));
    }
}

