/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.page.Error404;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestXmlIssueViewErrors
extends JIRAWebTest {
    private static final String SAMPLE_PATH_MESSAGE_1 = "Invalid path format.";
    private static final String SAMPLE_PATH_MESSAGE_2 = "Path should be of format";
    private static final String SAMPLE_PATH_MESSAGE_3 = "/si/jira.issueviews:xml/JRA-10/JRA-10.xml";
    private static final String BAD_PLUGIN_MESSAGE = "java.lang.IllegalArgumentException: Invalid complete key specified: unknownplugin";

    public TestXmlIssueViewErrors(String name) {
        super(name);
    }

    @Override
    protected void setUpHttpUnitOptions() {
        TestXmlIssueViewErrors.log("not running normal test setup for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Override
    public void tearDown() {
        TestXmlIssueViewErrors.log("not running normal test teardown for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
    }

    public void testMalformedUrls() throws Exception {
        this.assert400SamplePathMessage("/si");
        this.assert400SamplePathMessage("/si/");
        this.assert400SamplePathMessage("/si/unknownplugin");
        this.assert400SamplePathMessage("/si/unknownplugin/");
        this.assert400SamplePathMessage("/si/unknownplugin/blah");
        this.assert400BadPlugin("/si/unknownplugin/blah/");
        this.assert404BadKey("/si/jira.issueviews:issue-xml/badkey/");
    }

    private void assert404BadKey(String url) throws IOException {
        this.beginAt(url);
        Assert.assertThat((Object)new Error404(this.tester), Error404.isOn404Page());
    }

    private void assert400SamplePathMessage(String url) {
        this.assertResponseCode(url, 400);
        this.assertTextPresent("Invalid path format. Path should be of format /si/jira.issueviews:xml/JRA-10/JRA-10.xml");
    }

    private void assert400BadPlugin(String url) {
        this.assertResponseCode(url, 400);
        this.assertTextPresent("Could not find any enabled plugin with key");
    }

    private void assertResponseCode(String url, int code) {
        this.beginAt(url);
        WebResponse webResponse = this.tester.getDialog().getResponse();
        TestXmlIssueViewErrors.assertEquals((int)code, (int)webResponse.getResponseCode());
    }
}

