/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.FileUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXPath;
import electric.xml.XPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestXmlIssueViewBackwardCompatibility
extends JIRAWebTest {
    final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    final String XML_VIEW_URL = "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml";

    public TestXmlIssueViewBackwardCompatibility(String name) {
        super(name);
    }

    private String changeUrl(String baseUrl, String url) throws MalformedURLException {
        try {
            URI baseUri = new URI(baseUrl);
            URI uri = new URI(url);
            URL newUrl = new URL(baseUri.getScheme(), baseUri.getHost(), baseUri.getPort(), baseUri.getPath() + uri.getPath().replaceFirst("/jira/", ""));
            return newUrl.toString();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException();
        }
    }

    private void assertItemsEqual(Document originalDoc, Document doc) throws IOException, ParserConfigurationException, SAXException {
        XPath xPath = new XPath("//item");
        Element originalElement = originalDoc.getElement((IXPath)xPath);
        Element element = doc.getElement((IXPath)xPath);
        element.removeElement("project");
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/created"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/updated"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/resolved"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/due"), null);
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/comments/comment"), "created");
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/attachments/attachment"), "created");
        this.removeTimeZoneFromElementValue(originalDoc, doc, new XPath("//item/customfields/customfield[@key='com.atlassian.jira.plugin.system.customfieldtypes:datetime']/customfieldvalues/customfieldvalue"), null);
        originalElement.getElement("link").getText().setData(this.changeUrl(this.getTestContext().getBaseUrl(), originalElement.getElement("link").getText().getData()));
        originalElement.getElement("type").setAttribute("iconUrl", this.changeUrl(this.getTestContext().getBaseUrl(), originalElement.getElement("type").getAttribute("iconUrl")));
        originalElement.getElement("priority").setAttribute("iconUrl", this.changeUrl(this.getTestContext().getBaseUrl(), originalElement.getElement("priority").getAttribute("iconUrl")));
        originalElement.getElement("status").setAttribute("iconUrl", this.changeUrl(this.getTestContext().getBaseUrl(), originalElement.getElement("status").getAttribute("iconUrl")));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLAssert.assertXMLEqual((String)originalElement.toString(), (String)element.toString());
    }

    private void removeTimeZoneFromElementValue(Document originalDocument, Document document, XPath xPathToElement, String attributeName) {
        Elements originalElements = originalDocument.getElements((IXPath)xPathToElement);
        Elements elements = document.getElements((IXPath)xPathToElement);
        if (originalElements != null && elements != null) {
            while (originalElements.hasMoreElements() && elements.hasMoreElements()) {
                if (attributeName == null) {
                    this.removeTimeZoneFromElementValue(originalElements.next());
                    this.removeTimeZoneFromElementValue(elements.next());
                    continue;
                }
                this.removeTimeZoneFromAttributeValue(originalElements.next(), attributeName);
                this.removeTimeZoneFromAttributeValue(elements.next(), attributeName);
            }
        }
    }

    private void removeTimeZoneFromElementValue(Element dateElement) {
        try {
            Date createdDate = this.dateFormat.parse(dateElement.getText().toString());
            dateElement.setText(this.dateFormat.format(createdDate));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeTimeZoneFromAttributeValue(Element dateElement, String attributeName) {
        try {
            Date createdDate = this.dateFormat.parse(dateElement.getAttribute(attributeName));
            dateElement.setAttribute(attributeName, this.dateFormat.format(createdDate));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertCommentHasDetailsOnRestrictingFields(Document doc, String xmlViewUrl) {
        TestXmlIssueViewBackwardCompatibility.log("Checking the contents of the XML comment of the XML resulsts");
        Node commentNode = doc.getFirstChild();
        TestXmlIssueViewBackwardCompatibility.assertNotNull((Object)commentNode);
        TestXmlIssueViewBackwardCompatibility.assertEquals((short)8, (short)commentNode.getNodeType());
        String commentText = commentNode.getNodeValue();
        TestXmlIssueViewBackwardCompatibility.assertNotNull((Object)commentText);
        TestXmlIssueViewBackwardCompatibility.assertTrue((commentText.indexOf("RSS generated by JIRA") > -1 ? 1 : 0) != 0);
        TestXmlIssueViewBackwardCompatibility.assertTrue((commentText.indexOf("It is possible to restrict the fields that are returned in this document by specifying the 'field' parameter in your request.\nFor example, to request only the issue key and summary add field=key&field=summary to the URL of your request.") > -1 ? 1 : 0) != 0);
        String expectedUrl = this.getEnvironmentData().getBaseUrl() + xmlViewUrl;
        expectedUrl = xmlViewUrl.indexOf("?") > -1 ? expectedUrl + "&" : expectedUrl + "?";
        expectedUrl = expectedUrl + "field=key&field=summary";
        TestXmlIssueViewBackwardCompatibility.assertTrue((commentText.indexOf(StringEscapeUtils.escapeXml((String)expectedUrl)) > -1 ? 1 : 0) != 0);
    }

    public void testRegularView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.restoreData("TestXMLIssueCustomView.xml");
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1.xml");
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestXmlIssueViewBackwardCompatibility.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    public void testNoIssueLinksView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.deactivateIssueLinking();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-issue-links.xml");
        String xmlViewUrl = "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xmll?some=value&another=blah";
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xmll?some=value&another=blah");
        TestXmlIssueViewBackwardCompatibility.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xmll?some=value&another=blah");
    }

    public void testNoTimetrackingView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.deactivateTimeTracking();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-timetracking.xml");
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestXmlIssueViewBackwardCompatibility.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    public void testTimetrackingHiddenView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.setHiddenFields("Time Tracking");
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-timetracking.xml");
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestXmlIssueViewBackwardCompatibility.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    public void testHideDueDateFieldView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.setHiddenFields("Due Date");
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-due-date-hidden.xml");
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestXmlIssueViewBackwardCompatibility.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    public void testNoCustomFieldsView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.removeAllCustomFields();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-custom-fields.xml");
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestXmlIssueViewBackwardCompatibility.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    public void testNoSubtasksView() throws IOException, electric.xml.ParseException, ParserConfigurationException, SAXException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.deleteIssue("HSP-3");
        this.deactivateSubTasks();
        Document originalDoc = this.getComparisonDocument("TestXmlIssueView-HSP-1-no-subtasks.xml");
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestXmlIssueViewBackwardCompatibility.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertItemsEqual(originalDoc, doc);
        this.assertCommentHasDetailsOnRestrictingFields(doc, "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
    }

    public Document getComparisonDocument(String fileName) throws electric.xml.ParseException {
        return new Document(new File(this.getEnvironmentData().getXMLDataLocation(), fileName));
    }

    protected Document getDocument() throws IOException, electric.xml.ParseException {
        InputStream inputStream = this.getDialog().getResponse().getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        return new Document(outputStream.toByteArray());
    }
}

