/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.ParseException;
import electric.xml.XPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestXmlIssueView
extends FuncTestCase {
    private static final String ISSUE1 = "HSP-1";
    private static final String TESTUSERNAME = "testuser";
    private static final String TESTUSERFNAME = "User Fullname";
    private static final String TESTUSEREMAIL = "test@test.com";
    private static final String TESTUSERPASS = "12345";
    private static final String TESTPROJECTSUMMARY = "a new bug";
    private static final String TESTDESCRIP = "A nice description";
    private static final String TESTENVI = "A test environment";
    private static final String i18n = "\u0126\u0118\u0139\u0139\u0150";

    public void testPotentiallyInvalidCharacters() throws ParseException, IOException {
        this.administration.restoreBlankInstance();
        this._testSingleCharacter("<", "&lt;");
        this._testSingleCharacter(">", "&gt;");
        this._testSingleCharacter("&", "&amp;");
        this._testSingleCharacter("\u0000", "");
        this._testSingleCharacter(i18n, XMLUtils.escape((String)i18n));
        this._testSingleCharacter("\u0014", "");
    }

    private void _testSingleCharacter(String unescapedCharacter, String escapedCharacter) {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "(Test Issue with " + unescapedCharacter + ")");
        this.navigation.issue().gotoIssue(key);
        this.tester.clickLinkWithText("XML");
        TestXmlIssueView.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        this.assertions.getTextAssertions().assertTextPresent("(Test Issue with " + escapedCharacter + ")");
        this.tester.gotoPage("/secure/project/ViewProjects.jspa");
    }

    public void testUsers() throws IOException, ParseException {
        this._testEscapedUsers("(", "%28");
        this._testEscapedUsers(")", "%29");
        this._testEscapedUsers("'", "%27");
    }

    public void _testEscapedUsers(String unEscapedCharacter, String urlEncodedCharacter) throws IOException {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addUser(TESTUSERNAME + unEscapedCharacter, TESTUSERPASS, TESTUSERFNAME, TESTUSEREMAIL);
        this.administration.usersAndGroups().addUserToGroup(TESTUSERNAME + urlEncodedCharacter, "jira-developers");
        this.navigation.logout();
        this.navigation.login(TESTUSERNAME + unEscapedCharacter, TESTUSERPASS);
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue      ");
        this.navigation.issue().gotoIssue(key);
        this.tester.clickLinkWithText("XML");
        TestXmlIssueView.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        try {
            this.getDocument();
        }
        catch (ParseException e) {
            TestXmlIssueView.fail((String)"document not well-formed");
        }
        this.navigation.login("admin", "admin");
    }

    public void testEscapingCommentVisibility() throws Exception {
        this.administration.restoreData("TestXMLIssueView.xml");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.clickLinkWithText("XML");
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/comments/comment[1]", "admin", "author");
        this.assertExpectedXpathValue(doc, "//item/comments/comment[1]", "<Xml Nasty & Role>", "rolelevel");
    }

    public void testAggregateTimeTracking() throws IOException, ParseException {
        this.administration.restoreData("TestSearchRequestViewsAndIssueViews.xml");
        this.navigation.issue().gotoIssue("HSP-10");
        this.tester.clickLinkWithText("XML");
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/timeoriginalestimate", "86400", "seconds");
        this.assertExpectedXpathValue(doc, "//item/timeestimate", "86400", "seconds");
        this.assertXpathElementNotPresent(doc, "//item/timespent");
        this.assertXpathElementNotPresent(doc, "//item/aggregatetimeoriginalestimate");
        this.assertXpathElementNotPresent(doc, "//item/aggregatetimeremainingestimate");
        this.assertXpathElementNotPresent(doc, "//item/aggregatetimespent");
        this.administration.subtasks().enable();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.subTaskify("HSP-12", "HSP-10");
        this.subTaskify("HSP-11", "HSP-10");
        this.navigation.issue().gotoIssue("HSP-10");
        this.tester.clickLinkWithText("XML");
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/timeoriginalestimate", "86400", "seconds");
        this.assertExpectedXpathValue(doc, "//item/timeestimate", "86400", "seconds");
        this.assertXpathElementNotPresent(doc, "//item/timespent");
        this.assertExpectedXpathValue(doc, "//item/aggregatetimeoriginalestimate", "86400", "seconds");
        this.assertExpectedXpathValue(doc, "//item/aggregatetimeremainingestimate", "88200", "seconds");
        this.assertExpectedXpathValue(doc, "//item/aggregatetimespent", "12000", "seconds");
    }

    protected void subTaskify(String issueKey, String parentKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", parentKey);
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
    }

    public void testAttachmentsAlwaysPresent() throws IOException, ParseException {
        this.administration.restoreData("TestXMLIssueView.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideField(2);
        this.navigation.issue().gotoIssue(ISSUE1);
        this.tester.clickLinkWithText("XML");
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/attachments/attachment", "test.txt", "name");
        this.assertExpectedXpathValue(doc, "//item/attachments/attachment", "8", "size");
        this.assertExpectedXpathValue(doc, "//item/attachments/attachment", "admin", "author");
    }

    public void testNodeExistence() throws IOException, ParseException {
        this.administration.restoreData("TestXMLIssueView.xml");
        this.navigation.issue().gotoIssue(ISSUE1);
        this.tester.clickLinkWithText("XML");
        TestXmlIssueView.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//channel/link", this.getEnvironmentData().getBaseUrl().toString(), null);
        this.assertElementExists(doc, "//item/created");
        this.assertElementExists(doc, "//item/updated");
        this.assertExpectedXpathValue(doc, "//item/title", "[HSP-1] a new bug", null);
        this.assertExpectedXpathValue(doc, "//item/link", this.getEnvironmentData().getBaseUrl().toString() + "/browse/" + "HSP" + "-1", null);
        this.assertExpectedXpathValue(doc, "//item/description", TESTDESCRIP, null);
        this.assertExpectedXpathValue(doc, "//item/environment", TESTENVI, null);
        this.assertExpectedXpathValue(doc, "//item/resolution", "Unresolved", null);
        this.assertExpectedXpathValue(doc, "//item/votes", "0", null);
        this.assertExpectedXpathValue(doc, "//item/assignee", "Administrator", null);
        this.assertExpectedXpathValue(doc, "//item/assignee", "admin", "username");
        this.assertExpectedXpathValue(doc, "//item/reporter", "admin", "username");
        this.assertExpectedXpathValue(doc, "//item/fixVersion[1]", "New Version 1", null);
        this.assertExpectedXpathValue(doc, "//item/fixVersion[2]", "New Version 4", null);
        this.assertExpectedXpathValue(doc, "//item/version[1]", "New Version 1", null);
        this.assertExpectedXpathValue(doc, "//item/version[2]", "New Version 4", null);
        this.assertExpectedXpathValue(doc, "//item/attachments/attachment", "test.txt", "name");
        this.assertExpectedXpathValue(doc, "//item/attachments/attachment", "8", "size");
        this.assertExpectedXpathValue(doc, "//item/attachments/attachment", "admin", "author");
        this.assertExpectedXpathValue(doc, "//item/component[1]", "New Component 1", null);
        this.assertExpectedXpathValue(doc, "//item/key", ISSUE1, null);
        this.assertExpectedXpathValue(doc, "//item/comments/comment[1]", "admin", "author");
        this.assertExpectedXpathValue(doc, "//item/comments/comment[2]", "a nice comment", null);
        this.assertExpectedXpathValue(doc, "//item/comments/comment[3]", "10020", "id");
        this.assertExpectedXpathValue(doc, "//item/type", "Bug", null);
        this.assertExpectedXpathValue(doc, "//item/type", "1", "id");
        this.assertExpectedXpathValue(doc, "//item/priority", "Major", null);
        this.assertExpectedXpathValue(doc, "//item/priority", "3", "id");
        this.assertExpectedXpathValue(doc, "//item/status", "4", "id");
        this.assertExpectedXpathValue(doc, "//item/status", "Reopened", null);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "My test issue for resolved date");
        this.tester.submit("Create");
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("My test issue for resolved date");
        this.tester.assertTextPresent("Resolved");
        this.tester.clickLinkWithText("XML");
        TestXmlIssueView.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertElementExists(doc, "//item/created");
        this.assertElementExists(doc, "//item/updated");
        this.assertElementExists(doc, "//item/resolved");
    }

    private void assertElementExists(Document doc, String xPathExpression) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        TestXmlIssueView.assertNotNull((String)("Element at xpath '" + xPathExpression + "' should not be null"), (Object)element);
    }

    public void testRawRssView() throws IOException, ParseException {
        this.administration.restoreData("TestXMLIssueView.xml");
        this.navigation.issue().gotoIssue(ISSUE1);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("description", "some test data\n\n<badchars?>");
        this.tester.setFormElement("environment", "some test environment\n\n<badchars?>");
        this.tester.submit("Update");
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml?rssMode=raw");
        TestXmlIssueView.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/description", "<![CDATA[some test data\r\n\r\n<badchars?>]]>", null);
        this.assertExpectedXpathValue(doc, "//item/environment", "<![CDATA[some test environment\r\n\r\n<badchars?>]]>", null);
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml?rssMode=somebadmode");
        TestXmlIssueView.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/description", "some test data\r&lt;br/&gt;\n\r&lt;br/&gt;\n&amp;lt;badchars?&amp;gt;", null);
        this.assertExpectedXpathValue(doc, "//item/environment", "some test environment\r&lt;br/&gt;\n\r&lt;br/&gt;\n&amp;lt;badchars?&amp;gt;", null);
        this.tester.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestXmlIssueView.assertEquals((String)"text/xml", (String)this.tester.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/description", "some test data\r&lt;br/&gt;\n\r&lt;br/&gt;\n&amp;lt;badchars?&amp;gt;", null);
        this.assertExpectedXpathValue(doc, "//item/environment", "some test environment\r&lt;br/&gt;\n\r&lt;br/&gt;\n&amp;lt;badchars?&amp;gt;", null);
    }

    private void assertXpathElementNotPresent(Document doc, String xpathExpression) {
        XPath xPath = new XPath(xpathExpression);
        Element element = doc.getElement((IXPath)xPath);
        if (element != null) {
            TestXmlIssueView.fail((String)("XML document contains element on path: " + xpathExpression));
        }
    }

    public void assertExpectedXpathValue(Document doc, String xPathExpression, String expectedValue, String attribute) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        String actualValue = attribute == null ? element.getText().toString() : element.getAttribute(attribute);
        TestXmlIssueView.assertEquals((String)expectedValue, (String)actualValue);
        this.tester.gotoPage("/secure/project/ViewProjects.jspa");
    }

    public void testCustomFields() throws IOException, ParseException {
        this.administration.restoreData("TestXMLIssueView.xml");
        this.hideFields("//item/version", "Affects Version/s");
        this.hideFields("//item/assignee", "Assignee");
        this.hideFields("//item/component", "Component/s");
        this.hideFields("//item/due", "Due Date");
        this.hideFields("//item/environment", "Environment");
        this.hideFields("//item/fixVersion", "Fix Version/s");
        this.hideFields("//item/priority", "Priority");
        this.hideFields("//item/reporter", "Reporter");
        this.hideFields("//item/resolution", "Resolution");
        this.hideFields("//item/security", "Security Level");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTranslation() throws IOException, ParseException {
        try {
            this._testTranslation("//item/type", "Bug");
            this._testTranslation("//item/priority", "Major");
            this._testTranslation("//item/status", "Open");
            this._testTranslation("//item/resolution", "Unresolved");
        }
        finally {
            this.navigation.gotoDashboard();
            this.administration.restoreData("TestXMLIssueView.xml");
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.tester.clickLink("edit_prefs_lnk");
            this.tester.selectOption("userLocale", "English (UK)");
            this.tester.setWorkingForm("update-user-preferences");
            this.tester.submit();
        }
    }

    public void _testTranslation(String xpathexpr, String notExpected) throws IOException, ParseException {
        this.navigation.gotoDashboard();
        this.administration.restoreData("TestXMLIssueView.xml");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.setFormElement("userIssuesPerPage", "50");
        this.tester.selectOption("userLocale", "Deutsch (Deutschland)");
        this.tester.submit();
        this.navigation.issue().createIssue(null, null, "Testing German");
        this.tester.clickLinkWithText("XML");
        Document doc = this.getDocument();
        XPath xPath = new XPath(xpathexpr);
        Element element = doc.getElement((IXPath)xPath);
        element.getElement((IXPath)xPath);
        TestXmlIssueView.assertNotSame((String)("Test if" + notExpected + "was translated"), (Object)element.getText().toString(), (Object)notExpected);
    }

    private void hideFields(String findNode, String fieldToHide) throws IOException, ParseException {
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields(fieldToHide);
        this.navigation.issue().gotoIssue(ISSUE1);
        this.tester.clickLinkWithText("XML");
        Document doc = this.getDocument();
        XPath xPath = new XPath(findNode);
        Element element = doc.getElement((IXPath)xPath);
        TestXmlIssueView.assertNull((String)("Testing that " + fieldToHide + " node is NOT shown in xml view if hidden"), (Object)element);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields(fieldToHide);
    }

    private Document getDocument() throws IOException, ParseException {
        InputStream inputStream = this.tester.getDialog().getResponse().getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        return new Document(outputStream.toByteArray());
    }
}

