/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestVotersWhenVotePermissionSetToUserPickerCustomField
extends FuncTestCase {
    private static final String ISSUE_KEY = "TP-1";
    private static final String ISSUE_ID = "10000";
    private static final String USER_NOT_SELECTED_ON_USER_PICKER = "admin";
    private static final String USER_SELECTED_ON_USER_PICKER = "test";

    @Override
    protected void setUpTest() {
        this.restoreJiraWithVotedIssueInProjectWhereVotersCanOnlyBeSeenByUserSpecifiedOnUserPicker();
    }

    public void testIssueCanNotBeVotedByADifferentUserAsTheOneSpecifiedOnTheUserPickerCustomField() {
        this.navigation.login(USER_NOT_SELECTED_ON_USER_PICKER);
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.assertUserCanNotVoteUsingTheLinksOnThePeopleSection();
        this.assertUserCanNotNavigateDirectlyToTheViewVoteHistoryPage(ISSUE_ID);
    }

    public void testIssueCanBeVotedByTheUserSpecifiedOnTheUserPickerCustomField() {
        this.navigation.login(USER_SELECTED_ON_USER_PICKER);
        this.navigation.issue().gotoIssue(ISSUE_KEY);
        this.assertUserCanVoteUsingTheLinksOnThePeopleSection();
        this.assertUserCanNavigateDirectlyToTheViewVoteHistoryPage(ISSUE_ID);
    }

    private void assertUserCanVoteUsingTheLinksOnThePeopleSection() {
        this.tester.assertLinkPresent("vote-toggle");
        this.tester.assertLinkPresent("view-voter-list");
    }

    private void assertUserCanNotVoteUsingTheLinksOnThePeopleSection() {
        this.tester.assertLinkNotPresent("vote-toggle");
        this.tester.assertLinkNotPresent("view-voter-list");
    }

    private void assertUserCanNavigateDirectlyToTheViewVoteHistoryPage(String issueId) {
        this.navigateToViewVoteHistoryPage(issueId);
        this.tester.assertTextPresent("Vote history");
    }

    private void assertUserCanNotNavigateDirectlyToTheViewVoteHistoryPage(String issueId) {
        this.navigateToViewVoteHistoryPage(issueId);
        this.tester.assertTextPresent("Access Denied");
    }

    private void navigateToViewVoteHistoryPage(String issueId) {
        this.navigation.gotoPage(String.format("secure/ViewVoters!default.jspa?id=" + issueId, new Object[0]));
    }

    private void restoreJiraWithVotedIssueInProjectWhereVotersCanOnlyBeSeenByUserSpecifiedOnUserPicker() {
        this.administration.restoreData("TestVotersWhenVotePermissionSetToUserPickerCustomField.xml");
    }
}

