/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestViewIssue
extends JIRAWebTest {
    private static final String CLASSNAME_SUBTASK_PERCENTAGE_CELL = "progress";

    public TestViewIssue(String name) {
        super(name);
    }

    public void testSpeed() {
        this.administration.restoreBlankInstance();
    }

    public void testViewIssuePageWithInvalidAssigneeAndReporters() {
        this.restoreData("TestViewIssueWithInvalidUsersProEnt.xml");
        this.administration.attachments().enable();
        this._testViewIssuePageWithInvalidAssigneeAndReportersStandard();
        this._testViewIssuePageWithInvalidAssigneeAndReportersProEnt();
    }

    public void testEditedCommentVisibleWithDoubleQuotesInDateFormat() {
        this.restoreData("TestEditedCommentAndWorklogWithMalformedDateFormat.xml");
        this.gotoIssueTabPanel("HSP-1", "Comments");
        this.assertTextPresentBeforeText("this comment is edited", "this comment will not be edited");
        this.assertTextPresent("title=\"Administrator - 24/Jul/07 09:47 AM&quot; \"");
        Assert.assertThat((Object)this.locator.css(".commentdate_10012_concise span time").getText(), (Matcher)JUnitMatchers.containsString((String)"25/Jul/07 09:48 AM\""));
        Assert.assertThat((Object)this.locator.css(".commentdate_10012_verbose span time").getText(), (Matcher)JUnitMatchers.containsString((String)"25/Jul/07 09:48 AM\""));
        this.gotoIssueTabPanel("HSP-1", "Work Log");
        this.assertTextPresentBeforeText("this work log is edited", "this work log will not be edited");
        this.assertTextPresent("title=\"Administrator - 18/Jul/07 09:42 AM&quot; \"");
        Assert.assertThat((Object)this.locator.css("#worklog-10001 .actionContainer .action-details .date").getText(), (Matcher)JUnitMatchers.containsString((String)"18/Jul/07 09:43 AM\""));
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersStandard() {
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Issue with valid user");
        IdLocator locator = new IdLocator(this.tester, "assignee-val");
        this.text.assertTextPresent(locator, "Administrator");
        locator = new IdLocator(this.tester, "reporter-val");
        this.text.assertTextPresent(locator, "Administrator");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@id='customfield_10000-val']"), "Administrator");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@id='customfield_10001-val']"), "Administrator");
        this.assertLinkPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresent("view-voters");
        this.assertLinkPresent("manage-watchers");
        this.assertLinkPresentWithText("Log work");
        this.gotoIssue("HSP-2");
        this.assertTextPresent("Issue with invalid users");
        this.text.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "deletedassignee");
        this.text.assertTextPresent(new IdLocator(this.tester, "reporter-val"), "deletedreporter");
        this.assertElementPresent("customfield_10000-val");
        this.assertElementPresent("customfield_10001-val");
        this.assertions.assertNodeDoesNotExist("//dd[@id='customfield_10001-val']//a");
        this.assertLinkPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresent("view-voters");
        this.assertLinkPresent("manage-watchers");
        this.assertLinkPresentWithText("Log work");
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersProEnt() {
        this.gotoIssue("HSP-2");
        this.assertLinkPresentWithText("sub-task");
        this.assertLinkPresentWithText("Sub task with invalid user");
        this.gotoIssue("HSP-3");
        this.assertTextPresent("Sub task with invalid user");
        this.text.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "deletedsubtaskuser");
        this.text.assertTextPresent(new IdLocator(this.tester, "reporter-val"), "deletedsubtaskuser");
        this.assertElementPresent("customfield_10000-val");
        this.assertElementPresent("customfield_10001-val");
        this.assertions.assertNodeDoesNotExist("//dd[@id='customfield_10001-val']//a");
        this.assertLinkNotPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresent("view-voters");
        this.assertLinkPresent("manage-watchers");
        this.assertLinkPresentWithText("Log work");
    }

    public void testSubtaskPercentageGraphPresence() {
        this.restoreBlankInstance();
        this.activateSubTasks();
        this.activateTimeTracking();
        String parentKey = this.addIssue("monkey", "MKY", "Bug", "bonobo");
        String sub1Key = this.addSubTaskToIssue(parentKey, "Sub-task", "sub1", "subdesc1");
        this.gotoIssue(parentKey);
        TestViewIssue.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.addSubTaskToIssue(parentKey, "Sub-task", "sub2", "subdesc2");
        this.gotoIssue(parentKey);
        TestViewIssue.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.gotoIssue(sub1Key);
        this.setEstimate("1m");
        this.gotoIssue(parentKey);
        TestViewIssue.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.logWork(sub1Key, "1m", "1m");
        this.clickLink("parent_issue_summary");
        TestViewIssue.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.assertTextPresent("50%");
        this.enableDeleteAllWorklogInDefaultPermissionScheme("jira-administrators");
        this.gotoIssue(sub1Key);
        if (this.getDialog().isLinkPresentWithText("Work Log")) {
            this.clickLinkWithText("Work Log");
        }
        this.clickLink("delete_worklog_10000");
        this.submit("Delete");
        this.gotoIssue(parentKey);
        TestViewIssue.assertTrue((String)"Expected to still see graph after worklog deletion, original estimate remains", (boolean)this.isSubtaskPercentageGraphPresent());
    }

    public void testProjectCFNotLinkedWithNoPermission() {
        this.restoreData("TestProjectCFWithNoPermission.xml");
        this.login("fred");
        this.gotoIssue("HSP-2");
        this.assertLinkWithTextExists("project CF is visible in HSP-2", "homosapien");
        this.gotoIssue("HSP-1");
        this.assertLinkWithTextNotPresent("project CF is not visible in HSP-1", "monkey");
        this.assertTextPresent("monkey");
        this.login("admin");
        this.gotoIssue("HSP-1");
        this.assertLinkWithTextExists("project CF is visible in HSP-1 to admin", "monkey");
    }

    public void testComponentOrdering() {
        this.restoreBlankInstance();
        TestViewIssue.log("Testing ordering for components field");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Test issue");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Create");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 3"});
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 2", "New Component 3"});
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2", "New Component 3"});
    }

    public void testVersionOrdering() {
        this.restoreBlankInstance();
        String[] versionFields = new String[]{"versions", "fixVersions"};
        String[] versionFieldNames = new String[]{"Affects Version/s", "Fix Version/s"};
        for (int i = 0; i < versionFields.length; ++i) {
            String versionField = versionFields[i];
            String versionFieldName = versionFieldNames[i];
            TestViewIssue.log("Testing ordering for versions field '" + versionField + "'");
            this.tester.clickLink("create_link");
            this.tester.submit("Next");
            this.tester.setFormElement("summary", "Test issue");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Create");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 5"});
            this.tester.clickLink("edit-issue");
            this.tester.setWorkingForm("issue-edit");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 4", "New Version 5"});
            this.tester.clickLink("edit-issue");
            this.tester.setWorkingForm("issue-edit");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4"});
            this.tester.clickLink("edit-issue");
            this.tester.setWorkingForm("issue-edit");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4", "New Version 5"});
        }
    }

    public void testFieldTabs() throws Exception {
        this.restoreData("TestIssueFields.xml");
        this.gotoIssue("HSP-1");
        this.assertElementNotPresent("customfieldmodule");
        this.gotoIssue("HSP-3");
        this.assertElementPresent("customfieldmodule");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.gotoIssue("HSP-2");
        this.assertElementPresent("customfieldmodule");
        this.assertLinkWithTextNotPresent("This issue should have only one tab.", "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10001), "Tab2CF");
    }

    public void testDateCustomFieldTabs() throws Exception {
        this.restoreData("TestIssueFields.xml");
        this.gotoIssue("HSP-3");
        this.assertions.assertNodeDoesNotExist("//*[@id='datesmodule']//*[contains(@id, 'customfield')]");
        this.gotoIssue("HSP-4");
        this.assertElementNotPresent("customfieldmodule");
        this.text.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateCFTab2", "26/Jan/10");
        this.gotoIssue("HSP-5");
        this.assertElementNotPresent("customfieldmodule");
        this.text.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateTimeCFTab1", "03/Jan/10", "DateTimeCFTab2", "29/Jan/10");
        this.gotoIssue("HSP-6");
        this.assertElementPresent("customfieldmodule");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.text.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateTimeCFTab1", "04/Jan/10", "DateTimeCFTab2", "12/Jan/10", "DateCFTab2", "19/Jan/10");
    }

    public void testUserCustomFieldTabs() throws Exception {
        this.restoreData("TestIssueFields.xml");
        this.gotoIssue("HSP-3");
        this.assertions.assertNodeDoesNotExist("//*[@id='peopledetails']//*[contains(@id, 'customfield')]");
        this.gotoIssue("HSP-7");
        this.assertElementNotPresent("customfieldmodule");
        this.text.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "Administrator");
        this.gotoIssue("HSP-8");
        this.assertElementPresent("customfieldmodule");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.text.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "Administrator", "MultiGroupPickerCF", "jira-developers", "jira-users", "GroupPickerCF", "jira-administrators", "MultiUserPickerCF", "Administrator", "Fred Normal");
    }

    public void testUserCustomFieldWithMissingUsers() throws Exception {
        this.restoreData("TestIssueFields.xml");
        this.gotoIssue("HSP-9");
        this.assertElementPresent("customfieldmodule");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-1"), "Tab1");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-1", 10000), "Tab1CF");
        this.text.assertTextPresent(this.createCFTabLocator("customfield-panel-2"), "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("customfield-panel-2", 10001), "Tab2CF");
        this.text.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "admin-xx", "MultiGroupPickerCF", "jira-developers", "jira-users", "GroupPickerCF", "jira-administrators", "MultiUserPickerCF", "Administrator", "fred-xx");
        this.assertLinkNotPresentWithText("admin-xx");
        this.assertLinkNotPresentWithText("fred-xx");
    }

    public void testXssInImageUrls() throws Exception {
        this.administration.restoreData("TestImageUrlXss.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextNotPresent("\"'/><script>alert('prioritiezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('prioritiezz');&lt;/script&gt;");
        this.tester.assertTextNotPresent("\"'/><script>alert('issue typezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('issue typezz');&lt;/script&gt;");
    }

    @WebTest(value={Category.TIME_ZONES})
    public void testDatesShouldBeDisplayedInUserTimeZoneInViewIssuePage() throws Exception {
        String MKY_1 = "MKY-1";
        String HONG_KONG = "Asia/Hong_Kong";
        String HONOLULU = "Pacific/Honolulu";
        String PAPUA_NEW_GUINEA = "Pacific/Port_Moresby";
        String CREATED_HK = "06/Mar/11 9:36 AM";
        String CREATED_HON = "05/Mar/11 3:36 PM";
        String CREATED_PNG = "06/Mar/11 11:36 AM";
        String UPDATED_HK = "06/Mar/11 9:43 AM";
        String UPDATED_HON = "05/Mar/11 3:43 PM";
        String UPDATED_PNG = "06/Mar/11 11:43 AM";
        String RESOLVED_HK = "06/Mar/11 9:41 AM";
        String RESOLVED_HON = "05/Mar/11 3:41 PM";
        String RESOLVED_PNG = "06/Mar/11 11:41 AM";
        String DATETIME_CF_HK = "09/Jun/11 6:30 AM";
        String DATETIME_CF_HON = "08/Jun/11 12:30 PM";
        String DATETIME_CF_PNG = "09/Jun/11 8:30 AM";
        String WORKLOG_HK = "06/Mar/11 9:38 AM";
        String WORKLOG_HON = "05/Mar/11 3:38 PM";
        String WORKLOG_PNG = "06/Mar/11 11:38 AM";
        String HISTORY_HK = "06/Mar/11 9:38 AM";
        String HISTORY_HON = "05/Mar/11 3:38 PM";
        String HISTORY_PNG = "06/Mar/11 11:38 AM";
        this.administration.restoreData("TestIssueFields.xml");
        this.administration.generalConfiguration().setDefaultUserTimeZone("Asia/Hong_Kong");
        this.navigation.issue().gotoIssue("MKY-1");
        Assert.assertThat((Object)this.createdDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:36 AM"));
        Assert.assertThat((Object)this.updatedDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:43 AM"));
        Assert.assertThat((Object)this.resolvedDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:41 AM"));
        Assert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)CoreMatchers.equalTo((Object)"09/Jun/11 6:30 AM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        Assert.assertThat((Object)this.worklogDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:38 AM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        Assert.assertThat((Object)this.changeHistoryDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:38 AM"));
        this.navigation.userProfile().changeUserTimeZone("Pacific/Port_Moresby");
        this.navigation.issue().gotoIssue("MKY-1");
        Assert.assertThat((Object)this.createdDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 11:36 AM"));
        Assert.assertThat((Object)this.updatedDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 11:43 AM"));
        Assert.assertThat((Object)this.resolvedDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 11:41 AM"));
        Assert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)CoreMatchers.equalTo((Object)"09/Jun/11 8:30 AM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        Assert.assertThat((Object)this.worklogDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 11:38 AM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        Assert.assertThat((Object)this.changeHistoryDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 11:38 AM"));
        this.navigation.login("fred");
        this.navigation.userProfile().changeUserTimeZone("Pacific/Honolulu");
        this.navigation.issue().gotoIssue("MKY-1");
        Assert.assertThat((Object)this.createdDate(), (Matcher)CoreMatchers.equalTo((Object)"05/Mar/11 3:36 PM"));
        Assert.assertThat((Object)this.updatedDate(), (Matcher)CoreMatchers.equalTo((Object)"05/Mar/11 3:43 PM"));
        Assert.assertThat((Object)this.resolvedDate(), (Matcher)CoreMatchers.equalTo((Object)"05/Mar/11 3:41 PM"));
        Assert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)CoreMatchers.equalTo((Object)"08/Jun/11 12:30 PM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        Assert.assertThat((Object)this.worklogDate(), (Matcher)CoreMatchers.equalTo((Object)"05/Mar/11 3:38 PM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        Assert.assertThat((Object)this.changeHistoryDate(), (Matcher)CoreMatchers.equalTo((Object)"05/Mar/11 3:38 PM"));
        this.navigation.logout();
        this.navigation.issue().gotoIssue("MKY-1");
        Assert.assertThat((Object)this.createdDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:36 AM"));
        Assert.assertThat((Object)this.updatedDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:43 AM"));
        Assert.assertThat((Object)this.resolvedDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:41 AM"));
        Assert.assertThat((Object)this.dateTimeCfTab1(), (Matcher)CoreMatchers.equalTo((Object)"09/Jun/11 6:30 AM"));
        this.navigation.issue().gotoIssueWorkLog("MKY-1");
        Assert.assertThat((Object)this.worklogDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:38 AM"));
        this.navigation.issue().gotoIssueChangeHistory("MKY-1");
        Assert.assertThat((Object)this.changeHistoryDate(), (Matcher)CoreMatchers.equalTo((Object)"06/Mar/11 9:38 AM"));
    }

    @WebTest(value={Category.TIME_ZONES})
    public void testDueDateShouldBeDisplayedInSystemTimeZone() throws Exception {
        String MKY_1 = "MKY-1";
        String HONG_KONG = "Asia/Hong_Kong";
        String HONOLULU = "Pacific/Honolulu";
        String PAPUA_NEW_GUINEA = "Pacific/Port_Moresby";
        String DUE_DATE_STRING = "10/Jan/99";
        this.administration.restoreData("TestIssueFields.xml");
        this.navigation.issue().gotoIssue("MKY-1");
        this.navigation.issue().setDueDate("MKY-1", "10/Jan/99");
        Assert.assertThat((Object)this.dueDate(), (Matcher)CoreMatchers.equalTo((Object)"10/Jan/99"));
        this.administration.generalConfiguration().setDefaultUserTimeZone("Asia/Hong_Kong");
        this.navigation.issue().gotoIssue("MKY-1");
        Assert.assertThat((Object)this.dueDate(), (Matcher)CoreMatchers.equalTo((Object)"10/Jan/99"));
        this.navigation.issue().setDueDate("MKY-1", "10/Jan/99");
        Assert.assertThat((Object)this.dueDate(), (Matcher)CoreMatchers.equalTo((Object)"10/Jan/99"));
        this.navigation.userProfile().changeUserTimeZone("Pacific/Port_Moresby");
        this.navigation.issue().gotoIssue("MKY-1");
        Assert.assertThat((Object)this.dueDate(), (Matcher)CoreMatchers.equalTo((Object)"10/Jan/99"));
        this.navigation.issue().setDueDate("MKY-1", "10/Jan/99");
        Assert.assertThat((Object)this.dueDate(), (Matcher)CoreMatchers.equalTo((Object)"10/Jan/99"));
    }

    private String createdDate() {
        return this.locator.css("#create-date").getText();
    }

    private String dueDate() {
        return this.locator.css("#due-date").getText();
    }

    private String updatedDate() {
        return this.locator.css("#updated-date").getText();
    }

    private String resolvedDate() {
        return this.locator.css("#resolved-date").getText();
    }

    private String dateTimeCfTab1() {
        return this.locator.css("#customfield_10010-val").getText();
    }

    private String worklogDate() {
        return this.locator.xpath("//*[@id='worklog-10000']//*[@class='subText']").getText();
    }

    private String changeHistoryDate() {
        return this.locator.css("#changehistorydetails_10030 time").getText();
    }

    private Locator createCFValueLocator(String tab, int id) {
        return new XPathLocator(this.tester, String.format("//*[@id='%s']//*[@id='customfield_%d-val']", tab, id));
    }

    private Locator createCFTabLocator(String tab) {
        return new XPathLocator(this.tester, String.format("//a[@href='#%s']", tab));
    }

    private void enableDeleteAllWorklogInDefaultPermissionScheme(String groupName) {
        TestViewIssue.log("enabling delete all worklog deletion in default permission scheme for group " + groupName);
        this.getAdministration().permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.DELETE_ALL_WORKLOGS.permissionKey(), groupName);
    }

    private boolean isSubtaskPercentageGraphPresent() {
        WebTable issueSummary = this.getDialog().getWebTableBySummaryOrId("issuetable");
        TableCell percentageCell = issueSummary.getTableCell(0, 5);
        return CLASSNAME_SUBTASK_PERCENTAGE_CELL.equals(percentageCell.getClassName());
    }
}

