/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS})
public class TestTextFieldCharacterLengthValidator
extends FuncTestCase {
    private static final String DESCRIPTION_FORM_ELEMENT_NAME = "description";
    private static final String ENVIRONMENT_FORM_ELEMENT_NAME = "environment";
    private static final int LIMIT = 100;
    private static final String EXPECTED_WARNING_MESSAGE = "The entered text is too long. It exceeds the allowed limit of 100 characters.";
    private final String largeText = TestTextFieldCharacterLengthValidator.createTooLongText(100);
    private final String tooLargeText = TestTextFieldCharacterLengthValidator.createTooLongText(101);

    @Override
    protected void setUpTest() {
        Assert.assertThat((String)"expecting a text not longer than 100 characters", (Object)this.largeText.length(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100)))));
        Assert.assertThat((String)"expecting a text longer than 100 characters", (Object)this.tooLargeText.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100))));
        this.administration.restoreData("TestEditIssue.xml");
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(100L);
    }

    public void testDescriptionAndEnvironmentSystemField() throws Exception {
        this.runCreateIssueWithVeryLongDescriptionTextTest();
        this.runCreateIssueWithTooLongDescriptionTextTest();
        this.runCreateIssueWithVeryLongEnvironmentTextTest();
        this.runCreateIssueWithTooLongEnvironmentTextTest();
        this.runEditIssueWithVeryLongDescriptionTextTest();
        this.runEditIssueWithTooLongDescriptionTextTest();
        this.runEditIssueWithVeryLongEnvironmentTextTest();
        this.runEditIssueWithTooLongEnvironmentTextTest();
    }

    private void runCreateIssueWithVeryLongDescriptionTextTest() {
        this.createIssue("Issue with very long description text", DESCRIPTION_FORM_ELEMENT_NAME, this.largeText);
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
    }

    private void runCreateIssueWithTooLongDescriptionTextTest() {
        this.createIssue("Issue with too long description text", DESCRIPTION_FORM_ELEMENT_NAME, this.tooLargeText);
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(EXPECTED_WARNING_MESSAGE);
    }

    private void runCreateIssueWithVeryLongEnvironmentTextTest() {
        this.createIssue("Issue with very long environment text", ENVIRONMENT_FORM_ELEMENT_NAME, this.largeText);
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
    }

    private void runCreateIssueWithTooLongEnvironmentTextTest() {
        this.createIssue("Issue with too long environment text", ENVIRONMENT_FORM_ELEMENT_NAME, this.tooLargeText);
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(EXPECTED_WARNING_MESSAGE);
    }

    private void runEditIssueWithVeryLongDescriptionTextTest() {
        this.editIssue(DESCRIPTION_FORM_ELEMENT_NAME, this.largeText);
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
    }

    private void runEditIssueWithTooLongDescriptionTextTest() {
        this.editIssue(DESCRIPTION_FORM_ELEMENT_NAME, this.tooLargeText);
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(EXPECTED_WARNING_MESSAGE);
    }

    private void runEditIssueWithVeryLongEnvironmentTextTest() {
        this.editIssue(ENVIRONMENT_FORM_ELEMENT_NAME, this.largeText);
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
    }

    private void runEditIssueWithTooLongEnvironmentTextTest() {
        this.editIssue(ENVIRONMENT_FORM_ELEMENT_NAME, this.tooLargeText);
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg(EXPECTED_WARNING_MESSAGE);
    }

    private void createIssue(String summaryValue, String formElementName, String formElementValue) {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", summaryValue);
        this.tester.setFormElement(formElementName, formElementValue);
        this.tester.submit("Create");
    }

    private void editIssue(String formElementName, String formElementValue) {
        this.navigation.issue().gotoEditIssue("HSP-1");
        this.tester.setFormElement(formElementName, formElementValue);
        this.tester.submit();
    }

    private static String createTooLongText(int numberOfCharacters) {
        return RandomStringUtils.random((int)numberOfCharacters, (char[])"abcdefghijklmnopqrstuvwxyz ".toCharArray());
    }
}

