/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
public class TestSearchXmlView
extends FuncTestCase {
    private static final String HTML_FRAGMENT = "/--><html><body>hi</body>;<!--";
    private static final String HTML_FRAGMENT_ENCODED = StringEscapeUtils.escapeXml((String)"/--><html><body>hi</body>;<!--");

    public void testFilterAllIssues() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=200");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        TestSearchXmlView.assertEquals((int)3, (int)nodes.size());
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[MKY-1]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[HSP-2]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(2)).getText().startsWith("[HSP-1]"));
    }

    public void testFilterAllIssuesWithCustomSort() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=200&sorter/field=issuekey&sorter/order=ASC");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        TestSearchXmlView.assertEquals((int)3, (int)nodes.size());
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[HSP-1]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[HSP-2]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(2)).getText().startsWith("[MKY-1]"));
    }

    public void testFilterAllIssuesWithCustomSortAndPaging() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=2&sorter/field=issuekey&sorter/order=ASC&pager/start=1");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        TestSearchXmlView.assertEquals((int)2, (int)nodes.size());
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[HSP-2]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[MKY-1]"));
    }

    public void testSearchRequestXMLViewEncodesQueryString() throws IOException {
        this.administration.restoreBlankInstance();
        String linkKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue to link to");
        this.tester.gotoPage(String.format("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?tempMax=10000&jqlQuery=&%s", HTML_FRAGMENT));
        String responseText = this.tester.getDialog().getResponse().getText();
        Assert.assertThat((Object)responseText, (Matcher)StringContains.containsString((String)HTML_FRAGMENT_ENCODED));
        Assert.assertThat((Object)responseText, (Matcher)CoreMatchers.not((Matcher)StringContains.containsString((String)HTML_FRAGMENT)));
    }

    private long createFilterForAllIssues() {
        return Long.parseLong(this.backdoor.filters().createFilter("", "All Issues"));
    }

    private Document getDocument(WebTester tester) throws IOException, DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(tester.getDialog().getResponse().getInputStream());
    }
}

